#include <iostream.h>
#include "internat.h"

const char *FrenchTags[] = { "fra", "frb", "frc", 0 };
const char *FrenchNames[] =
{
  "Dimanche", "Lundi", "Mardi", "Mercredi", "Jeudi", "Vendredi", "Samedi",
  "Dim", "Lun", "Mar", "Mer", "Jeu", "Ven", "Sam",
  "Janvier", "Fevrier", "Mars", "Avril", "Mai", "Juin",
  "Juillet", "Aout", "Septembre", "Octobre", "Novembre", "Decembre",
  "Jan", "Fev", "Mar", "Avr", "Mai", "Jun",
  "Jul", "Aou", "Sep", "Oct", "Nov", "Dec"
};

int main()
{
  International::AddLanguage(LanguageRecord(FrenchTags, FrenchNames));
  cout << "Country = " << International::Country() << endl;
  cout << "Language = " << International::Language() << endl;
  cout << "Time = " << TimeString() << endl;
  cout << "Long Time = " << LongTimeString() << endl;
  cout << "Date = " << DateString() << endl;
  cout << "Long Date = " << LongDateString() << endl;
  cout << "Currency = " << CurrencyString(12345678.90) << endl;
  cout << "Negative Currency = " << CurrencyString(-12345678.90) << endl;
  cout << "Number = " << NumberString(12345678.90, 6) << endl;
  return 0;
}

