#ifndef __INTERNAT_H__
#define __INTERNAT_H__

#include <string.h>
#include <alloc.h>
#include <time.h>

inline char *_strdup(const char *s) { return (s) ? strdup(s) : 0; }
inline void _free(void *v) { if (v) free(v); }

class CString
{
  protected:
    char *contents;
  public:
    CString(const char *s = 0) : contents(_strdup(s)) {}
    ~CString() { _free(contents); }
    operator const char *() { return (contents) ? contents : ""; }
    CString &operator =(CString &s) { _free(contents); contents = _strdup(s); return *this; }
    CString &operator =(char *s)    { _free(contents); contents = _strdup(s); return *this; }
};

class Profile
{
  protected:
    char *section;
    char *entry;
    char *def;
    int idef;
  public:
    Profile(char *s, char *e, char *d) : section(s), entry(e), def(d) {}
    Profile(char *s, char *e, int i) : section(s), entry(e), def(0), idef(i) {}
    friend CString &operator << (CString &, Profile &);
    friend int &operator << (int &, Profile &);    
};

class LanguageList;

class LanguageRecord
{
  protected:
    const char **tags;
    const char **strings;
    LanguageRecord *next;
  public:
    friend LanguageList;
    LanguageRecord(const char **t, const char **s) : tags(t), strings(s), next(0) {}
    LanguageRecord(LanguageRecord &l) : tags(l.tags), strings(l.strings), next(0) {}
    int operator ==(const char *s);
    const char *DayName(int d, int l = 0) { return strings[d+7-7*l]; }
    const char *MonthName(int m, int l = 0) { return strings[14+m+12-12*l]; }
};

class International
{
  protected:
    static CString sLanguage;
    static CString sCountry;
    static int iCountry;
    static int iDate;
    static int iTime;
    static int iTLZero;
    static int iCurrency;
    static int iCurrDigits;
    static int iNegCurr;
    static int iLzero;
    static int iDigits;
    static int iMeasure;
    static CString s1159;
    static CString s2359;
    static CString sCurrency;
    static CString sThousand;
    static CString sDecimal;
    static CString sDate;
    static CString sTime;
    static CString sList;
    static CString sShortDate;
    static CString sLongDate;
    static International TheInfo;
    static LanguageList Languages;
    void ReadInfo();
    International();
  public:
    static void AddLanguage(LanguageRecord &);
    static const char *Language() { return sLanguage; }
    static const char *Country() { return sCountry; }
    static int CountryCode() { return iCountry; }
    static int DateFormat()  { return iDate; } // obsolete
    static int TimeFormat() { return iTime; }
    static int TimeHours() { return (iTime + 1) * 12; }
    static int TimeDigits() { return iTLZero+1; }
    static int CurrencyFormat(int neg = 0) { return (neg) ? iNegCurr : iCurrency; }
    static int CurrencyDigits() { return iCurrDigits; }
    static int LeadZero() { return iLzero; }
    static int DecimalDigits() { return iDigits; }
    static int Measure() { return iMeasure; }
    static const char *AM() { return s1159; }
    static const char *PM() { return s2359; }
    static const char *CurrencySymbol() { return sCurrency; }
    static char ThousandsSeparator() { return *sThousand; }
    static char DecimalPoint()  { return *sDecimal; }
    static char DateSeparator() { return *sDate; } // obsolete
    static char TimeSeparator() { return *sTime; }
    static const char *ShortDate() { return sShortDate;  }
    static const char *LongDate()  { return sLongDate; }
    static const char *MonthName(int, int);
    static const char *DayName(int, int);
};

class TimeString : public International
{
  protected:
    CString s;
    void MakeString(struct tm *, int);
  public:
    TimeString(time_t t = time(0), int f = 0) { MakeString(localtime(&t), f); }
    TimeString(struct tm *t, int f = 0) { MakeString(t, f); }
    operator const char *() { return s; }
};

class LongTimeString : public TimeString
{
  public:
    LongTimeString(time_t t = time(0)) : TimeString(t, 1) {}
    LongTimeString(struct tm *t) : TimeString(t, 1) {}
};

class DateString : public International
{
  protected:
    CString s;
    void MakeString(struct tm *, const char *);
  public:
    DateString(time_t t = time(NULL), const char *fmt = International::ShortDate())
    {
      MakeString(localtime(&t), fmt);
    }
    DateString(struct tm *t, const char *fmt = International::ShortDate())
    {
      MakeString(t, fmt);
    }
    operator const char *() { return s; }
};

class LongDateString : public DateString
{
  public:
    LongDateString(time_t t = time(NULL)) : DateString(t, LongDate()) {}
    LongDateString(struct tm *t) : DateString(t, LongDate()) {}
};

class NumberString : public International
{
  protected:
    CString s;
  public:
    NumberString(long double d, int = International::DecimalDigits());
    operator const char *() { return s; }
};

class CurrencyString : public International
{
  protected:
    CString s;
  public:
    CurrencyString(long double d);
    operator const char *() { return s; }
};

#endif
