/*  This file duplicates for Turbo C users the functions provided for
    Turbo Pascal users by Bela Lubkin in the infamous INT24.ARC file.
    It provides a neat and SIMPLE method of trapping all DOS critical
    errors (interrupt 24 errors) and allowing the programmer to decide
    how to proceed.

    The "library" consists of one variable declaration and three function
    declarations.  The variable "int24errorcode" is an integer that our
    interrupt 24 handler uses to store the last int24 error code.  That's
    all the handler does--it stores the DOS error code in int24errorcode,
    and then returns to the program.

    Needless to say, this handler does not do all that it could--Turbo C
    provides a facility similar to DOS' infamous "Abort, Retry, Ignore?"
    message.  If you look at the example given on page 136 of the Turbo C
    Reference Guide, you will notice that our int24 handler COULD tell
    DOS to ABORT, RETRY, or IGNORE the process by returning the appropriate
    value.  This handler, on the other hand, leaves all that up to the
    programmer--it just stores the error and returns to the program.

    In order to turn on the interrupt 24 trapping, just say "int24on ();".
    From this point on, a critical DOS error does not crash the program--
    instead, our handler takes over and stores the error code in a variable.
    Then, whenever you want to see what the current int24 code is, you should
    use the function int24result().  You should not access the variable
    int24errorcode directly, because it will not then be reset.  The
    function int24result() returns its current value and also resets it
    to -1, which indicates no error has occurred.

    The included file ERRTEST.C is a sample program showing how these
    functions work.  ERRTEST.EXE is that program compiled and linked to
    these functions--you can run that or compile it yourself with the
    file ERRTEST.PRJ.  For the integrated version of Turbo C, just hit
    Alt-P and return, and enter "ERRTEST".  Then F9 will compile it for
    you.

    Again, this is hardly a full treatment of DOS critical errors--it
    does, however, make it simple to see whether one has occurred.  For
    more information on this, see the Turbo c Reference guide entry for
    the function harderr().

    Turbo C provides no direct method of un-installing our interrupt
    handler, but the original DOS handler is restored on program exit.
    You could use the functions getvect() and setvect() for this purpose.

    Here is a list of (decimal) error codes that int24result will return
    and the errors that cause them:

               Code          Cause
               ____          ________________________________________

                00            write-protect error
                01            unknown unit
                02            drive not ready
                03            unknown command
                04            data error (bad CRC)
                05            bad request structure length
                06            seek error
                07            unknown media type
                08            sector not found
                09            printer out of paper
                10            write fault
                11            read fault
                12            general failure


                                                      Marty Del Vecchio
                                                      8/19/87


*/


#include <stdio.h>
#include <dos.h>

int int24errorcode = -1;       /*  Will hold our result code from int24    */
                               /*  You should not access this directly,    */
                               /*  but through the function int24result()  */

int handler (int errval, int ax, int bp, int si)  /*  This is the handler */
   {
   int24errorcode = errval; /*  The handler simply stores the error code   */
   hardretn (-1);           /*  in int24result and returns to the program  */
   }

void int24on ()
   {                        /*  This function installs our function as the */
   harderr (handler);       /*  DOS interrupt 24 handler                   */
   }

int int24result ()          /*  This function returns the current value of */
   { int i;                 /*  int24error and then sets it back to zero   */
   i = int24errorcode;
   int24errorcode = -1;
   return (i);
   }
