INSIDE! Turbo C



An Execution Analyzer for Turbo C
____________________________________________






















Paradigm Systems

The authors of this software make no expressed or implied warranty of
any kind with regard to this software and in no event will be liable for
incidental or consequential damages arising from the use of this
product.  The software described in this document is furnished under a
license and may only be used or copied in accordance with the terms of
the licensing agreement.

The information in this document is subject to change without notice.

Copyright (C) Paradigm Systems, Inc. 1988.  All rights reserved.

INSIDE!(tm) is a trademark of Paradigm Systems, Inc.

Microsoft(R), MS-DOS(R) and CodeView(R) are registered trademarks and
QuickC(tm) is trademark of Microsoft Corporation.

Turbo Pascal(R) and Turbo C(R) are registered trademarks of Borland
International, Inc.

IBM(R) is a registered trademark of International Business Machines
Corporation.

No part of this document may be copied or reproduced in any form or by
any means without the prior written consent of Paradigm Systems, Inc.



                         Paradigm Systems, Inc.
                              P.O. Box 152
                           Milford, MA  01757
                             (508)478-0499

Introduction

Welcome to INSIDE! Turbo C.  While you aren't quite there yet, you will
now be able try out the INSIDE! experience firsthand.  This manual
describes the use of the demonstration version of INSIDE! Turbo C.  This
software is a cut-down and restricted version of INSIDE! Turbo C and is
designed to allow an user to try out INSIDE! before buying.  Even then
it is not risky since Paradigm Systems offers a 30-day money back
guarantee if INSIDE! does not meet your requirements.


What is INSIDE!

INSIDE! Turbo C is a powerful execution analyzer used to fine tune and
optimize programs compiled with Turbo C 1.5.  The purpose of an
execution analyzer is to provide the software developer with detailed
timing and execution information so intelligent decisions can be made
concerning the selection of algorithms and the use of alternate coding
styles.  Run under the control of INSIDE!, programs developed with Turbo
C release valuable timing statistics which can help you in delivering
the highest possible performance without the use of time consuming
prototyping and analysis sessions.

INSIDE! is not just for the professional software developer trying to
wring the last few milliseconds from an application.  Because it can
perform a detailed timing or source line analysis in a flash, INSIDE! is
an ideal tool for students of computer programming, whether in formal
classroom training or just studying at home.  INSIDE! can quickly
pinpoint program bottlenecks and highlight even the subtlest tradeoffs
of alternate algorithms or coding techniques.  Because of its power,
flexibility and ease of use, INSIDE! is a must for anyone who programs
using Turbo C.

INSIDE! differs greatly from other execution analyzers you may have
previously encountered.  First of all, this version of INSIDE! has been
designed exclusively for use with Turbo C 1.5.  This state-of-the art
compiler has a number of optimization techniques which for the first
time can be analyzed on a function or source line basis with
unprecedented accuracy.  Because of the detailed information collected,
INSIDE! gives software developers using Turbo C access to information
which can help them make the most of the optimizing features of the
compiler and their own coding techniques.

INSIDE! collects data in one of two modes depending on the information
you need to know about your program.  The default operating mode for
INSIDE! is the timing analysis mode.  This mode analyzes the timing
characteristics of the target program function by function with the
output being statistics such as:

     -  execution count (the number of times a routine has executed)
     -  fastest execution time
     -  slowest execution time
     -  total execution time (sum of all execution times)
     -  percentage of total execution time

To show the power and flexibility of INSIDE! Turbo C, here is some
sample output from a typical timing analysis.

  Execution time analysis (Times are in milliseconds)
    Count         Min       Max     Total       %  Function
        1    1479.899  1479.899  1479.899   87.51  QSORT:sort
        1     211.127   211.127   211.127   12.49  QSORT:qsort
  =======                      ==========
        2                        1691.026
  
  Program elapsed time: 1968.571 ms
  Termination normal with exit code = 0


The other operating mode for INSIDE! is the line analysis mode.  Once we
have an idea that a particular function or procedure needs a closer
analysis, we need to know how often the individual source lines within a
source module are being executed.  By enabling the line analysis mode,
INSIDE! will collect and display results for one or more source modules
in a program on a line by line basis.


                    Line      Count       %
                     ...
                     121        360    0.57
                     122        360    0.57
                     140       4360    6.96
                     ...
  
  Program elapsed time: 23130.078 ms
  Termination normal with exit code = 0
  A total of 62661 source lines were analyzed


Just as the timing analysis mode pointed out which functions might be
candidates for optimization, information from the line analysis mode
helps determine which source lines are the most likely candidates for
optimization.


Ease of Use

While accurate results are nice, if a tool sits idle because it is too
difficult to learn or use, you are better off not buying the tool in the
first place.  This is another area where INSIDE! works with you rather
than against you.  INSIDE! was designed from scratch with the
requirements of both the professional and amateur software developer in
mind.  INSIDE! makes few assumptions about your requirements and instead
is adjusts itself to your needs rather than making you deal with an
entirely new set of rules.

Because INSIDE! Turbo C understands the proprietary debugging records
generated by Turbo C, there is never a need for setup or configuration
prior to beginning a performance analysis session.  Using INSIDE! is as
simple as compiling your program just as if you were preparing for
debugging.  In the case of Turbo C it is as simple as

     tcc -y -M demo
     intc demo

By having the inside advantage (pun intended), INSIDE! has access to all
functions and procedures in a module, not just those that have public
scope.  This means that every function and procedure within a program
can be analyzed, not just those that appear in a link map.  INSIDE! also
works where you are right now.  Often the input data makes a more
important contribution to throughput than program design and the data is
scattered across multiple subdirectories.  This is never a problem since
INSIDE! will search for the target program along the standard DOS PATH
so applications can always be immediately analyzed without delay.


What's Missing?

Since we can't give the entire package away for free, there is obviously
something missing.  In the demonstration version, the following
commands/features are disabled:

     - no benchmark mode
     - output always sent to console
     - no DOS timing mode
     - no comments
     - no ability to include/exclude modules
     - no memory size analysis
     - no environment variable support

Furthermore, the following restrictions are enforced:

     - no more than 5 functions
     - no more than 50 source lines

Note that these functions and source lines are arbitrary and if the
chosen functions or lines are never executed, the results will contain
fewer results.



INSIDE! Availability

INSIDE! is available for the following compilers:

     - Turbo Pascal 4.0
     - Turbo C 1.5
     - Microsoft C 5.1/QuickC 1.00
     - QuickBASIC 4.0
     - Microsoft FORTRAN

Other versions to be available soon are:

     - Microsoft Pascal 4.0
     - Turbo Prolog 2.0
     - Logitech Modula-2
     - Lattice C 3.21

If you can't find your compiler listed, contact us to let us know what
support you require.

Ordering Information

If you would like to order INSIDE!, our telephone number for orders is
(800)537-5043.  Until August 31st, INSIDE! is only $65.00 with $2.50
shiping and handling.  We accept both VISA and MASTERCHARGE and ship
directly from stock the same day an order is placed.

Running INSIDE!

In order to provide a degree of flexibility and adaptiveness, INSIDE!
Turbo C accepts a number of command line options (or switches if you
prefer) that influence the operation of INSIDE!.  Command line options
are lowercase letters introduced with a leading dash ('-') with no white
space in between and either accept no argument or accept an optional
argument.  Options of the first flavor can be freely combined together
following a common dash character.  Options which take optional
arguments must either stand alone on a command line or terminate a list
of argument options.  Some examples of INSIDE! command lines are shown
below.

     intc -o -l hello    ; Separate arguments
     intc -lo hello      ; Same as -l and -o
     intc -ol hello      ; Output file will be L.

The binding of characters in option strings is done from left to right.
For example,

     -d-l-o-

is equivalent to

     -d- -l- -o-

A command line begins with the name of the INSIDE! program and is
followed by zero or more INSIDE! options.  Following the INSIDE! command
line arguments comes the program name and command line arguments as they
would be entered if the application was run from the DOS prompt.  The
only restrictions placed on the target application is that it be an .EXE
file and can be found in a directory named in the PATH environment
variable.

     intc options program arg1 arg2 ...

Any of the INSIDE! command line options can be overridden by simply
using a new option any time after an option has been introduced.  This
rule permits any of the default options from the environment variable to
be overridden by the user when a command line is entered.  The -o and -l
options are special in that they can accept a trailing dash following
the option letter.

     intc -o- -l- demo   ; Send output to DEMO.PRF
                         ; Non-executed line mode

In the following option descriptions, left and right brackets ('[' and
']') are used to denote mandatory arguments to command line switches.
Note that there is never any white space (ASCII space, tab or newline
characters) between a switch and its argument.



-a[n]
-a[n]-

     The -a (Adjust) option is used to tailor elapsed time measurements
     on a particular system.  This option accepts a single digit from 0
     to 9 and adjusts each of the dynamically calculated overheads by
     the specified amount.

     If the timing results generated by INSIDE! are too small, an
     optional '-' character can follow the digit and cause the value to
     be subtracted from the overhead.  For example,

          intc -a5 demo

     will add five ticks to each of the overhead calculations while

          intc -a4- demo

     will subtract four clock ticks.



-f
-f-

     The -f (Format) option controls the output format for execution
     times in the statistics file.  The default mode is to display all
     times in milliseconds.  By specifying the -f option, unit of time
     for all elapsed times will be seconds.

     The -f option can be overridden by the -f- option to restore the
     default time display mode back to milliseconds.



-h
-?

     The -h (Help) or -? option will display a brief list of INSIDE!
     Turbo C command line options.  This list will also be displayed if
     INSIDE! is run without arguments.



-l
-l-

     The -l (Line analysis) option enables the source line analysis
     mode.  Once a particular module has been singled out for
     optimization, source line profiling can determine the individual
     source lines that are targets for optimization.  If no source
     modules are specified in a -n option, all modules in the program
     will be analyzed.  Because this can create a considerable amount of
     run-time overhead in large, multiple source module programs, the -n
     option can be used to limit the analysis to a limited set of source
     modules.

     The -l option displays the source line numbers of lines that were
     executed one or more times.  If you prefer to know which source
     lines were never executed, the -l- option can be used.



-r

     The -r (Replace) option is used to source line analyze programs
     which modify the program after execution has started.  When
     enabled, the Replace mode will assume that the opcode has changed
     during the execution of the program and will always copy the
     current opcode when a source line interrupt occurs.



-t

     The -t (Timing analysis) option enables the function timing mode
     where the time spent in each invocation of a function or procedure
     is measured.

     This is the default mode of operation for INSIDE!.

Appendix A - Error Messages

The following is an alphabetical listing of the warnings and error
messages that might be encountered while using INSIDE!.  For each
message, a description of the problem along with possible corrective
actions is provided.

Bad command line argument
An unrecognized command line argument was entered.  Check the command
line syntax and re-enter the command.

Bad .EXE file format
The .EXE file does not have a correct header.  Try rebuilding the file
before continuing.

Bad link map
The link map is not in a format understood by INSIDE! Turbo C.  The
linker used with this product must be compatible with the Borland linker
supplied with Turbo C 1.5.

Can't find the .EXE file
INSIDE! Turbo C is unable to find the target .EXE file.  If no path is
specified, INSIDE! searches for the target program in the current
directory and all directories specified in the PATH environment
variable.  If an explicit path is specified, the target program must be
in that directory.

Can't load the .EXE file
INSIDE! Turbo C is unable to load the target .EXE file.

File delete error
INSIDE! was unable to delete an existing statistics file.  The likely
cause for this error is that the disk or file is write protected.

File read error
An error was detected during the reading of a file.  The cause of the
error as reported by DOS is displayed immediately after this message.
If this error persists and cannot be corrected, contact Paradigm Systems
for assistance.

File seek error
An error was detected during a file seek operation.  The cause of the
error as reported by DOS is displayed immediately after this message.
If this error persists and cannot be corrected, contact Paradigm Systems
for assistance.

File write error
An error was detected during a file write operation.  The cause of the
error as reported by DOS is displayed immediately after this message.
If this error persists and cannot be corrected, contact Paradigm Systems
for assistance.

Insufficient memory
The dynamic memory requirements needed by INSIDE! are unable to be
satisfied by DOS.  Attempt to free up some memory before re-trying the
operation.

Internal error - contact Paradigm Systems
An internal error has been detected by INSIDE! Turbo C.  Please contact
Paradigm Systems with the circumstances surrounding this problem.

Need DOS 2.0 or later
INSIDE! Turbo C requires MS-DOS or PC-DOS 2.0 or later to work.  If you
get this message you should seriously consider upgrading to a newer
version of DOS.

No line number records
No line number records were found in the link map.  Line number records
are required by INSIDE! Turbo C and the Turbo C compiler options -y and
-M must be used to compile applications.  If multiple object modules are
being linked together by TLINK, the TLINK option /m must be used to
write line number records to the link map file.

No program specified
INSIDE! was run without specifying a program to analyze.

No such source module
A module name was specified in a -n option but no such module could be
found in the target program.  Check that the specified module exists in
the target program.

Too many command line arguments
INSIDE! Turbo C has a fixed limit of 30 command line arguments.  Re-
enter the command line using fewer arguments.

Unable to create statistics file
INSIDE! Turbo C is unable to create the statistics file.

Unable to install handler
A failure occurred when INSIDE! Turbo C attempted to install an
exception handler.  This is a serious fault and likely indicates a
problem with the system.

Unable to open link map
INSIDE! Turbo C could not find the link map for the target program.
This is most likely caused by the failure to have the linker write a map
file.
We welcome your suggestions and feedback concerning INSIDE! Turbo C and
hope you find this software meets your software development
requirements.  This software has been extensively tested prior to its
release but unforeseen problems can arise.  Should you find a problem
with this software or you have an idea for an improvement, a Software
Problem Report form can be found following the appendices.  Fill out
this form along with the problem or suggestion and send it in for prompt
action or resolution.


Problem Solving

If you are having trouble getting INSIDE! Turbo C to work with your
program, the following steps will be useful to help track down the cause
of the problem.

     - try to isolate the problem to a single module using the -n option
     - try different compiler options to isolate the problem

If the problem still cannot be resolved, see the following paragraph for
details on contacting us for further assistance.


Technical Assistance

If you have technical questions or need immediate assistance in setting
up or using INSIDE! Turbo C, you can contact our technical support staff
at (508)478-0499 between the hours of 10AM and 4PM (Eastern).  We will
be more than happy to discuss your problem and provide the fastest
possible response.
