/*ͻ*/
/*    INMEM.C  -  Tests for the presence of a program in memory.    */
/*                Returns 0 if found. If not found returns a 1      */
/*                errorlevel.                                       */
/*ͼ*/
/*ͻ*/
/*   Compile and link this program with TURBOC as follows:          */
/*                                                                  */
/*   "tcc -mt -lc -lx -lt inmem                                     */
/*                                                                  */
/*ͼ*/

#include <dir.h>
#include <dos.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <ctype.h>

void exit(int c)
{ _exit(c);}

void _setenvp(void){}		/* dummy out _setenvp */

unsigned _stklen = 0x200;
unsigned _heaplen = 0;

/*ͻ*/
/*            search memory blocks looking for a program            */
/*            if found, return the path loaded from                 */
/*ͼ*/
char far * resident(char *resident_program)
{
	#define mcb_block 0x4d
	#define last_mcb_block 0x5a
	union REGS reg; struct SREGS segreg;
	char far *env_ptr;
	char far *path_ptr;
	char mcb_id, next_mcb_id;
	int found_resident_pgm = 0, found_first_mcb = 0, found_last_mcb = 0;
	int path_idx, mcb_pgm_count = 0;
	unsigned mcb_seg, psp_seg = 0, env_seg = 0, next_seg, prior_psp_seg;
	unsigned mcb_len;
	/*** find first Memory Control Block ***/
	reg.h.ah = 0x52;
	int86x(0x21,&reg,&reg,&segreg);
	mcb_seg = peek(segreg.es,reg.x.bx - 2);
	while(!found_last_mcb)
	{
		/*** find next Memory Control Block ***/
		mcb_id = peekb(mcb_seg,0);
		if (mcb_id == mcb_block)
		{
			prior_psp_seg = psp_seg;
			mcb_len = peek(mcb_seg,3);
			next_seg = mcb_seg + mcb_len + 1;
			psp_seg = peek(mcb_seg,1);
			next_mcb_id = peekb(next_seg,0);
			env_seg = peek(psp_seg,0x2c);
			if ((next_mcb_id == last_mcb_block) || (next_mcb_id == mcb_block))
			{
				found_first_mcb++;
			}
		}
		else
		{
			if (mcb_id == last_mcb_block) found_last_mcb = 1;
		}
		/*** Edit Memory Control Block ***/
		if (!found_last_mcb)
		{
			mcb_seg = next_seg;
			if ((psp_seg != prior_psp_seg) && (psp_seg != 0))
			{
				mcb_pgm_count++;
				if (mcb_pgm_count > 2)
				{
					env_ptr = MK_FP(env_seg,0);
					while(peek(FP_SEG(env_ptr),FP_OFF(env_ptr)) != 0) env_ptr++;
					env_ptr += 4;			/* point to program path */
					path_ptr = env_ptr;	/* and save it */
					while(peekb(FP_SEG(env_ptr),FP_OFF(env_ptr)) != '.')
					{
						env_ptr++;
					}
					path_idx = strlen(resident_program);
					found_resident_pgm=path_idx;
					while(path_idx)
					{
						env_ptr--;
						if(peekb(FP_SEG(env_ptr),FP_OFF(env_ptr)) !=
							toupper(resident_program[path_idx - 1]))
						{
							found_resident_pgm=0;
							path_idx=0;
						}
						else
							path_idx--;
					}
					if(found_resident_pgm)
						found_last_mcb++;
				}
			}
		}
	}
	if (found_resident_pgm) return(path_ptr);
	return(0);
}

/*ͻ*/
/*                         program mainline                         */
/*ͼ*/
void main(int argc, char *argv[])
{
	char far *res_ptr, *name_ptr;
	char pgm_name[MAXPATH];
	if (argc > 1)
	{
		if ((res_ptr=resident(argv[1]))!=0)
		{
			name_ptr=pgm_name;
			movedata(	FP_SEG(res_ptr),	FP_OFF(res_ptr),
							FP_SEG(name_ptr),	FP_OFF(name_ptr),
							sizeof(pgm_name));
			printf("%s is in memory\n",pgm_name);
			exit(0);
		}
		else
			printf("%s is NOT in memory\n",argv[1]);
	}
	exit(1);
}
