/*
** inifunc.h - Prototypes and definitions for INI file functions
**
** Version 1.35
**
** (c) Copyright 1992, 1993 DAF, Inc. - All rights reserved
*/


#ifndef inifunc_h
#define	inifunc_h


/* Data type for function access */
typedef	void	*INIHNDL;


/* Status codes */
#define	IF_OK			0x0000	/* No error									*/
#define	IF_BADRANGE		0x0001	/* Value out of range						*/
#define	IF_BUSY			0x0002	/* Item exists already						*/
#define	IF_NOMEM		0x0004	/* Out of memory							*/
#define	IF_BADTYPE		0x0008	/* Bad type									*/
#define	IF_BADHNDL		0x0010	/* Bad handle								*/
#define	IF_NOTFILLED	0x0020	/* Item was not filled by scan				*/
#define	IF_NOSECT		0x0040	/* Section not found in INI file			*/
#define	IF_BADKEY		0x0080	/* Unrecognized key							*/
#define	IF_SYNTAX		0x0100	/* Bad syntax in INI file					*/
#define	IF_TOOMANY		0x0200	/* Too many elements for item				*/
#define	IF_OPEN			0x0400	/* File not found							*/
#define	IF_IOERR		0x0800	/* I/O error								*/
#define	IF_LOST			0x1000	/* Update: lost original version of INI		*/
#define	IF_ERROR		0x7fff	/* All the error values						*/



/*
** Function   prototypes
*/
INIHNDL	CreateIniHandle(char *section);
int		DeleteIniHandle(INIHNDL inihndl);

int		ReadIniInfo(INIHNDL inihndl, char *inifile);
int		WriteIniInfo(INIHNDL inihndl, char *inifile);

int		DeleteIniItem(INIHNDL inihndl, char *key);

int		BuildBoolIniItem(INIHNDL inihndl, char *key, int defval);
int		BuildShortIniItem(INIHNDL inihndl, char *key, short defval, short minval, short maxval);
int		BuildUshortIniItem(INIHNDL inihndl, char *key, ushort defval, ushort minval, ushort maxval);
int		BuildLongIniItem(INIHNDL inihndl, char *key, long defval, long minval, long maxval);
int		BuildUlongIniItem(INIHNDL inihndl, char *key, ulong defval, ulong minval, ulong maxval);
int		BuildStringIniItem(INIHNDL inihndl, char *key, int maxlen, char *defstr);

int		BuildBoolsIniItem(INIHNDL inihndl, char *key, int num, int defval);
int		BuildShortsIniItem(INIHNDL inihndl, char *key, int num, short defval, short minval, short maxval);
int		BuildUshortsIniItem(INIHNDL inihndl, char *key, int num, ushort defval, ushort minval, ushort maxval);
int		BuildLongsIniItem(INIHNDL inihndl, char *key, int num, long defval, long minval, long maxval);
int		BuildUlongsIniItem(INIHNDL inihndl, char *key, int num, ulong defval, ulong minval, ulong maxval);
int		BuildStringsIniItem(INIHNDL inihndl, char *key, int num, int maxlen, char *defstr);

int		GetBoolIniItem(INIHNDL inihndl, char *key, int *valptr);
int		GetShortIniItem(INIHNDL inihndl, char *key, short *valptr);
int		GetUshortIniItem(INIHNDL inihndl, char *key, ushort *valptr);
int		GetLongIniItem(INIHNDL inihndl, char *key, long *valptr);
int		GetUlongIniItem(INIHNDL inihndl, char *key, ulong *valptr);
int		GetStringIniItem(INIHNDL inihndl, char *key, char *strptr);

int		GetBoolsIniItem(INIHNDL inihndl, char *key, int *valptr, int num);
int		GetShortsIniItem(INIHNDL inihndl, char *key, short *valptr, int num);
int		GetUshortsIniItem(INIHNDL inihndl, char *key, ushort *valptr, int num);
int		GetLongsIniItem(INIHNDL inihndl, char *key, long *valptr, int num);
int		GetUlongsIniItem(INIHNDL inihndl, char *key, ulong *valptr, int num);
int		GetStringsIniItem(INIHNDL inihndl, char *key, char **strptr, int num);

int		SetBoolIniItem(INIHNDL inihndl, char *key, int value);
int		SetShortIniItem(INIHNDL inihndl, char *key, short value);
int		SetUshortIniItem(INIHNDL inihndl, char *key, ushort value);
int		SetLongIniItem(INIHNDL inihndl, char *key, long value);
int		SetUlongIniItem(INIHNDL inihndl, char *key, ulong value);
int		SetStringIniItem(INIHNDL inihndl, char *key, char *strptr);

int		SetBoolsIniItem(INIHNDL inihndl, char *key, int *valptr, int num);
int		SetShortsIniItem(INIHNDL inihndl, char *key, short *valptr, int num);
int		SetUshortsIniItem(INIHNDL inihndl, char *key, ushort *valptr, int num);
int		SetLongsIniItem(INIHNDL inihndl, char *key, long *valptr, int num);
int		SetUlongsIniItem(INIHNDL inihndl, char *key, ulong *valptr, int num);
int		SetStringsIniItem(INIHNDL inihndl, char *key, char **strptr, int num);




#endif

