/*
** demo.c
**
** Simple demonstration program for INI file functions set
**
** (c) Copyright 1992, 1993 DAF, Inc. - All rights reserved
*/


#include <daf\types.h>
#include <conio.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include <daf\inifunc.h>


int main(int argc, char *argv[]);


int main(int argc, char *argv[])
{
	INIHNDL		ih;
	int		j, res;
	long		l;
	ushort		us[5];
	static char	s1[50], s2[50], s3[50], s4[50], s5[50];
	static char	*strarr[6] = { s1, s2, s3, s4, s5, NULL };



	puts("INI file functions demonstration program.");

	/*
	** Create an INI handle
	*/
	ih = CreateIniHandle("test");
	if(ih==NULL) {
		puts("CreateIniHandle()==NULL");
		exit(1);
		}


	/*
	** Build items
	*/
	if((res=BuildBoolIniItem(ih, "bool", 0))!=IF_OK) {
		printf("BuildBoolIniItem()==%02x\n", res);
		exit(1);
		}

	if((res=BuildShortIniItem(ih, "short", 0, 0, 0))!=IF_OK) {
		printf("BuildShortIniItem()==%02x\n", res);
		exit(1);
		}

	if((res=BuildUshortIniItem(ih, "ushort", 0, 0, 0))!=IF_OK) {
		printf("BuildUshortIniItem()==%02x\n", res);
		exit(1);
		}

	if((res=BuildLongIniItem(ih, "long", 0L, 0L, 0L))!=IF_OK) {
		printf("BuildLongIniItem()==%02x\n", res);
		exit(1);
		}

	if((res=BuildUlongIniItem(ih, "ulong", 0L, 0L, 0L))!=IF_OK) {
		printf("BuildUlongIniItem()==%02x\n", res);
		exit(1);
		}

	if((res=BuildStringIniItem(ih, "string", 50, NULL))!=IF_OK) {
		printf("BuildStringIniItem()==%02x\n", res);
		exit(1);
		}

	if((res=BuildUshortsIniItem(ih, "ushorts", 5, 0, 0, 0))!=IF_OK) {
		printf("BuildUshortsIniItem()==%02x\n", res);
		exit(1);
		}

	if((res=BuildStringsIniItem(ih, "strings", 5, 40, NULL))!=IF_OK) {
		printf("BuildStringsIniItem()==%02x\n", res);
		exit(1);
		}


	/*
	** Read information from file (if any)
	*/
	if((res=ReadIniInfo(ih, "demo.ini"))&IF_ERROR) {
		printf("ReadIniInfo()==%02x\n", res);
		/* Fall through here and use default values */
		}


	/*
	** Change the long value
	*/
	for(j=0; j<5; j++) {
		if((res=GetLongIniItem(ih, "long", &l))!=IF_OK) {
			printf("GetLongIniItem()==%02x\n", res);
			break;
			}
		if((res=GetLongIniItem(ih, "ulong", &l))==IF_OK) {
			printf("GetLongIniItem()==%02x\n", res);
			break;
			}
		l++;
		if((res=SetLongIniItem(ih, "long", l))!=IF_OK) {
			printf("GetLongIniItem()==%02x\n", res);
			break;
			}
		}
	if(res!=IF_OK)
		exit(1);


	/*
	** Change array of unsigned shorts values
	*/
	if((res=GetUshortsIniItem(ih, "ushorts", us, 5))!=IF_OK) {
		printf("GetUshortsIniItem()==%02x\n", res);
		exit(1);
		}
	for(j=0; j<5; j++)
		us[j] += (j+1);
	if((res=SetUshortsIniItem(ih, "ushorts", us, 5))!=IF_OK) {
		printf("SetUshortsIniItem()==%02x\n", res);
		exit(1);
		}


	/*
	** Change string
	*/
	if((res=GetStringsIniItem(ih, "strings", strarr, 5))!=IF_OK) {
		printf("GetStringsIniItem()==%02x\n", res);
		exit(1);
		}
	strarr[5] = strarr[0];
	for(j=0; j<5; j++) {
		strarr[j] = strarr[j+1];
		}
	if((res=SetStringsIniItem(ih, "strings", strarr, 5))!=IF_OK) {
		printf("SetStringsIniItem()==%02x\n", res);
		exit(1);
		}


	/*
	** Update file
	*/
	if((res=WriteIniInfo(ih, "demo.ini"))!=IF_OK) {
		printf("WriteIniInfo()==%02x\n", res);
		exit(1);
		}


	/*
	** Delete items from handle
	*/
	if((res=DeleteIniItem(ih, "ushort"))!=IF_OK) {
		printf("DeleteIniItem('ushort', 1st)==%02x\n", res);
		exit(1);
		}

	if((res=DeleteIniItem(ih, "ushort"))==IF_OK) {
		printf("DeleteIniItem('ushort', 2nd)==%02x\n", res);
		exit(1);
		}

	if((res=DeleteIniItem(ih, "ulong"))!=IF_OK) {
		printf("DeleteIniItem('ulong', 1st)==%02x\n", res);
		exit(1);
		}


	/*
	** Dispose of the handle
	*/
	if((res=DeleteIniHandle(ih))!=IF_OK) {
		printf("DeleteIniHandle()==%02x\n", res);
		exit(1);
		}


	puts("INI file updated.");

	/* Arguments are not used, keep checker silent */
	argc = argc;
	argv = argv;

	return(0);
}

