/*
** daf/types.h
**
** Define signed/unsigned and hardware-style variables
**
*/


#ifndef daf_types_h
#define daf_types_h


#include <sys\types.h>


#ifndef FALSE
#define FALSE		    0
#define TRUE		    1
#endif



#if defined(__FLAT__) || defined(__386__) || defined(_M_IX86)
#define FAR
#define NEAR
#else
#define FAR			far
#define NEAR		near
#endif



#ifndef _BSD_T_DEFINED

typedef	signed char		schar;
typedef	unsigned char	uchar, *puchar;
typedef	unsigned char	unchar;
typedef	unsigned short	ushort, *pushort;
typedef	unsigned int	uint;
typedef	unsigned long	ulong, *pulong;

typedef	char *	caddr_t;

#define _BSD_T_DEFINED
#endif



#ifndef _MACH_T_DEFINED

typedef int		    	BOOL;
typedef unsigned char	BYTE, UCHAR;
typedef signed short	SHORT;
typedef unsigned short	WORD, USHORT;
typedef signed long		LONG;
typedef unsigned long	DWORD, ULONG;
typedef BYTE			*pBYTE, *pUCHAR;
typedef BYTE NEAR		*npBYTE, *npUCHAR;
typedef BYTE FAR		*fpBYTE, *fpUCHAR;
typedef WORD			*pWORD, *pUSHORT;
typedef WORD NEAR		*npWORD, *npUSHORT;
typedef WORD FAR		*fpWORD, *fpUSHORT;
typedef DWORD			*pDWORD, *pULONG;
typedef DWORD NEAR		*npDWORD, *npULONG;
typedef DWORD FAR		*fpDWORD, *fpULONG;
typedef LONG			*pLONG;
typedef LONG NEAR		*npLONG;
typedef LONG FAR		*fpLONG;
typedef void			*pVOID;
typedef void NEAR		*npVOID;
typedef void FAR		*fpVOID;

#define	_MACH_T_DEFINED
#endif


#endif

