/*
 * IDELETE.C - delete a record
 *
 *                      Copyright (c) 1987, Jim Mischel
 *
 * Modifications:
 *
 * 08/13/87 - jim - initial coding
 * 02/02/88 - jim - having some trouble changing thread pointers.  So, until
 *                  I can get it fixed, the routine just flags the record
 *                  as deleted and lets the other routines worry about
 *                  checking for deleted records.
 */

#include "inxdefs.h"

/*
 * idelete() - remove the current record from the data stream.  The data
 * record is not actually removed from the file and the index record is not
 * removed from the index file.  The index pointers are adjusted so that
 * they skip over the index for this record.
 * Returns 0 if successful, error status otherwise.  If the key at 'source'
 * is not the same as the key in the current data record, I_INVKEY is
 * returned and no action is taken.  Since the only integrity check
 * made is a simple key comparison, if duplicate keys are permitted, it
 * is possible to delete the wrong record.
 */
int idelete(void *d, void *src)
{
  register df_rec *db_control = (df_rec *)d;
  char *source = (char *)src;

  /* see if record has already been deleted */
  if (db_control->df_flags & DF_DELETE)
    return(ierror(I_INVKEY));

  /* see if keys are equal */
  if ((*db_control->df_cmp)((source+db_control->df_key_offset),
                            db_control->df_key_ptr))
    return(ierror(I_INVKEY));           /* error: keys not equal */

  /*
   * Since I've been having problems adjusting node pointers,
   * I'll just flag the record as deleted and let all the other
   * routines worry about handling deleted records.
   */
  db_control->df_inx_buff.if_flags |= DELETED_REC;
  if (iwrite_inx(db_control,&db_control->df_inx_buff,db_control->df_inx_ptr))
    return(ierrno);
  db_control->df_flags |= DF_DELETE;    /* flag record as deleted */
  return(0);
} /* idelete */
