/*
 * IREADN.C - read next
 *
 *                      Copyright (c) 1987, Jim Mischel
 * Modifications:
 *
 * 08/13/87 - jim - original coding
 * 02/02/88 - jim - check for deleted records
 */

#include "inxdefs.h"

/*
 * iread_next() - return the next record in sequence.  The file must be
 * started using istart() before this routine is called.  If successful
 * returns 0 with data record at destin.  At end of file, EOF is returned.
 * Any other errors return status.  In the case of EOF or error, the data at
 * destin is unchanged.
 *
 * This routine assumes there is enough space at 'dest' to store the entire
 * data record.
 */
int iread_next(void *d, void *dest)
{
  df_rec *db_control = (df_rec *)d;
  char *destin = (char *)dest;

  if (db_control->df_flags & DF_EOF)
    return(EOF);                        /* already reached end of file */
  /*
   * if this is not the first read after starting the file, get the
   * next index record into the buffer.
   */
  if (!(db_control->df_flags & DF_START)) {
    if (iget_next(db_control,&db_control->df_nxt_buff))
      return(EOF);
    memcpy(&db_control->df_nxt_buff,&db_control->df_inx_buff,
           sizeof(inx_rec));
  }
  else
    db_control->df_flags &= ~DF_START;  /* reset first read flag */

  while (db_control->df_nxt_buff.if_flags & DELETED_REC) {
    if (iget_next(db_control,&db_control->df_nxt_buff))
      return(EOF);
    memcpy(&db_control->df_nxt_buff,&db_control->df_inx_buff,
           sizeof(inx_rec));
  }

  /* get the data record */
  if (iread_dat(db_control,db_control->df_nxt_buff.if_dat_ptr))
    return(ierrno);

  db_control->df_flags &= ~DF_TOF;      /* clear top-of-file flag */
  db_control->df_flags &= ~DF_DELETE;   /* clear deleted record flag */

  /* copy the data record from data buffer into user's area */
  memcpy(destin,db_control->df_dat_buff,db_control->df_rec_size);
  return(0);
} /* iread_next */
