/*
 * INXDEFS.H - data definitions for all index modules
 *
 *			Copyright (c) 1987, Jim Mischel
 * Modifications:
 *
 * 08/13/87 - jim - original coding
 * 08/22/87 - jim - add flag definitions for balancing logic
 * 11/04/87 - jim - remove default comparison routines
 * 02/02/88 - jim - Add DELETED_REC to index flags
 */

#include <stdio.h>
#include <io.h>
#include <alloc.h>
#include <mem.h>
#include <string.h>
#include "index.h"


#define fsize(f) filelength(fileno((f)))

/* index file record */
typedef struct {
  long if_dat_ptr,              /* pointer to data file record */
       if_left_node,            /* left descendent */
       if_right_node,           /* right descendent */
       if_parent;               /* there's got to be a better way!!! */
  char if_flags;                /* flags */
} inx_rec;

/* index record flags byte */
#define RTHRD   0x01		/* set if right node is thread pointer */
#define LTHRD   0x02            /* set if left node is thread pointer */
#define ETHRD   0x04            /* set if this node is end of thread */
#define BTHRD   0x08            /* set if this node is beginning of thread */
#define BALEQ   0x10		/* subtree balance is even */
#define BAL_L	0x20		/* subtree balance is left heavy */
#define BAL_R	0x30		/* subtree balance is right heavy */
#define BAL_MASK 0x30		/* mask for subtree balance */
#define DELETED_REC 0x40	/* set if deleted index record */

/* database control record */
typedef struct {
  char *df_path;                /* pathname (no extension) */
  FILE *df_inx_file,            /* index file */
       *df_dat_file;            /* data file */
  inx_rec df_inx_buff;          /* index file buffer */
  inx_rec df_nxt_buff;          /* buffer for read next/previous */
  long df_nxt_ptr;              /* pointer for read next/previous */
  char *df_dat_buff;            /* data file buffer */
  unsigned df_rec_size;         /* data record size */
  int (*df_cmp)();              /* pointer to comparison routine */
  char *df_key_ptr;             /* pointer to key in data buffer */
  unsigned df_key_offset;       /* offset of key from beginning of record */
  char df_flags;                /* flags */
  long df_inx_ptr;              /* current index record */
  long df_dat_ptr;              /* current data record */
} df_rec;

/* control record flags */
#define DF_DUP          0x01	/* on if duplicate keys allowed */
#define DF_EOF          0x02    /* on if at end of file (sequential I/O) */
#define DF_TOF          0x04    /* on if at top of file (sequential I/O) */
#define DF_START        0x08    /* on if file has been started */
#define DF_DELETE       0x10    /* on if record has been deleted */

/* internal support functions */
int isearch(df_rec *db_control, char *key);
int iget_next(df_rec *db_control, inx_rec *irec);
int iget_prev(df_rec *db_control, inx_rec *irec);
int iget_root(df_rec *db_control);
int iread_inx(df_rec *db_control, long seek_pos);
int iwrite_inx(df_rec *db_control, inx_rec *irec, long seek_pos);
int iread_dat(df_rec *db_control, long seek_pos);
int iwrite_dat(df_rec *db_control, void *datrec, long seek_pos);
int ierror(int e);
