//                                               //
// Copyright <c> Borland International, 1993-4   //
//                                               //

//                                                                        //
//  GenVBXh - Example of IdeHook usage.                                   //
//                                                                        //
//      This examples demonstrates installing several different           //
//      tools into the user's project (all of which show different        //
//      aspects of the VBXGEN.EXE utility):                               //
//                                                                        //
//      VbxHeaderGen - This tool is installed as a simple transfer        //
//                     placed on the 'Tool' menu of the IDE. It           //
//                     simply calls VBXGEN.EXE prompting the user         //
//                     for any initial command-line args.                 //
//                                                                        //
//      VbxHeaderNodeGen -                                                //
//                      This tool is installed as a viewer on [.c] and    //
//                      [.cpp] nodes. This tool will put up it's own      //
//                      File Open/New dialogs to gather the user input.   //
//                      It then run VBXGEN.EXE and upon return, adds      //
//                      the [.h] nodes to the [.c]/[.cpp] node and opens  //
//                      the newly generated header file into an edit      //
//                      window on the IDE desktop.                        //
//                                                                        //
//      VbxTranslator - This tools is installed as translator from [.vbx] //
//                      nodes to [.h] with default command line of        //
//                      '$EDNAME $OUTNAME'. This allows users to put      //
//                      [.vbx] nodes into their tree as dependencies of   //
//                      [.c] and [.cpp] nodes.                            //
//                                                                        //
//                                                                        //
//  Of these three tools, VbxHeaderNodeGen requires that we register a    //
//  callback as the implementor of the tool. The other two call           //
//  VBXGEN.EXE directly.                                                  //
//                                                                        //

#pragma hdrstop

#include "idehook.h"
#include "pathspec.h"
#include <cstring.h>

static char genVbxTransferName[]   = "VbxHeaderGen";
static char genVbxViewerName[]     = "VbxHeaderNodeGen";
static char genVbxTranslatorName[] = "VbxTranslator";
static char genVbxPath[]           = "vbxgen.exe";
static char genVbxMenuName[]       = "&Generate VBX Header";
static char genVbxHelpHint[]       = "Generate header files for VBX controls";


static char VBXFilter[]    = "VBX Controls (*.vbx)|*.vbx|"
                             "All Files (*.*)|*.*|";
static char DotHFilter[]   = "Header File (*.h)|*.h|"
                             "All Files (*.*)|*.*|";
           

//                                                                   //
//  First we need to register a call-back as the implementor of the  //
//  viewer tool we are installing. This is because we want addition  //
//  functionality that the .exe does not provide.                    //
//                                                                   //

class _HOOKCLASS LocalToolClient : public ToolClient
{
public:
    ToolReturn _HOOKEP RunVbxHeaderGen( ToolInvokeArgs * );

    void RegisterMyCallBacks( ToolServer * );

private:
            int                 registered;
    static  ToolRegisterPack    entryPoints[];

};


void
LocalToolClient::RegisterMyCallBacks( ToolServer * ts )
{
    if( !registered )
    {
        // We only should do this the first time through here.
        
        registered = 1;
        ts->ToolRegisterImplementor( this, entryPoints );
    }
}

//                                                   //
//  This is the implementation of the viewer tool    //
//                                                   //

ToolReturn _HOOKEP 
LocalToolClient::RunVbxHeaderGen( ToolInvokeArgs * args )
{
   PathSpec    vbxPath;
   PathSpec    headerPath;

   //   Get the .vbx control from the user...
   
   if( vbxPath.openFileDialog( VBXFilter ) )
   {
       headerPath.path( vbxPath.path() );
       headerPath.ext( ".h" );

       //    Get the header [.h] from the user ...
       
       if( headerPath.newFileDialog( DotHFilter ) )
       {
           // Find the transfer tool for GENVBX     //
           
           ToolReq     ts;

           ToolObj     vbxGenner = ts->ToolFind( genVbxTransferName );

           // Build the command line    //
           
           string  cmdLine;

           cmdLine = vbxPath.path();
           cmdLine += " ";
           cmdLine += headerPath.path();

           //   Invoke the transfer     //
           
           if
           (
              ( ts->ToolInvoke( vbxGenner, (const char *)0, cmdLine.c_str() ) ) 
                  == Success 
           )
           {
               // Now, for every selected node, put the [.h] node under it...
               
               ProjectReq  project;

               int count = args->numNodes;
    
               for( int i = 0; i < count; i++ )
               {
                  ProjectNode   parent = args->nodeArray[i];

                  project->NodeAdd( parent, headerPath.path() );
               }

               //   Invoke the EditText tool to put the header file into an  //
               //   edit buffer on the desktop.                              //
               
               ts->ToolInvoke( ts->ToolFind( "EditText" ), headerPath.path() );
               
           }
       }
   }
   
   return( Success );
}

ToolRegisterPack LocalToolClient::entryPoints[] =
{
    { genVbxViewerName, (ToolMethod)&LocalToolClient::RunVbxHeaderGen },
    { 0 }
};

static LocalToolClient  localToolClient;



//                                                                    //
//      Register this tool into user's projects. We do this by        //
//      watching for Project Open's.                                  //
//                                                                    //

class _HOOKCLASS LocalProjClient : public ProjectClient
{
public:
    LocalProjClient();
   
    virtual void _HOOKEP OpenNotify ( const char * name );
    virtual void _HOOKEP CloseNotify() {}
    virtual void _HOOKEP NodeDeleteNotify( ProjectNode ) {}
    virtual void _HOOKEP DependencyQueryResponder(ProjectNode,const char *) {}
};

static LocalProjClient LocalProjClient;

LocalProjClient::LocalProjClient()
{
   //   Register ourselves as a project client so we'll get notified  //
   //   on project open's                                             //
   
   ProjectReq ps;

   ps->RegisterProjectClient(this);
}


void _HOOKEP    
LocalProjClient::OpenNotify
(
   const char * // name 
)
{
    ToolReq   ts;

    //                                                //
    //  Register our implementation of the viewer ... //
    //                                                //
    
    localToolClient.RegisterMyCallBacks( ts );


    //                                                          //
    //  Now see if the user's project already has our tools...  //
    //                                                          //
    
    if( !ts->ToolFind( genVbxTransferName ) )
    {
        //  ... no, let's install the tools      //
        
        ToolInfo toolInfo;

        //                                              //
        // Install this as simple 'Tool' menu transfer  //
        // It will run the tool 'straight'              //
        //                                              //
        
        toolInfo.toolType      = Transfer;
        toolInfo.name          = genVbxTransferName;
        toolInfo.path          = genVbxPath;
        toolInfo.flags         = OnToolsMenu;
        toolInfo.menuName      = genVbxMenuName; 
        toolInfo.helpHint      = genVbxHelpHint; 
        toolInfo.defCmdLine    = "$PROMPT";
        toolInfo.appliesTo     = 0;
        toolInfo.defaultFor    = 0;
        toolInfo.translateTo   = 0;
        toolInfo.launchId      = DEFAULT_LAUNCH_ID;

        ts->ToolAdd( &toolInfo );

        //                                              //
        // Install this as a Viewer on [.c] and [.cpp]  //
        // We will implement the tool here (above) by   //
        // putting put our own FileOpen dialogs and     //
        // adding the results into tree.                //
        //                                              //
        
        toolInfo.toolType      = Viewer;
        toolInfo.name          = genVbxViewerName;
        toolInfo.path          = 0;
        toolInfo.flags         = OnLocalMenu;
        toolInfo.menuName      = genVbxMenuName;
        toolInfo.helpHint      = genVbxHelpHint;
        toolInfo.defCmdLine    = 0;
        toolInfo.appliesTo     = ".cpp;.c;";
        toolInfo.defaultFor    = 0;
        toolInfo.translateTo   = 0;
        toolInfo.launchId      = CALLBACK_LAUNCH_ID;

        ts->ToolAdd( &toolInfo );
        
        //                                              //
        // Install this as a translator on [.vbx] nodes //
        // with the output being a [.h]                 //
        //                                              //
        
        toolInfo.toolType      = Translator;
        toolInfo.name          = genVbxTranslatorName;
        toolInfo.path          = genVbxPath;
        toolInfo.flags         = OnLocalMenu;
        toolInfo.menuName      = genVbxMenuName;
        toolInfo.helpHint      = genVbxHelpHint;
        toolInfo.defCmdLine    = "$EDNAME $OUTNAME";
        toolInfo.appliesTo     = ".vbx";
        toolInfo.defaultFor    = ".vbx";
        toolInfo.translateTo   = ".h";
        toolInfo.launchId      = DEFAULT_LAUNCH_ID;

        ts->ToolAdd( &toolInfo );

    }
}
    
// End of file
