#include "windows.h"
#include "custcntl.h"
#include "hspin.h"

extern HANDLE       hLibData;
extern HANDLE       hInst;
extern HANDLE       hData;
extern HANDLE       hFont;
extern HANDLE       hOldFont;

extern LPFNSTRTOID  lpfnVerId;
extern LPFNIDTOSTR  lpfnIdStr;

extern char *CLASSNAME;


#define ID            GetWindowWord(hWnd,GWW_ID)
#define PARENT        GetWindowWord(hWnd,GWW_HWNDPARENT)
#define INSTANCE      GetWindowWord(hWnd,GWW_HINSTANCE)
#define DEREF(h)      ((DIAMONDSTRUCT *)LocalLock(h))




HANDLE FAR PASCAL HSpinInfo( void )           /*  Initialize information  */
{
   HANDLE hCtlInfo;
   LPCTLINFO   lpCtlInfo;

   hCtlInfo = GlobalAlloc( GHND, (DWORD)sizeof(CTLINFO) );
   if( hCtlInfo )
   {
      lpCtlInfo = (LPCTLINFO)GlobalLock( hCtlInfo );
      if( lpCtlInfo )
      {
         lpCtlInfo->wVersion = 100;
         lpCtlInfo->wCtlTypes = 1;

         lstrcpy( lpCtlInfo->szClass, CLASSNAME );
         lstrcpy( lpCtlInfo->szTitle, "1" );


         lpCtlInfo->Type[ 0 ].wType = 0;
         lpCtlInfo->Type[ 0 ].wWidth = 12;                     /*  Set size  */
         lpCtlInfo->Type[ 0 ].wHeight = 12;             /*  Initialize flags  */
         lpCtlInfo->Type[ 0 ].dwStyle = WS_CHILD;

         lstrcpy( lpCtlInfo->Type[ 0 ].szDescr, CLASSNAME );
         GlobalUnlock( hCtlInfo );
      }
      else
      {
         GlobalFree( hCtlInfo );
         hCtlInfo = NULL;
      }
   }
   return( hCtlInfo );
}
 



BOOL FAR PASCAL HSpinStyle( hWnd, hCtlStyle, lpfnVerifyId, lpfnGetIdStr )
HWND hWnd;
HANDLE hCtlStyle;
LPFNSTRTOID lpfnVerifyId;
LPFNIDTOSTR lpfnGetIdStr;
{
   FARPROC     lpDlgFn;
   HANDLE      hNewCtlStyle;
   LPCTLSTYLE lpCtlStyle;
   LONG Style;

   hLibData = hCtlStyle;                      /*  This calls the dialog box  */
   lpfnVerId = lpfnVerifyId;
   lpfnIdStr = lpfnGetIdStr;

   lpDlgFn = MakeProcInstance( (FARPROC)HSpinDlgFn, hInst );

   if( DialogBox( hInst, CLASSNAME, hWnd, lpDlgFn ) )    /*  If OK pressed  */
      hNewCtlStyle = hLibData;                    /*  Return non-zero value  */
   else
      hNewCtlStyle = NULL;                       /*  Else return ZERO value  */

   FreeProcInstance( lpDlgFn );

   return( hNewCtlStyle );
}




WORD FAR PASCAL HSpinFlags( wFlags, lpszString, wMaxString )
WORD wFlags;
LPSTR lpszString;
WORD wMaxString;
{
   lpszString[ 0 ] = NULL;   /*  These strings get written to the .DLG file  */

   return( lstrlen( lpszString ) );
}



BOOL FAR PASCAL HSpinDlgFn( HWND hDlg, WORD msg, WORD wParam, LONG lParam )
{
   switch( msg )
   {
      case WM_INITDIALOG:
      {
         HANDLE hCtlStyle;
         LPCTLSTYLE lpCtlStyle;
         char szID[ 20 ];

         hCtlStyle = hLibData;
         if( hCtlStyle )
         {
            SetProp( hDlg, MAKEINTRESOURCE( 1 ), hCtlStyle );
            lpCtlStyle = (LPCTLSTYLE)GlobalLock( hCtlStyle );

            if( lpfnIdStr )
            {
               ( *lpfnIdStr )( lpCtlStyle->wId, (LPSTR)szID, sizeof(szID) );
               SetDlgItemText( hDlg, 100, szID );
            }
            lstrcpy( lpCtlStyle->szClass, CLASSNAME );

            SetProp( hDlg, MAKEINTRESOURCE( 2 ), LOWORD( (DWORD)lpfnVerId ) );
            SetProp( hDlg, MAKEINTRESOURCE( 3 ), HIWORD( (DWORD)lpfnVerId ) );

            GlobalUnlock( hCtlStyle );
         }
         else
            EndDialog( hDlg, FALSE );

         return( TRUE );
      }

      case WM_COMMAND:
         if( wParam == IDCANCEL )
         {
            RemoveProp( hDlg, MAKEINTRESOURCE( 1 ) );
            RemoveProp( hDlg, MAKEINTRESOURCE( 2 ) );
            RemoveProp( hDlg, MAKEINTRESOURCE( 3 ) );
            EndDialog( hDlg, FALSE );
            return( TRUE );
         }

         if( wParam == IDOK )
         {
            HANDLE hCtlStyle;
            LPCTLSTYLE lpCtlStyle;
            LPFNSTRTOID lpfnId;
            char szID[ 20 ];

            hCtlStyle = GetProp( hDlg, MAKEINTRESOURCE( 1 ) );
            lpCtlStyle = (LPCTLSTYLE)GlobalLock( hCtlStyle );
            szID[ 0 ] = NULL;

            lpfnId = (LPFNSTRTOID)MAKELONG(
                            GetProp( hDlg, MAKEINTRESOURCE( 2 ) ),
                            GetProp( hDlg, MAKEINTRESOURCE( 3 ) ) );
            if( lpfnId )
            {
               DWORD Result;

               GetDlgItemText( hDlg, 100, szID, sizeof(szID) );
               Result = ( *lpfnId )( (LPSTR)szID );
               if( ! (BOOL)Result )
               {
                  GlobalUnlock( hCtlStyle );
                  break;
               }
               lpCtlStyle->wId = HIWORD( Result );
            }
            GlobalUnlock( hCtlStyle );
            RemoveProp( hDlg, MAKEINTRESOURCE( 1 ) );
            RemoveProp( hDlg, MAKEINTRESOURCE( 2 ) );
            RemoveProp( hDlg, MAKEINTRESOURCE( 3 ) );
            hLibData = hCtlStyle;
            EndDialog( hDlg, TRUE );
            return( TRUE );
         }
   }
   return( FALSE );
}

