
#include "windows.h"
#include "custcntl.h"
#include "hspin.h"

typedef struct {
   int Width, Height;
   int MouseX, MouseY;
   int Button, ButtonDown;
} HSPINSTRUCT;

HANDLE       hLibData;
HANDLE       hInst;
HANDLE       hData;
HANDLE       hFont;
HANDLE       hOldFont;

LPFNSTRTOID  lpfnVerId;
LPFNIDTOSTR  lpfnIdStr;

char *CLASSNAME = "HSPIN";

#define ID            GetWindowWord(hWnd,GWW_ID)
#define PARENT        GetWindowWord(hWnd,GWW_HWNDPARENT)
#define INSTANCE      GetWindowWord(hWnd,GWW_HINSTANCE)

#define WINEXTRA      2

#define SET_MEMORY(m) SetWindowWord(hWnd,0,m)
#define MEMORY        GetWindowWord(hWnd,0)
#define DEREF(h)      ((HSPINSTRUCT *)LocalLock(h))


int FAR PASCAL LibMain( HANDLE hInstance, WORD wDataSeg, WORD wHeapSize, LPSTR CmdLine )
{
   HANDLE hMem;
   WNDCLASS *wc;

   hData = wDataSeg;
   UnlockData( 0 );

   if( ! hInst )
   {
      hMem = LocalAlloc( LHND, sizeof(WNDCLASS) );
      if( hMem )
      {
         wc = (WNDCLASS *)LocalLock( hMem );
         if( wc )
         {
            wc->lpszClassName = CLASSNAME;
            wc->hCursor = LoadCursor( NULL, IDC_ARROW );
            wc->lpszMenuName = NULL;
            wc->style = CS_GLOBALCLASS;
            wc->lpfnWndProc = HSpinWndProc;
            wc->hInstance = hInstance;
            wc->hIcon = NULL;
            wc->cbWndExtra = WINEXTRA;
            wc->cbClsExtra = 0;
            wc->hbrBackground = GetStockObject( NULL_BRUSH );

            hInst = ( RegisterClass( wc ) ) ? hInstance : NULL;
            LocalUnlock( hMem );
         }
         LocalFree( hMem );
      }
   }
   return( hInst );
}



VOID FAR PASCAL WEP( int nParam )
{
   return;
}


LONG FAR PASCAL HSpinWndProc( HWND hWnd, WORD msg, WORD wParam, LONG lParam )
{
   switch( msg )
   {
      case WM_CREATE:                       /*  Control is begin created...  */
      {
         LPCREATESTRUCT Cs;
         HSPINSTRUCT *Ds;
         HANDLE hMem;

         Cs = (LPCREATESTRUCT)lParam;    /*  Lock parameters passed from RC  */

         hMem = LocalAlloc( LHND, sizeof(HSPINSTRUCT) );
         if( ! hMem )
         {
            SET_MEMORY( 0 );         /*  Allocate memory for info structure  */
            DestroyWindow( hWnd );
            break;                                /*  If it can't, it quits  */
         }

         Ds = DEREF( hMem );                                /*  Lock memory  */
         if( ! Ds )
         {
            SET_MEMORY( 0 );
            LocalFree( hMem );
            DestroyWindow( hWnd );
            break;
         }

         Ds->Width = Cs->cx;                          /*  Save initial size  */
         Ds->Height = Cs->cy;
         Ds->MouseX = Ds->MouseY = Ds->ButtonDown = 0;

         LocalUnlock( hMem );                             /*  Unlock memory  */
         SET_MEMORY( hMem );                   /*  Save local memory handle  */
         break;
      }

      case WM_GETDLGCODE:
         lParam = DLGC_BUTTON;            /*  Tell parent we're a button...  */
         return( lParam );

      case WM_SIZE:                               /*  New size being set...  */
      {
         HSPINSTRUCT *Ds;

         Ds = (HSPINSTRUCT *)LocalLock( MEMORY );
         if( ! Ds )
            return( FALSE );                                /*  Lock memory  */

         Ds->Width = LOWORD( lParam );
         Ds->Height = HIWORD( lParam );                   /*  Save new size  */
         LocalUnlock( MEMORY );                           /*  Unlock memory  */
         break;
      }

      case WM_PAINT:                   /*  Just repaint the button as ALLUP  */
      {
         PAINTSTRUCT Ps;

         BeginPaint( hWnd, &Ps );
         PaintControl( hWnd, ALLUP );
         EndPaint( hWnd, &Ps );
         break;
      }

      case WM_LBUTTONDOWN:              /*  If a mouse button is pressed...  */
      {
         HSPINSTRUCT *Ds;

         Ds = DEREF( MEMORY );                              /*  Lock memory  */
         if( ! Ds )
            return( FALSE );               /*  If button already pressed or  */
                                                     /*  disabled, exit now  */
         if( Ds->ButtonDown )
         {
            LocalUnlock( MEMORY );                        /*  Unlock memory  */
            return( TRUE );
         }

         Ds->MouseX = LOWORD( lParam );         /*  Save new mouse position  */
         Ds->MouseY = HIWORD( lParam );

         if( LOWORD( lParam ) < Ds->Width / 2 )
         {
            PaintControl( hWnd, LEFTDOWN );
            PostMessage( PARENT, WM_VSCROLL, SB_LINEUP, MAKELONG( 0, ID ) );
         }
         else
         {
            PaintControl( hWnd, RIGHTDOWN );
            PostMessage( PARENT, WM_VSCROLL, SB_LINEDOWN, MAKELONG( 0, ID ) );
         }

         Ds->ButtonDown = 1;                      /*  Button is now pressed  */
         Ds->Button = LEFTDOWN;

         SetCapture( hWnd );               /*  Capture mouse, unlock memory  */
         LocalUnlock( MEMORY );

         return( TRUE );
      }

      case WM_LBUTTONUP:                        /*  When button is released  */
      {
         HSPINSTRUCT *Ds;

         Ds = DEREF( MEMORY );                              /*  Lock memory  */
         if( ! Ds )
            return( FALSE );

         if( ! Ds->ButtonDown )              /*  If button already up, exit  */
         {
            LocalUnlock( MEMORY );
            return( TRUE );
         }
         Ds->ButtonDown = 0;            /*  Button is now up, release mouse  */
         ReleaseCapture();

         PaintControl( hWnd, ALLUP );                   /*  Paint as all up  */

         LocalUnlock( MEMORY );                  /*  Unlock and bye bye....  */

         return( TRUE );
      }

      case WM_DESTROY:
         if( MEMORY )
            LocalFree( MEMORY );         /*  Kill memory when window killed  */

      default:
         return( DefWindowProc( hWnd, msg, wParam, lParam ) );
   }
}




BOOL PaintControl( HWND hWnd, int Style )
{
   HDC hDC;
   HDC mDC;
   HBITMAP hBmp;
   HBRUSH hBrush;
   HSPINSTRUCT *Ds;

   if( ! MEMORY )
      return( FALSE );

   Ds = (HSPINSTRUCT far *)LocalLock( MEMORY );           /*  Lock memory  */
   if( ! Ds )
      return( FALSE );
                                                  /*  Get bitmap from style  */
   hBmp = LoadBitmap( hInst, MAKEINTRESOURCE( 8000 + Style ) );

   hDC = GetDC( hWnd );                            /*  Get display contexts  */
   mDC = CreateCompatibleDC( hDC );

   SelectObject( mDC, hBmp );                       /*  Use selected bitmap  */
                                                  /*  Copy bitmap to window  */
   StretchBlt( hDC, 0, 0, Ds->Width, Ds->Height, mDC, 0, 0, 24, 24, SRCCOPY );

   DeleteDC( mDC );
   ReleaseDC( hWnd, hDC );                         /*  Get rid of resources  */
   DeleteObject( hBmp );

   LocalUnlock( MEMORY );
   return( TRUE );
}




