/*--------*/
/* HELP.H */
/*--------*/

#define  NO_CHANGE           17
#define  NO_CURSOR           0
#define  UNDERSCORE_CURSOR   0x607
#define  BLOCK_CURSOR        0x106
#define  USE_MOUSE           1
#define  NO_MOUSE            0

#ifdef __cplusplus
extern "C" {
#endif

void help_setcolors (int bor, int bortxt, int txt, int back,
					 int hitxt, int hiback, int himark,
					 int prback, int prlow, int prhigh);
/*

ARGUMENTS:
  bor = border color for window.
  bortxt = text color for help window border.
  txt = text color for window.
  back = background color for window.
  hitxt = text color for highlighted filenames.
  hiback = background color for highlighted filenames.
  himark = text color for unhighlighted keywords.
  prback = background color for bottom prompt line.
  prlow = low intensity text color for bottom prompt line.
  prhigh = high intensity text color for bottom prompt line.

*/

int help (char *keyword);
int help_open (char *filename, int use_mouse, void (*warning_funct)());
void help_close(void);
void help_explode(int);
void help_set_cursor(unsigned);

#ifdef __cplusplus
}
#endif
