/*
 * $Id: hash.h,v 1.1 90/09/24 23:58:38 chris Exp $
 *
 * Hash table entries keep track of name (or id) = value pairs.
 * Values are simply pointers.  Hash tables themselves are named
 * (for debugging).
 */

struct	hashtab;

/*
 * The `ins' functions return nonzero if the old value existed,
 * without changing the value.
 * The iterate functions calls a given function with name,value
 * or id,value pairs.
 */
struct	hashtab *ht_new();	/* given name, create new hash table */
char	*ht_nget();		/* given table and name, get value */
char	*ht_iget();		/* given table and ID, get value */
int	ht_nins();		/* given table and name, insert new value */
int	ht_iins();		/* given table and id, insert new value */
void	ht_niterate();		/* given table and function, iterate */
void	ht_iiterate();		/* given table and function, iterate */

/*
 * Some things that ought not to be here, but are anyway.
 * goodnumber() takes a number of objects and a size and returns
 * a new number of objects, such that malloc(goodnumber(n,size)*size)
 * calls malloc with a `good' size value (resulting in less wasted
 * memory).  emalloc is malloc with program-abort on out-of-memory.
 * string() makes a `read-only' copy of a string, reusing the previous
 * copy if any.
 */
int	goodnumber();		/* given n & sizeof, return new n */
char	*emalloc();		/* malloc, exit on error */
char	*string();		/* make an `ideal' copy of a string */
