/*
 * defines for malloc string routines...
 *
 * Copyright 1992 by Gray Watson and the Antaire Corporation
 *
 * This file is part of the malloc-debug package.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library (see COPYING-LIB); if not, write to the
 * Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * The author of the program may be contacted at gray.watson@antaire.com
 *
 * $Id: malloc_str.h,v 1.4 1993/04/06 04:24:42 gray Exp $
 */

#ifndef __MALLOC_STR_H__
#define __MALLOC_STR_H__

/*<<<<<<<<<<  The below prototypes are auto-generated by fillproto */

/*
 * dummy function for checking bcmp's arguments.
 */
IMPORT	int	_malloc_bcmp(void * b1, void * b2, int len);

/*
 * dummy function for checking bcopy's arguments.
 */
IMPORT	void	_malloc_bcopy(char * from, char * to, int len);

/*
 * dummy function for checking memcmp's arguments.
 */
IMPORT	int	_malloc_memcmp(void * b1,
			       void * b2, int len);

/*
 * dummy function for checking memcpy's arguments.
 */
IMPORT	char	*_malloc_memcpy(char * to, char * from, int len);

/*
 * dummy function for checking memset's arguments.
 */
IMPORT	char	*_malloc_memset(void * buf, char ch, int len);

/*
 * dummy function for checking index's arguments.
 */
IMPORT	char	*_malloc_index(char * str, char ch);

/*
 * dummy function for checking rindex's arguments.
 */
IMPORT	char	*_malloc_rindex(char * str, char ch);

/*
 * dummy function for checking strcat's arguments.
 */
IMPORT	char	*_malloc_strcat(char * to, char * from);

/*
 * dummy function for checking strcmp's arguments.
 */
IMPORT	int	_malloc_strcmp(char * s1,
			       char * s2);

/*
 * dummy function for checking strlen's arguments.
 */
IMPORT	int	_malloc_strlen(char * str);

/*
 * dummy function for checking strtok's arguments.
 */
IMPORT	char	*_malloc_strtok(char * str, char * sep);

/*
 * dummy function for checking bzero's arguments.
 */
IMPORT	void	_malloc_bzero(void * buf,
			      int len);

/*
 * dummy function for checking memccpy's arguments.
 */
IMPORT	char	*_malloc_memccpy(char * s1, char * s2, char ch, int len);

/*
 * dummy function for checking memchr's arguments.
 */
IMPORT	char	*_malloc_memchr(char * s1, char ch, int len);

/*
 * dummy function for checking strchr's arguments.
 */
IMPORT	char	*_malloc_strchr(char * str, char ch);

/*
 * dummy function for checking strrchr's arguments.
 */
IMPORT	char	*_malloc_strrchr(char * str, char ch);

/*
 * dummy function for checking strcpy's arguments.
 */
IMPORT	char	*_malloc_strcpy(char * to, char * from);

/*
 * dummy function for checking strncpy's arguments.
 */
IMPORT	char	*_malloc_strncpy(char * to, char * from, int len);

/*
 * dummy function for checking strcasecmp's arguments.
 */
IMPORT	int	_malloc_strcasecmp(char * s1, char * s2);

/*
 * dummy function for checking strncasecmp's arguments.
 */
IMPORT	int	_malloc_strncasecmp(char * s1, char * s2, int len);

/*
 * dummy function for checking strspn's arguments.
 */
IMPORT	int	_malloc_strspn(char * str, char * list);

/*
 * dummy function for checking strcspn's arguments.
 */
IMPORT	int	_malloc_strcspn(char * str, char * list);

/*
 * dummy function for checking strncat's arguments.
 */
IMPORT	char	*_malloc_strncat(char * to, char * from, int len);

/*
 * dummy function for checking strncmp's arguments.
 */
IMPORT	int	_malloc_strncmp(char * s1, char * s2, int len);

/*
 * dummy function for checking strpbrk's arguments.
 */
IMPORT	char	*_malloc_strpbrk(char * str, char * list);

/*
 * dummy function for checking strstr's arguments.
 */
IMPORT	char	*_malloc_strstr(char * str, char * pat);

/*<<<<<<<<<<   This is end of the auto-generated output from fillproto. */

#endif /* ! __MALLOC_STR_H__ */
