/*
 * functions for testing of string routines arguments.
 *
 * Copyright 1992 by Gray Watson and the Antaire Corporation
 *
 * This file is part of the malloc-debug package.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library (see COPYING-LIB); if not, write to the
 * Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * The author of the program may be contacted at gray.watson@antaire.com
 */

/*
 * This file contains functions to be used to verify the arguments of
 * string functions.   If enabled these can discover problems with
 * heap-based strings (such as fence errors) much closer to the error.
 */

#define MALLOC_DEBUG_DISABLE

#include "malloc.h"
#include "malloc_loc.h"

#include "conf.h"
#include "chunk.h"
#include "dbg_values.h"
#include "error.h"
#include "malloc_str.h"

#if INCLUDE_RCS_IDS
LOCAL	char	*rcs_id =
  "$Id: malloc_str.c,v 1.3 1993/04/06 04:24:41 gray Exp $";
#endif

#if HAVE_BCMP
/*
 * dummy function for checking bcmp's arguments.
 */
EXPORT	int	_malloc_bcmp(void * b1, void * b2, int len)
{
  if (BIT_IS_SET(_malloc_debug, DEBUG_CHECK_FUNCS)) {
    if (_chunk_pnt_check("bcmp", b1, 1, len) != NOERROR
	|| _chunk_pnt_check("bcmp", b2, 1, len) != NOERROR)
      if (BIT_IS_SET(_malloc_debug, DEBUG_LOG_BAD_POINTER))
	_malloc_message("bad pointer argument found in bcmp");
  }
  return bcmp(b1, b2, len);
}
#endif

#if HAVE_BCOPY
/*
 * dummy function for checking bcopy's arguments.
 */
EXPORT	void	_malloc_bcopy(char * from, char * to, int len)
{
  if (BIT_IS_SET(_malloc_debug, DEBUG_CHECK_FUNCS)) {
    if (_chunk_pnt_check("bcopy", from, 1, len) != NOERROR
	|| _chunk_pnt_check("bcopy", to, 1, len) != NOERROR)
      if (BIT_IS_SET(_malloc_debug, DEBUG_LOG_BAD_POINTER))
	_malloc_message("bad pointer argument found in bcopy");
  }
  bcopy(from, to, len);
}
#endif

#if HAVE_MEMCMP
/*
 * dummy function for checking memcmp's arguments.
 */
EXPORT	int	_malloc_memcmp(void * b1,
			       void * b2, int len)
{
  if (BIT_IS_SET(_malloc_debug, DEBUG_CHECK_FUNCS)) {
    if (_chunk_pnt_check("memcmp", b1, 1, len) != NOERROR
	|| _chunk_pnt_check("memcmp", b2, 1, len) != NOERROR)
      if (BIT_IS_SET(_malloc_debug, DEBUG_LOG_BAD_POINTER))
	_malloc_message("bad pointer argument found in memcmp");
  }
  return memcmp(b1, b2, len);
}
#endif

#if HAVE_MEMCPY
/*
 * dummy function for checking memcpy's arguments.
 */
EXPORT	char	*_malloc_memcpy(char * to, char * from, int len)
{
  if (BIT_IS_SET(_malloc_debug, DEBUG_CHECK_FUNCS)) {
    if (_chunk_pnt_check("memcpy", to, 1, len) != NOERROR
	|| _chunk_pnt_check("memcpy", from, 1, len) != NOERROR)
      if (BIT_IS_SET(_malloc_debug, DEBUG_LOG_BAD_POINTER))
	_malloc_message("bad pointer argument found in memcpy");
  }
  return (char *)memcpy(to, from, len);
}
#endif

#if HAVE_MEMSET
/*
 * dummy function for checking memset's arguments.
 */
EXPORT	char	*_malloc_memset(void * buf, char ch, int len)
{
  if (BIT_IS_SET(_malloc_debug, DEBUG_CHECK_FUNCS)) {
    if (_chunk_pnt_check("memset", buf, 1, len) != NOERROR)
      if (BIT_IS_SET(_malloc_debug, DEBUG_LOG_BAD_POINTER))
	_malloc_message("bad pointer argument found in memset");
  }
  return (char *)memset(buf, ch, len);
}
#endif

#if HAVE_INDEX
/*
 * dummy function for checking index's arguments.
 */
EXPORT	char	*_malloc_index(char * str, char ch)
{
  if (BIT_IS_SET(_malloc_debug, DEBUG_CHECK_FUNCS)) {
    if (_chunk_pnt_check("index", str, 1, 0) != NOERROR)
      if (BIT_IS_SET(_malloc_debug, DEBUG_LOG_BAD_POINTER))
	_malloc_message("bad pointer argument found in index");
  }
  return (char *)index(str, ch);
}
#endif

#if HAVE_RINDEX
/*
 * dummy function for checking rindex's arguments.
 */
EXPORT	char	*_malloc_rindex(char * str, char ch)
{
  if (BIT_IS_SET(_malloc_debug, DEBUG_CHECK_FUNCS)) {
    if (_chunk_pnt_check("rindex", str, 1, 0) != NOERROR)
      if (BIT_IS_SET(_malloc_debug, DEBUG_LOG_BAD_POINTER))
	_malloc_message("bad pointer argument found in rindex");
  }
  return (char *)rindex(str, ch);
}
#endif

#if HAVE_STRCAT
/*
 * dummy function for checking strcat's arguments.
 */
EXPORT	char	*_malloc_strcat(char * to, char * from)
{
  if (BIT_IS_SET(_malloc_debug, DEBUG_CHECK_FUNCS)) {
    /* maybe should check to, strlen(to) + strlen(from) */
    if (_chunk_pnt_check("strcat", to, 1, 0) != NOERROR
	|| _chunk_pnt_check("strcat", from, 1, 0) != NOERROR)
      if (BIT_IS_SET(_malloc_debug, DEBUG_LOG_BAD_POINTER))
	_malloc_message("bad pointer argument found in strcat");
  }
  return (char *)strcat(to, from);
}
#endif

#if HAVE_STRCMP
/*
 * dummy function for checking strcmp's arguments.
 */
EXPORT	int	_malloc_strcmp(char * s1,
			       char * s2)
{
  if (BIT_IS_SET(_malloc_debug, DEBUG_CHECK_FUNCS)) {
    if (_chunk_pnt_check("strcmp", s1, 1, 0) != NOERROR
	|| _chunk_pnt_check("strcmp", s2, 1, 0) != NOERROR)
      if (BIT_IS_SET(_malloc_debug, DEBUG_LOG_BAD_POINTER))
	_malloc_message("bad pointer argument found in strcmp");
  }
  return strcmp(s1, s2);
}
#endif

#if HAVE_STRLEN
/*
 * dummy function for checking strlen's arguments.
 */
EXPORT	int	_malloc_strlen(char * str)
{
  if (BIT_IS_SET(_malloc_debug,
		 DEBUG_CHECK_FUNCS)) {
    if (_chunk_pnt_check("strlen", str, 1, 0) != NOERROR)
      if (BIT_IS_SET(_malloc_debug, DEBUG_LOG_BAD_POINTER))
	_malloc_message("bad pointer argument found in strlen");
  }
  return strlen(str);
}
#endif

#if HAVE_STRTOK
/*
 * dummy function for checking strtok's arguments.
 */
EXPORT	char	*_malloc_strtok(char * str, char * sep)
{
  if (BIT_IS_SET(_malloc_debug, DEBUG_CHECK_FUNCS)) {
    if (_chunk_pnt_check("strtok", str, 1, 0) != NOERROR
	|| _chunk_pnt_check("strtok", sep, 1, 0) != NOERROR)
      if (BIT_IS_SET(_malloc_debug, DEBUG_LOG_BAD_POINTER))
	_malloc_message("bad pointer argument found in strtok");
  }
  return (char *)strtok(str, sep);
}
#endif

#if HAVE_BZERO
/*
 * dummy function for checking bzero's arguments.
 */
EXPORT	void	_malloc_bzero(void * buf,
			      int len)
{
  if (BIT_IS_SET(_malloc_debug, DEBUG_CHECK_FUNCS)) {
    if (_chunk_pnt_check("bzero", buf, 1, len) != NOERROR)
      if (BIT_IS_SET(_malloc_debug, DEBUG_LOG_BAD_POINTER))
	_malloc_message("bad pointer argument found in bzero");
  }
  bzero(buf, len);
}
#endif

#if HAVE_MEMCCPY
/*
 * dummy function for checking memccpy's arguments.
 */
EXPORT	char	*_malloc_memccpy(char * s1, char * s2, char ch, int len)
{
  if (BIT_IS_SET(_malloc_debug, DEBUG_CHECK_FUNCS)) {
    /* maybe len maybe first ch */
    if (_chunk_pnt_check("memccpy", s1, 1, 0) != NOERROR
	|| _chunk_pnt_check("memccpy", s2, 1, 0) != NOERROR)
      if (BIT_IS_SET(_malloc_debug, DEBUG_LOG_BAD_POINTER))
	_malloc_message("bad pointer argument found in memccpy");
  }
  return (char *)memccpy(s1, s2, ch, len);
}
#endif

#if HAVE_MEMCHR
/*
 * dummy function for checking memchr's arguments.
 */
EXPORT	char	*_malloc_memchr(char * s1, char ch, int len)
{
  if (BIT_IS_SET(_malloc_debug, DEBUG_CHECK_FUNCS)) {
    if (_chunk_pnt_check("memchr", s1, 1, len) != NOERROR)
      if (BIT_IS_SET(_malloc_debug, DEBUG_LOG_BAD_POINTER))
	_malloc_message("bad pointer argument found in memchr");
  }
  return (char *)memchr(s1, ch, len);
}
#endif

#if HAVE_STRCHR
/*
 * dummy function for checking strchr's arguments.
 */
EXPORT	char	*_malloc_strchr(char * str, char ch)
{
  if (BIT_IS_SET(_malloc_debug, DEBUG_CHECK_FUNCS)) {
    if (_chunk_pnt_check("strchr", str, 1, 0) != NOERROR)
      if (BIT_IS_SET(_malloc_debug, DEBUG_LOG_BAD_POINTER))
	_malloc_message("bad pointer argument found in strchr");
  }
  return (char *)strchr(str, ch);
}
#endif

#if HAVE_STRRCHR
/*
 * dummy function for checking strrchr's arguments.
 */
EXPORT	char	*_malloc_strrchr(char * str, char ch)
{
  if (BIT_IS_SET(_malloc_debug, DEBUG_CHECK_FUNCS)) {
    if (_chunk_pnt_check("strrchr", str, 1, 0) != NOERROR)
      if (BIT_IS_SET(_malloc_debug, DEBUG_LOG_BAD_POINTER))
	_malloc_message("bad pointer argument found in strrchr");
  }
  return (char *)strrchr(str, ch);
}
#endif

#if HAVE_STRCPY
/*
 * dummy function for checking strcpy's arguments.
 */
EXPORT	char	*_malloc_strcpy(char * to, char * from)
{
  if (BIT_IS_SET(_malloc_debug, DEBUG_CHECK_FUNCS)) {
    /* maybe to, strlen(from) */
    if (_chunk_pnt_check("strcpy", to, 1, 0) != NOERROR
	|| _chunk_pnt_check("strcpy", from, 1, 0) != NOERROR)
      if (BIT_IS_SET(_malloc_debug, DEBUG_LOG_BAD_POINTER))
	_malloc_message("bad pointer argument found in strcpy");
  }
  return (char *)strcpy(to, from);
}
#endif

#if HAVE_STRNCPY
/*
 * dummy function for checking strncpy's arguments.
 */
EXPORT	char	*_malloc_strncpy(char * to, char * from, int len)
{
  if (BIT_IS_SET(_malloc_debug, DEBUG_CHECK_FUNCS)) {
    /* len or until nullc */
    if (_chunk_pnt_check("strncpy", to, 1, 0) != NOERROR
	|| _chunk_pnt_check("strncpy", from, 1, 0) != NOERROR)
      if (BIT_IS_SET(_malloc_debug, DEBUG_LOG_BAD_POINTER))
	_malloc_message("bad pointer argument found in strncpy");
  }
  return (char *)strncpy(to, from, len);
}
#endif

#if HAVE_STRCASECMP
/*
 * dummy function for checking strcasecmp's arguments.
 */
EXPORT	int	_malloc_strcasecmp(char * s1, char * s2)
{
  if (BIT_IS_SET(_malloc_debug, DEBUG_CHECK_FUNCS)) {
    if (_chunk_pnt_check("strcasecmp", s1, 1, 0) != NOERROR
	|| _chunk_pnt_check("strcasecmp", s2, 1, 0) != NOERROR)
      if (BIT_IS_SET(_malloc_debug, DEBUG_LOG_BAD_POINTER))
	_malloc_message("bad pointer argument found in strcasecmp");
  }
  return strcasecmp(s1, s2);
}
#endif

#if HAVE_STRNCASECMP
/*
 * dummy function for checking strncasecmp's arguments.
 */
EXPORT	int	_malloc_strncasecmp(char * s1, char * s2, int len)
{
  if (BIT_IS_SET(_malloc_debug, DEBUG_CHECK_FUNCS)) {
    /* len or until nullc */
    if (_chunk_pnt_check("strncasecmp", s1, 1, 0) != NOERROR
	|| _chunk_pnt_check("strncasecmp", s2, 1, 0) != NOERROR)
      if (BIT_IS_SET(_malloc_debug, DEBUG_LOG_BAD_POINTER))
	_malloc_message("bad pointer argument found in strncasecmp");
  }
  return strncasecmp(s1, s2, len);
}
#endif

#if HAVE_STRSPN
/*
 * dummy function for checking strspn's arguments.
 */
EXPORT	int	_malloc_strspn(char * str, char * list)
{
  if (BIT_IS_SET(_malloc_debug, DEBUG_CHECK_FUNCS)) {
    if (_chunk_pnt_check("strspn", str, 1, 0) != NOERROR
	|| _chunk_pnt_check("strspn", list, 1, 0) != NOERROR)
      if (BIT_IS_SET(_malloc_debug, DEBUG_LOG_BAD_POINTER))
	_malloc_message("bad pointer argument found in strspn");
  }
  return strspn(str, list);
}
#endif

#if HAVE_STRCSPN
/*
 * dummy function for checking strcspn's arguments.
 */
EXPORT	int	_malloc_strcspn(char * str, char * list)
{
  if (BIT_IS_SET(_malloc_debug, DEBUG_CHECK_FUNCS)) {
    if (_chunk_pnt_check("strcspn", str, 1, 0) != NOERROR
	|| _chunk_pnt_check("strcspn", list, 1, 0) != NOERROR)
      if (BIT_IS_SET(_malloc_debug, DEBUG_LOG_BAD_POINTER))
	_malloc_message("bad pointer argument found in strcspn");
  }
  return strcspn(str, list);
}
#endif

#if HAVE_STRNCAT
/*
 * dummy function for checking strncat's arguments.
 */
EXPORT	char	*_malloc_strncat(char * to, char * from, int len)
{
  if (BIT_IS_SET(_malloc_debug, DEBUG_CHECK_FUNCS)) {
    /* either len or nullc */
    if (_chunk_pnt_check("strncat", to, 1, 0) != NOERROR
	|| _chunk_pnt_check("strncat", from, 1, 0) != NOERROR)
      if (BIT_IS_SET(_malloc_debug, DEBUG_LOG_BAD_POINTER))
	_malloc_message("bad pointer argument found in strncat");
  }
  return (char *)strncat(to, from, len);
}
#endif

#if HAVE_STRNCMP
/*
 * dummy function for checking strncmp's arguments.
 */
EXPORT	int	_malloc_strncmp(char * s1, char * s2, int len)
{
  if (BIT_IS_SET(_malloc_debug, DEBUG_CHECK_FUNCS)) {
    /* either len or nullc */
    if (_chunk_pnt_check("strncmp", s1, 1, 0) != NOERROR
	|| _chunk_pnt_check("strncmp", s2, 1, 0) != NOERROR)
      if (BIT_IS_SET(_malloc_debug, DEBUG_LOG_BAD_POINTER))
	_malloc_message("bad pointer argument found in strncmp");
  }
  return strncmp(s1, s2, len);
}
#endif

#if HAVE_STRPBRK
/*
 * dummy function for checking strpbrk's arguments.
 */
EXPORT	char	*_malloc_strpbrk(char * str, char * list)
{
  if (BIT_IS_SET(_malloc_debug, DEBUG_CHECK_FUNCS)) {
    if (_chunk_pnt_check("strpbrk", str, 1, 0) != NOERROR
	|| _chunk_pnt_check("strpbrk", list, 1, 0) != NOERROR)
      if (BIT_IS_SET(_malloc_debug, DEBUG_LOG_BAD_POINTER))
	_malloc_message("bad pointer argument found in strpbrk");
  }
  return (char *)strpbrk(str, list);
}
#endif

#if HAVE_STRSTR
/*
 * dummy function for checking strstr's arguments.
 */
EXPORT	char	*_malloc_strstr(char * str, char * pat)
{
  if (BIT_IS_SET(_malloc_debug, DEBUG_CHECK_FUNCS)) {
    if (_chunk_pnt_check("str", str, 1, 0) != NOERROR
	|| _chunk_pnt_check("str", pat, 1, 0) != NOERROR)
      if (BIT_IS_SET(_malloc_debug, DEBUG_LOG_BAD_POINTER))
	_malloc_message("bad pointer argument found in strstr");
  }
  return (char *)strstr(str, pat);
}
#endif
