/*
 * defines for the malloc-leap routines.
 *
 * Copyright 1992 by Gray Watson and the Antaire Corporation
 *
 * This file is part of the malloc-debug package.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library (see COPYING-LIB); if not, write to the
 * Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * The author of the program may be contacted at gray.watson@antaire.com
 *
 * $Id: malloc_lp.h,v 1.3 1993/03/26 09:16:54 gray Exp $
 */

#ifndef __MALLOC_LP_H__
#define __MALLOC_LP_H__

#undef	IMPORT
#define	IMPORT		extern

/*<<<<<<<<<<  The below prototypes are auto-generated by fillproto */

/* to inform the malloc-debug library from which file the call comes from */
IMPORT	char		*_malloc_file;

/* to inform the library from which line-number the call comes from */
IMPORT	unsigned int	_malloc_line;

/*
 * leap routine to calloc
 */
IMPORT	char	*_calloc_leap(const char * file, const int line,
			      unsigned int elen, unsigned int size);

/*
 * leap routine to free
 */
IMPORT	int	_free_leap(const char * file, const int line, char * pnt);

/*
 * leap routine to malloc
 */
IMPORT	char	*_malloc_leap(const char * file, const int line,
			      unsigned int size);

/*
 * leap routine to realloc
 */
IMPORT	char	*_realloc_leap(const char * file, const int line, char * oldp,
			       unsigned int new_size);

/*<<<<<<<<<<   This is end of the auto-generated output from fillproto. */

#endif /* ! __MALLOC_LP_H__ */
