/*
 * defines for the system specific memory routines
 *
 * Copyright 1992 by Gray Watson and the Antaire Corporation
 *
 * This file is part of the malloc-debug package.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library (see COPYING-LIB); if not, write to the
 * Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * The author of the program may be contacted at gray.watson@antaire.com
 *
 * $Id: heap.h,v 1.9 1993/03/26 09:16:41 gray Exp $
 */

#ifndef __HEAP_H__
#define __HEAP_H__

#include "malloc.h"			/* for LOCAL and bool stuff */

/*
 * error code returned by heap allocation routine
 */
#define HEAP_ALLOC_ERROR	((char *)-1)

/*
 * probably machine specific defines used for certain calculations
 */
#if HEAP_GROWS_UP

/* test whether pointer P is in the heap space */
#define IS_IN_HEAP(p)		\
  ((char *)(p) >= _heap_base && (char *)(p) < _heap_last)

/* turn pointer P into a block index */
#define WHICH_BLOCK(p)		(((p) - _heap_base) / BLOCK_SIZE)

/* get a pointer to the memory block number C */
#define BLOCK_POINTER(c)	(_heap_base + (c) * BLOCK_SIZE)

/* test whether pointer P is on a block boundary */
#define ON_BLOCK(p)		(((p) - _heap_base) % BLOCK_SIZE == 0)

/* calculate the size of heap */
#define HEAP_SIZE		(_heap_last - _heap_base)

#endif

/*<<<<<<<<<<  The below prototypes are auto-generated by fillproto */

IMPORT	char		*_heap_base;  /* base of our heap */

IMPORT	char		*_heap_last;  /* end of our heap */

/*
 * function to get SIZE memory bytes from the end of the heap
 */
IMPORT	char	*_heap_alloc(unsigned int size);

/*
 * return a pointer to the current end of the heap
 */
IMPORT	char	*_heap_end(void);

/*
 * initialize heap pointers
 */
IMPORT	void	_heap_startup(void);

/*
 * align (by extending) _heap_base to BASE byte boundary
 */
IMPORT	char	*_heap_align_base(int base);

/*<<<<<<<<<<   This is end of the auto-generated output from fillproto. */

#endif /* ! __HEAP_H__ */
