/*
 * defines for low level memory management routines
 *
 * Copyright 1992 by Gray Watson and the Antaire Corporation
 *
 * This file is part of the malloc-debug package.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library (see COPYING-LIB); if not, write to the
 * Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * The author of the program may be contacted at gray.watson@antaire.com
 *
 * $Id: chunk.h,v 1.16 1993/04/05 22:29:57 gray Exp $
 */

#ifndef __CHUNK_H__
#define __CHUNK_H__

#include "malloc.h"			/* for IMPORT ... */

/* some argument defines */
#define CHUNK_PNT_ANAL	0		/* anal checking on pointer */
#define CHUNK_PNT_LOOSE	1		/* looser checking */

/*<<<<<<<<<<  The below prototypes are auto-generated by fillproto */

IMPORT	int		_calloc_count;  /* # callocs, done in alloc */

/*
 * startup the low level malloc routines
 */
IMPORT	int	_chunk_startup(void);

/*
 * run extensive tests on the entire heap depending on TYPE
 */
IMPORT	int	_chunk_heap_check(void);

/*
 * run extensive tests on PNT from FUNC. test PNT HOW_MUCH of MIN_SIZE
 * (or 0 if unknown).  returns [NO]ERROR
 */
IMPORT	int	_chunk_pnt_check(const char * func, char * pnt,
				 const int check, int min_size);

/*
 * return some information associated with PNT, returns [NO]ERROR
 */
IMPORT	int	_chunk_read_info(char * pnt, unsigned int * size,
				 char ** file, unsigned int * line);

/*
 * get a SIZE chunk of memory for FILE at LINE
 */
IMPORT	char	*_chunk_malloc(const char * file, const unsigned int line,
			       unsigned int size);

/*
 * frees PNT from the heap, returns FREE_ERROR or FREE_NOERROR
 */
IMPORT	int	_chunk_free(const char * file, const unsigned int line,
			    char * pnt);

/*
 * reallocate a section of memory
 */
IMPORT	char	*_chunk_realloc(const char * file, const unsigned int line,
				char * oldp, unsigned int new_size);

/*
 * log present free and used lists
 */
IMPORT	void	_chunk_list_count(void);

/*
 * log statistics on the heap
 */
IMPORT	void	_chunk_stats(void);

/*
 * dump the unfreed memory, logs the unfreed information to logger
 */
IMPORT	void	_chunk_dump_not_freed(void);

/*
 * log the heap structure plus information on the blocks if necessary
 */
IMPORT	void	_chunk_log_heap_map(void);

/*<<<<<<<<<<   This is end of the auto-generated output from fillproto. */

#endif /* ! __CHUNK_H__ */
