/*<><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><>
	GUTS.CPP - Guts Poker for DOS
	User plays up to five computer controlled opponents (six players total).
	Play three card, high hand, single draw guts poker. There is no betting.
	Ante. Deal three cards. Draw up to three cards. Declare in or out.
	High hand takes the pot. Any losing players that declare in must match the
	pot. Deal rotates. Play continues until only one player declares in.
	Specify cards to draw separated by spaces like examples below:
	1 3<enter>	Discard cards one and three
	2<enter>		Discard card two
	2 3<enter>	Discard cards two and three
	Legal hands are High card, Pair, or Three of a Kind.
	Straights and flushes don't count.

	Author - Harlan Marshall	73737,1072	4/2/94
	My first C++ program.
	This source code is free to all. Copying or use of all or any portions
	are freely granted.
	Comments and suggestions greatly appreciated.

<><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><*/
#include <iostream.h>
#include <string.h>
#include <stdlib.h>
#include <conio.h>

#define INITBANK 500				// All player's initial bank balances

#define DISCARDLIMIT 12			// Lowest value that a computer controlled
										// player will not discard
#define BLUFFRATE 2				// Percentage of times that a computer controlled
										// player will bluff

#ifdef __cplusplus							// Macro to return larger of two values
	float max(float value1, float value2);
	float max(float value1, float value2)
	{
		return ( (value1 > value2) ? value1 : value2);
	}
#endif

int randPercent(int p);
int randPercent(int p)				// Return 1 exactly p percent of the time
{
	int n, hit;

	if(p > 0)
	{
		n = random(100 / p);
		if(n == 0)
			hit = 1;
		else
			hit = 0;
	}
	else
		hit = 0;

	return(hit);
}

class card			 						// Card object class
{
	char suit;	// Card suit, (ASCII) 3 = heart, 4 = diamond, 5 = club, 6 = spade
	int rank; 	// Card rank, 2 thru 14
	int delt;	// Delt logical flag, 0 = has not delt, 1 = has been delt

public:
	card(){delt = 0;}

	int play()							// Deal card if not already delt
	{
		if(delt != 0)
			return 1;
		delt = 1;
		return 0;
	}

	void setCard(char s, int r) {suit = s; rank = r;}	// Set suit and rank

	int getRank() {return(rank);}		// Get rank of card

	int getDelt() {return(delt);}		// Get delt flag

	void setDelt(int a) {delt = a;}	// Set delt flag

	void showCard();						// Show card on screen

};

card crd[52];											// Global array of card objects

void card::showCard()								// Show card on screen
{
	char valuestr[3];

	switch(rank)										// Translate rank to card value
	{
		case(2): strcpy(valuestr,"2"); break;
		case(3): strcpy(valuestr,"3"); break;
		case(4): strcpy(valuestr,"4"); break;
		case(5): strcpy(valuestr,"5"); break;
		case(6): strcpy(valuestr,"6"); break;
		case(7): strcpy(valuestr,"7"); break;
		case(8): strcpy(valuestr,"8"); break;
		case(9): strcpy(valuestr,"9"); break;
		case(10): strcpy(valuestr,"10"); break;
		case(11): strcpy(valuestr,"J"); break;
		case(12): strcpy(valuestr,"Q"); break;
		case(13): strcpy(valuestr,"K"); break;
		case(14): strcpy(valuestr,"A"); break;
	};

	cout << valuestr << suit << " ";
}

class player					// Player object class
{
	char name[21];	// Player's name
	int bluffrate;	// Percentage of times that player will bluff
	int bluff;		// logical flag, 0 = not bluffing, 1 = bluffing
	int callbluff;	// logical flag, 0 = won't call bluff, 1 = will call bluff
	int hand[3];	// Array of three cards (player's hand)
	float bank;		// Amount in player's bank
	//float bet;
	int disc_code;	// Player's discard code
						// 0=none, 1=1, 2=2, 3=3, 4=1&2, 5=2&3, 6=1&3, 7=all
	int handrank;	// Rank of player's hand
						// 4-14 = high card, 15-27 = pair, 28-40 = trips
	int confidence;// Player's confidence level, 0 = none to 3 = very confident
	int declare;	// logical flag, 0 = out, 1 = in
public:
	player(char *n)
	{
		strcpy(name, n);		// Store player's name on construction
		bank = INITBANK;		// Initialize player's bank
		//bet = 0;
		bluff = 0;				// Initialize bluff flag
	}

	void setName(char *n) {strcpy(name, n);}	// Store player's name

	void draw(int n);		// Discard and draw card n

	void showHand()		// Show player's hand on screen
	{
		cout << name << "'s cards:\t";
		crd[hand[0]].showCard();
		crd[hand[1]].showCard();
		crd[hand[2]].showCard();
		cout << " \n";
	}

	void setBluffRate(int n) {bluffrate = n;}	// Set player's bluffrate

	void changeBank(float b) {bank += b;}	// Add b to player's bank

	void showBank() {cout << name << "'s bank:\t$" << bank << "\n";}
														// Show player's bank to screen
	float getBank() {return(bank);}			// Get player's bank balance

	char *getPlayerName() {return(name);}	// Get player's name

	void setDiscardCode(int d) {disc_code = d;}	// Set player's discard code

	void discard();								// Discard and draw new cards

	int getConfidence() {return(confidence);}	// Get player's confidence level

	void calcDeclare(int num);	// Calculate declare of computer controlled player

	void setDeclare(int d) {declare = d;}		// Set player's declare

	void showDeclare();							// Show player's declare to screen

	int getDeclare() {return(declare);}	// Get player's declare

	void rankHand();							// Calculate rank of player's hand

	void randBluffing() {bluff = randPercent(bluffrate);}	// Set bluff flag

/*// Debug section =============================================================
	int getBluffing() {return(bluff);}							// Get bluff flag
	int getCall() {return(callbluff);}							// Get callbluff flag
//============================================================================*/

	int getHandRank() {return(handrank);}		// Get rank of player's hand

	int getCard(int c) {return(hand[c]);}		// Get card c from player's hand

/*// Debug section =============================================================
	//Debug function to show player's hand rank to the screen
	void showHandRank() {cout << name << "'s hand rank: " << handrank << "\n";}
//============================================================================*/
};

// Global array of player objects
// plyr[0] is user, other players are computer controlled
player plyr[6] = {"", "Jeff", "Happy", "Cory", "Tom", "Bill"};

void player::draw(int n)							// Draw a single card
{
	int i;

	randomize();
	do
		i = random(52);
	while(crd[i].getDelt());
	hand[n] = i;
	crd[i].setDelt(1);
}

void player::rankHand()	// Calculate rank and discard code of player's hand
{			// Discard codes: 0=none, 1=1, 2=2, 3=3, 4=1&2, 5=2&3, 6=1&3, 7=all
			// Rank of hand: 4-14 = high card, 15-27 = pair, 28-40 = trips
	int cv[3];				// Array of three card values
	int hrank;				// Hand rank value
	int topcard;			// Number of highest value card in hand
	int i;

	for(i=0; i<3; i++)								// Get card values
		cv[i] = crd[hand[i]].getRank();

	if(cv[0] != cv[1] && cv[0] != cv[2] && cv[1] != cv[2]) // no pairs
	{
		hrank = max(cv[0], cv[1]);					// Calc value of highest card
		hrank = max(hrank, cv[2]);

		topcard = (cv[0] > cv[1]) ? 0 : 1;		// Get number of highest card
		topcard = (cv[topcard] > cv[2]) ? topcard : 2;

/*// Debug section =============================================================
	cout << name << "'s high card #: " << topcard + 1 << "\n";
//============================================================================*/

		if(cv[0] < DISCARDLIMIT && cv[1] < DISCARDLIMIT && cv[2] < DISCARDLIMIT)
			disc_code = 7;				// Discard all three
		else if(topcard == 1)
			disc_code = 6;				// Discard first & third cards
		else if(topcard == 0)
			disc_code = 5;				// Discard second & third cards
		else if(topcard == 2)
			disc_code = 4;				// Discard first & second cards
	}
	else if(cv[0] == cv[1] && cv[1] != cv[2]) // 1&2 pair
		{hrank = cv[0] + 13; disc_code = 3;}	// Discard third card
	else if(cv[0] == cv[2] && cv[1] != cv[2]) // 1&3 pair
		{hrank = cv[0] + 13; disc_code = 2;}	// Discard second card
	else if(cv[0] != cv[1] && cv[1] == cv[2]) // 2&3 pair
		{hrank = cv[1] + 13; disc_code = 1;}	// Discard first card
	else													// three of a kind
		{hrank = cv[0] + 26; disc_code = 0;}	// no discards

	handrank = hrank;
}

void player::calcDeclare(int num)
{
	int i;
	int topcon, oldtopcon;

	topcon = oldtopcon = plyr[0].getConfidence();	// Get user's confidence

	for(i=1; i<num; i++)				// Calculate most confident player
	{
		if(strcmp(name, plyr[i].getPlayerName()))
		{
			topcon = plyr[i].getConfidence();
			topcon = (topcon > oldtopcon) ? topcon : oldtopcon;
			if(topcon != oldtopcon)
				oldtopcon = topcon;
		}
	}

/*// Debug section =============================================================
	cout << name << ":\tTopcon: " << topcon << "\tRank: " << handrank << "\t";
//============================================================================*/

	if(handrank < 12)                  // Low card, declare out, don't call bluff
	{
		declare = 0;
		callbluff = 0;
	}

	if(handrank >= 12 && handrank < 15) // High card, calculate declare
	{
		if(topcon <= 1)
			declare = 1;
		else
			declare = 0;
		if(topcon == 3)
		{
			randomize();						// If any other players discard 0
			callbluff = randPercent(15);	// Determine if player will call bluff
		}
	}

	if(handrank >= 15 && handrank < 20) // Low pair, calculate declare
	{
		if(topcon <= 1)
			declare = 1;
		else
			declare = 0;
		if(topcon == 3)
		{
			randomize();						// If any other players discard 0
			callbluff = randPercent(30);  // Determine if player will call bluff
		}
	}

	if(handrank >= 20 && handrank < 28) // High pair, calculate declare
	{
		if(topcon <= 2)
			declare = 1;
		else
			declare = 0;
		if(topcon == 3)
		{
			randomize();                  // If any other players discard 0
			callbluff = randPercent(50);	// Determine if player will call bluff
		}
	}

	if(handrank >= 28) 						// Any trips, declare in, call bluff
	{
			declare = 1;
			callbluff = 1;
	}

	if(bluff || callbluff)
		declare = 1;

/*// Debug section =============================================================
	cout << name << ":\t" << declare << "\t";
//============================================================================*/
}

void player::discard()	// Discard and draw new cards
{	// Discard codes 0=none, 1=1, 2=2, 3=3, 4=1&2, 5=2&3, 6=1&3, 7=all
	if(disc_code == 0 || bluff)
	{
		cout << name << " draws 0 cards.\n";
		confidence = 3;
	}
	else
		switch(disc_code)
		{
			case 1: draw(0); cout << name << " draws 1 card.\n";
				confidence = 2; break;
			case 2: draw(1); cout << name << " draws 1 card.\n";
				confidence = 2; break;
			case 3: draw(2); cout << name << " draws 1 card.\n";
				confidence = 2; break;
			case 4: draw(0); draw(1); cout << name << " draws 2 cards.\n";
				confidence = 1; break;
			case 5: draw(1); draw(2); cout << name << " draws 2 cards.\n";
				confidence = 1; break;
			case 6: draw(0); draw(2); cout << name << " draws 2 cards.\n";
				confidence = 1; break;
			case 7: draw(0); draw(1); draw(2); cout << name << " draws 3 cards.\n";
				confidence = 0; break;
		};
}

void player::showDeclare()		// Show player's declare to screen
{
	if(declare == 0)
		cout << name << ":\tOUT!\n";
	else
		cout << name << ":\tIN!\n";
}

class pot							// Pot object class
{
	float amount;		// Pot balance

public:
	pot() {amount = 0;}

	void changePot(float b) {amount += b;}		// Add b to pot balance

	void showPot() {cout << "Pot: $" << amount << "\n";}	// Show pot balance
																			// to screen
	void setPot(float b) {amount = b;}			// Set pot balance

	float getPot() {return(amount);}          // Get pot balance
};

pot thePot;			// Global pot object

void newDeck(void);			// Miscellaneous function declarations
void deal(int numplyrs);
int calcWinner(int numplyrs, int *incount, int *losers);
int breakTie(int i, int oldtop);
//int sort_function( const void *a, const void *b);
void sort(int *list, int size);

//****************************************************************************
main()
{
	int nplayers;							// Number of players
	char pname[21];                  // User's name
	float ante;								// Ante amount
	int nowin = 1, playagain = 1;		// Continue flags
	int ndisc;                       // Number of discards
	int disc[3];                     // Discard flags
	int inout;                			// Declare flag
	char answer;
	int dealer = 0;                  // Current dealer
	int winner, losers[5];				// Winner and losers
	int incount;							// Number of players that declare in
	int i;
	float totalwin;

	clrscr();
	cout << "Enter your first name: ";		// Get player's name
	cin >> pname;
	plyr[0].setName(pname);						// Player 0 is the user

	do													// Get number of players
	{
		cout << "Enter number of players: ";
		cin >> nplayers;
		if(nplayers > 6)
			cout << "Maximum six players. Try again.\n";
	} while(nplayers > 6);
	clrscr();
	cout << "Welcome to GONADS 2000, " << pname <<
	"!\nYou have $500 to piss away tonight. Good luck!\n";

	newDeck();									//	Initialize cards in deck
	for(i=1; i<nplayers; i++)				// Set bluff rate for players
		plyr[i].setBluffRate(BLUFFRATE);

	do                                  // Start a new game
	{
	cout << "Starting new game.\n";
	cout << "Enter ante: ";						// Get ante amount
	cin >> ante;

	if(dealer < nplayers - 1)              // Rotate dealer
		dealer++;
	else
		dealer = 0;
	cout << plyr[dealer].getPlayerName() << " is now dealing.\n"; // Show dealer

	do												// Start a new hand if no single
	{                                   // player has declared in
		cout << "Starting new hand.\n";
		for(i=0; i<52; i++)              // Shuffle deck
			crd[i].setDelt(0);
/*// Debug section =============================================================
	//Test function to display deck
	cout << "Deck: \n";
	for(i=0; i<52; i++)
	{
		cout << "(";
		crd[i].showCard();
		cout << crd[i].getDelt() << ") ";
	}
//============================================================================*/

		cout << "Ante $" << ante << " each.\n";	// All players ante
		for(i=0; i<nplayers; i++)
			plyr[i].changeBank(-ante);
		thePot.changePot(ante * nplayers);			// Make pot good
		for(i=0; i<nplayers; i++)			// Show player's banks
			plyr[i].showBank();
		thePot.showPot();						// Show the pot
		deal(nplayers);                  // Deal 3 cards to each player

		plyr[0].showHand();		// Show user's hand to screen

/*// Debug section =============================================================
		for(i=1; i<nplayers; i++)
			plyr[i].showHand();
//============================================================================*/

		randomize();
		for(i=1; i<nplayers; i++)			// Determine if any players are going
			plyr[i].randBluffing();       // to bluff

/*// Debug section =============================================================
		cout << "Players that are bluffing:\t";
		for(i=1; i<nplayers; i++)
			cout << plyr[i].getBluffing();
		cout << "\n";
//============================================================================*/

		for(i=dealer+1; i<nplayers; i++)	// Allow first players to discard
		{
			plyr[i].rankHand();
			plyr[i].discard();
			plyr[i].rankHand();
		}

		do											// Get user's discards
		{
			cout << "How many cards would you like, " << pname << "? ";
			cin >> ndisc;
			if(ndisc > 3)
				cout << "You're only holding three cards. Try again.\n";
		}
		while(ndisc > 3);

		// Get user's discards
		// Discard codes 0=none, 1=1, 2=2, 3=3, 4=1&2, 5=2&3, 6=1&3, 7=all
		if(ndisc == 3)
		{
			plyr[0].setDiscardCode(7);
			plyr[0].discard();
		}

		if(ndisc > 0 && ndisc < 3)
		{
			cout << "Enter card numbers to discard (1 2 3): ";
			switch(ndisc)
			{
				case 1:						// Discard one card
					cin >> disc[0];
					if(disc[0] == 1)
						plyr[0].setDiscardCode(1);
					if(disc[0] == 2)
						plyr[0].setDiscardCode(2);
					if(disc[0] == 3)
						plyr[0].setDiscardCode(3);
					plyr[0].discard();
					break;
				case 2:						// Discard two cards
					cin >> disc[0] >> disc[1];
					if(disc[0] == 1 && disc[1] == 2)
						plyr[0].setDiscardCode(4);
					if(disc[0] == 2 && disc[1] == 3)
						plyr[0].setDiscardCode(5);
					if(disc[0] == 1 && disc[1] == 3)
						plyr[0].setDiscardCode(6);
					plyr[0].discard();
					break;
			};
		}

		if(ndisc == 0)
		{
			plyr[0].setDiscardCode(0);
			plyr[0].discard();			// Do this anyway in order to set confidence
		}

		plyr[0].rankHand();           // Rank user's hand
		plyr[0].showHand();				// Show user's hand

		for(i=1; i<=dealer; i++)		// Allow the rest of the players to discard
		{
			plyr[i].rankHand();
			plyr[i].discard();
			plyr[i].rankHand();
		}

/*// Debug section =============================================================
		for(i=1; i<nplayers; i++)
			plyr[i].showHand();
		//for(i=0; i<nplayers; i++)
			//plyr[i].showHandRank();
//============================================================================*/

		// Get user's declare, in or out
		cout << "Declare in or out. 1 you're in, 0 you're out.: ";
		cin >> inout;
		plyr[0].setDeclare(inout);			// Set user's declare flag
		plyr[0].showDeclare();				// Show user's declare to screen

		// All other players declare
		for(i=1; i<nplayers; i++)
		{
			plyr[i].calcDeclare(nplayers);		// Set player's declare flag
			plyr[i].showDeclare();					// Show player's declare to screen
/*// Debug section =============================================================
			cout << "callbluff = " << plyr[i].getCall() << "\n";
//============================================================================*/
		}

		for(i=0; i<nplayers; i++)	// Show all player's hands
			plyr[i].showHand();

		winner = calcWinner(nplayers, &incount, losers);//Calc winner & losers

/*// Debug section =============================================================
		cout << "Number of players that declared IN: " << incount << "\n";
//============================================================================*/

		cout << plyr[winner].getPlayerName() << " takes the hand.\n";
																	// Show winner to screen
		if(incount != 0)						// If at least one player declares in
		{
			if(incount == 1)					// Only one player declares in
			{
				nowin = 0;                 // No winner flag turned off
				plyr[winner].changeBank(thePot.getPot());	// Winner takes the pot
				thePot.setPot(0);									// Set pot to 0
			}
			else									// Two or more players declare in
			{
				nowin = 1;                 // No winner flag turned on
				plyr[winner].changeBank(thePot.getPot());	// Winner takes the pot
				for(i=0; i<incount-1; i++)						// Loosers match the pot
				{
					plyr[losers[i]].changeBank(-(thePot.getPot()));
																// Adjust looser's bank balances
					cout << plyr[losers[i]].getPlayerName() << " matches the pot.\n";
																// Show loosers to screen
				}
				thePot.setPot((thePot.getPot()) * (incount - 1)); // Make pot good
			}
		}
		else
			nowin = 1;		// Set no winner flag on because no players declared in

		for(i=0; i<nplayers; i++)			// Show player's banks
			plyr[i].showBank();
		thePot.showPot();						// Show the pot

		cout << "Press any key to continue...\n";
		getch();
		clrscr();
	}
	while(nowin);							// As long as no single player declared in
	cout << "Play again? (Y / N): ";	// Get user's choice to play another game
	cin >> answer;
	if(answer == 'Y' || answer == 'y')
		playagain = 1;
	else
		playagain = 0;
	clrscr();
	}
	while(playagain);						// As long as user wants to play again
	for(i=0; i<nplayers; i++)			// Show player's banks
		plyr[i].showBank();
	totalwin = (plyr[0].getBank()) - 500;	// Calculate user's total winnings
	if(totalwin > 0)
	{
		cout << "You're up $" << totalwin << " this evening, " << pname << ".\n";
		cout << "Sleep well and hope you're this lucky again next time.\n";
	}
	else if(totalwin < 0)
	{
		cout << "You lost $" << totalwin << " this evening, " << pname << ".\n";
		cout << "Drink another beer, call a cab and sneak quietly into your ";
		cout << "house.\n";
	}
	else
	{
		cout << "You broke even this evening, " << pname << ".\n";
		cout << "Better than losing, eh?\n";
	}
	cout << "Bye.\n";
	return 0;
}
//****************************************************************************
void newDeck(void)				// Define all cards in deck
{
	crd[0].setCard(3,2);
	crd[1].setCard(3,3);
	crd[2].setCard(3,4);
	crd[3].setCard(3,5);
	crd[4].setCard(3,6);
	crd[5].setCard(3,7);
	crd[6].setCard(3,8);
	crd[7].setCard(3,9);
	crd[8].setCard(3,10);
	crd[9].setCard(3,11);
	crd[10].setCard(3,12);
	crd[11].setCard(3,13);
	crd[12].setCard(3,14);
	crd[13].setCard(4,2);
	crd[14].setCard(4,3);
	crd[15].setCard(4,4);
	crd[16].setCard(4,5);
	crd[17].setCard(4,6);
	crd[18].setCard(4,7);
	crd[19].setCard(4,8);
	crd[20].setCard(4,9);
	crd[21].setCard(4,10);
	crd[22].setCard(4,11);
	crd[23].setCard(4,12);
	crd[24].setCard(4,13);
	crd[25].setCard(4,14);
	crd[26].setCard(5,2);
	crd[27].setCard(5,3);
	crd[28].setCard(5,4);
	crd[29].setCard(5,5);
	crd[30].setCard(5,6);
	crd[31].setCard(5,7);
	crd[32].setCard(5,8);
	crd[33].setCard(5,9);
	crd[34].setCard(5,10);
	crd[35].setCard(5,11);
	crd[36].setCard(5,12);
	crd[37].setCard(5,13);
	crd[38].setCard(5,14);
	crd[39].setCard(6,2);
	crd[40].setCard(6,3);
	crd[41].setCard(6,4);
	crd[42].setCard(6,5);
	crd[43].setCard(6,6);
	crd[44].setCard(6,7);
	crd[45].setCard(6,8);
	crd[46].setCard(6,9);
	crd[47].setCard(6,10);
	crd[48].setCard(6,11);
	crd[49].setCard(6,12);
	crd[50].setCard(6,13);
	crd[51].setCard(6,14);
}

void deal(int numplyrs)					// Deal three cards to all player's
{
	int i, n;

	for(i=0; i<3; i++)
		for(n=0; n<numplyrs; n++)
			plyr[n].draw(i);
}

int calcWinner(int numplyrs, int *incount, int *losers)	// Determine winners
{																			// and loosers
	int i;
	int rank[6];
	int losernum = 0;
	int oldtop, top;
	int firstin = 1;

	*incount = 0;											// Initialize incount

	for(i=0; i<numplyrs; i++)							// For all players
	{
		if(plyr[i].getDeclare())						// If player is in
		{
			(*incount)++;					// Increment count of players that are in
			rank[i] = plyr[i].getHandRank();			// Rank player's hand
			if(!firstin)
			{
/*// Debug section =============================================================
		cout << plyr[i].getPlayerName() << "'s Hand Rank:\t" << rank[i] << "\n";
//============================================================================*/
			// Determine if there is a player that beats previous top
				if(rank[i] == rank[oldtop])				// Hand rank tie
				{
/*// Debug section =============================================================
		cout << plyr[i].getPlayerName() << " - Tie Break - ";
		cout << plyr[oldtop].getPlayerName() << "\n";
//============================================================================*/
					top = breakTie(i, oldtop);				// Break tie
				}
				else
					top = (rank[i] > rank[oldtop]) ? i : oldtop;
				if(i == top)
					losers[losernum++] = oldtop;
				else
					losers[losernum++] = i;
				oldtop = top;
			}
			else
			{
				top = oldtop = i;
				firstin = 0;
			}
		}
	}
	return(top);
}

int breakTie(int p1, int p2)		// Break a tie condition
{
	int winner;
	int cv1[3];
	int cv2[3];
	int breakcard1, breakcard2;
	int i;

	for(i=0; i<3; i++)
		cv1[i] = crd[plyr[p1].getCard(i)].getRank();
	for(i=0; i<3; i++)
		cv2[i] = crd[plyr[p2].getCard(i)].getRank();

/*// Debug section =============================================================
		cout << "Player 1 cards before sorting: ";
		for(i=0; i<3; i++)
			cout << cv1[i] << " ";
		cout << "\n";
		cout << "Player 2 cards before sorting: ";
		for(i=0; i<3; i++)
			cout << cv2[i] << " ";
		cout << "\n";
//============================================================================*/

	// qsort doesn't seem to work
	//qsort((void *)cv1, 3, sizeof(cv1[0]), sort_function);// Sort player's cards
	//qsort((void *)cv2, 3, sizeof(cv2[0]), sort_function);// Sort player's cards

	sort(cv1, 3);					// Sort 1st player's cards
	sort(cv2, 3);					// Sort 2nd player's cards

/*// Debug section =============================================================
		cout << "Player 1 cards after sorting: ";
		for(i=0; i<3; i++)
			cout << cv1[i] << " ";
		cout << "\n";
		cout << "Player 2 cards after sorting: ";
		for(i=0; i<3; i++)
			cout << cv2[i] << " ";
		cout << "\n";
//============================================================================*/

	if(cv1[0] != cv1[1] && cv1[0] != cv1[2] && cv1[1] != cv1[2])	// No pairs
		if(cv1[1] == cv2[1])
			if(cv1[0] == cv2[0])
			{
				winner = p1;
				cout << plyr[p1].getPlayerName() << " ties with ";
				cout << plyr[p2].getPlayerName() << "\n";
			}
			else
				winner = (cv1[0] > cv2[0]) ? p1 : p2;
		else
			winner = (cv1[1] > cv2[1]) ? p1 : p2;
	else
	{
		if(cv1[0] == cv1[1])			// Player1 1&2 pair
			breakcard1 = cv1[2];
		else if(cv1[0] == cv1[2])	// Player1 1&3 pair
			breakcard1 = cv1[1];
		else if(cv1[1] == cv1[2])	// Player1 2&3 pair
			breakcard1 = cv1[0];

		if(cv2[0] == cv2[1])			// Player2 1&2 pair
			breakcard2 = cv2[2];
		else if(cv2[0] == cv2[2])	// Player2 1&3 pair
			breakcard2 = cv2[1];
		else if(cv2[1] == cv2[2])	// Player2 2&3 pair
			breakcard2 = cv2[0];

		winner = (breakcard1 > breakcard2) ? p1 : p2;
	}
	return(winner);
}

// sort function called by qsort(), can't get it to work, replaced with my own
/*int sort_function( const void *a, const void *b)
{
	int c;

	if((int *)a == (int *)b)
		c = 0;
	else
		c = ((int *)a > (int *)b) ? 1 : -1;

	return(c);
}*/

void sort(int *list,int  size)	// Sort a list of values
{											// In this case order cards in hand by value
	int out, in, temp;

	for(out=0; out<size-1; out++)
		for(in=out+1; in<size; in++)
			if(list[out] > list[in])
			{
				temp = list[in];
				list[in] = list[out];
				list[out] = temp;
			}
}

