/* GETKH.C - This program, in conjuction with GETKHA.ASM, demonstrates
the use of getkey hooks. */

#include <string.h>
#include <dos.h>

/*=============== CODE/DATA TO MANAGE GETKEY HOOK SUPPORT ============*/

int (*poll0_hook)(),
    (*filter0_hook)(),
    (*poll1_hook)();

/* 
The i16setup function is located within the GETHKA.ASM module.
*/

int extern i16setup();

/* 
The following three functions provide default 
null action when poll calls are made.
*/

int initial_poll0_proc(int far *keycode) {
  return(0);
  }

int initial_filter0_proc(int far *keycode) {
  return(0);
  }

int initial_poll1_proc() {
  return(0);
  }

/*
Initialize the three hook pointers to point to the null functions
and call i16setup to establish the INT 16H and INT 22H intercepts.
*/

void setup_initial() {
  poll0_hook = &initial_poll0_proc;
  filter0_hook = &initial_filter0_proc;
  poll1_hook = &initial_poll1_proc;
  i16setup();
  }

/*============ CODE/DATA TO MANAGE PRE-STUFFING OF PROMPTS ===========*/

int (*previous_p0_stf)();    /* pointer to previous poll0 hook */
int (*previous_p1_stf)();    /* pointer to previous poll1 hook */
char stuff_buff[81];         /* buffer in which pre-stuff data is held */
char *stuff_ptr;             /* pointer to current character in buffer */

/*
This is the poll0 function. Anytime stuff_ptr points to non-null
data, that keycode is returned. Note that the scan code portion of
the keycode is set to FF for simplicity. If no data is available,
the call is passed on to the previous poll0 hook function.
*/

int p0_stuffit(int far *keycode) {

  if(*stuff_ptr != 0) {
    *keycode = (0xff << 8) + *stuff_ptr++;
    return(1);
    }
  else return((*previous_p0_stf)(keycode));
  }

/*
This is the poll1 function. It uses the same test as the poll0
function to determine if data is available. The only difference 
is that no data is return - only an indication that data
is available.
*/

int p1_stuffit() {

  if(*stuff_ptr != 0) return(1);
  return((*previous_p1_stf)());
  }

/*
This function initializes the pre-stuff buffer, records the
current addresses in the poll0 and poll1 hook pointers and 
updates them to point to p0_stuffit() and p1_stuffit()
respectively.
*/

void setup_stuffit() {

  stuff_buff[0] = 0;
  stuff_ptr = stuff_buff;
  disable();
  previous_p0_stf = poll0_hook;
  poll0_hook = &p0_stuffit;
  previous_p1_stf = poll1_hook;
  poll1_hook = &p1_stuffit;
  enable();
  }

/*============ CODE/DATA TO MANAGE SIMPLE KEYSTROKE MACROS ===========*/

#define mac_record_key 0x4400    /* The keycode for an F10 key */
#define mac_play_key 0x7100      /* The keycode for an Alt-F10 key */
int (*previous_p0_mac)();        /* pointer to previous poll0 hook */
int (*previous_f0_mac)();        /* pointer to previous filter0 hook */
int (*previous_p1_mac)();        /* pointer to previous poll1 hook */
#define mac_buff_size 80
int mac_buff[mac_buff_size],     /* buffer for recorded keystrokes */
    mac_ndx,                     /* index into mac_buff[] */
    mac_recflg,                  /* != 0 when recording is being done */
    mac_playflg;                 /* != 0 when playback is being done */

/*
This is the poll0 hook. When the filter0 hook detects the playback
hot-key, it will set the playback flag. Upon finding this flag set 
the p0_mac function will return the next buffered keycode to the 
INT 16H hook processing intercept logic. Only when this hook 
function has no data to report will it pass the call on to 
the previous hook function.
*/

int p0_mac(int far *keycode) {

  if(mac_playflg == 1) {
    *keycode = mac_buff[mac_ndx];
    if(mac_buff[++mac_ndx] == 0) mac_playflg = 0;  /* end of buffer? */
    return(1);
    }
  else return((*previous_p0_mac)(keycode));
  }

/*
The macro filter hook function has three basic functions. First, it
must test for the start/stop recording hot-key. Second, it must test
for the playback hot-key. Third, it must record all other keystrokes
entered when a playback is in session. Only when this hook function
does not absorb the keycode does it pass the call on to the 
previous hook function.
*/

int f0_mac(int far *keycode) {

  int absorb_stat;        /* this local flag is used to signal when */
                          /* the current keycode is to be absorbed. */

  absorb_stat = 0;
  if(*keycode == mac_record_key) {
    absorb_stat = 1;            /* absorb the hot-key */
    if(mac_recflg == 1) {       /* if already recording, stop */
      mac_recflg = 0;
      mac_buff[mac_ndx] = 0;
      }
    else {                      /* else, start recording afresh */
      mac_recflg = 1;
      mac_ndx = 0;
      }
    }
  else if(*keycode == mac_play_key) {
    absorb_stat = 1;            /* absorb the hot-key */
    if(mac_recflg == 0) {       /* ignore if recording */
      mac_playflg = 1;          /* signal the poll hook */
      mac_ndx = 0;
      }
    }
  else if(mac_recflg == 1 && mac_ndx < mac_buff_size)
    mac_buff[mac_ndx++] = *keycode;        /* record the keystroke */
  if(absorb_stat == 0) return((*previous_f0_mac)(keycode));
  else return(1);
  }

/*
This is the poll1 function. It uses the same test as the poll0
function to determine if data is available. The only difference 
is that no data is return - only an indication that data
is available.
*/

int p1_mac() {

  if(mac_playflg == 1) return(1);
  else return((*previous_p1_mac)());
  }

/*
This function initializes the macro index and state flags and
records the current addresses in the poll0, filter0 and poll1 
hook pointers. It then updates each them to point to 
the respective hook function.
*/

void setup_mac() {

  mac_ndx = 0;
  mac_recflg = 0;
  mac_playflg = 0;
  disable();
  previous_p0_mac = poll0_hook;
  poll0_hook = &p0_mac;
  previous_f0_mac = filter0_hook;
  filter0_hook = &f0_mac;
  previous_p1_mac = poll1_hook;
  poll1_hook = &p1_mac;
  enable();
  }

/*================= THE MAIN APPLICATION CODE ========================*/

main() {

char workbuf[200];

  setup_initial();    /* initialize the INT 16H intercept logic */
  setup_stuffit();    /* initizlize the pre-stuff hook logic */
  setup_mac();        /* initialize the macro hook logic */

  strcpy(stuff_buff,"John Doe");    /* doing a pre-stuff is this simple */

  printf("\nEnter your name: ");    /* use built-in library fuctions */
  gets(workbuf);                    /* to effect a simple prompt */
  printf("\nHello, %s\",workbuf);

  }

