/*

  SPRITED4.C - More sprite drawing

  Written by Phil Inch for Game Developers Magazine (issue 4).
  Contributed to the public domain.

  This program written and compiled with Borland C++ v3.1
  Compatibility with other compilers is not guaranteed.

  Usage of this program is subject to the disclaimer printed
  in the magazine.  You assume all risks associated with the use
  of this program.


  The sprite:

   01234567890123456
   **......*......** 0
   **......*......** 1
   ........*........ 2
   **.....***.....** 3
   **.....***.....** 4
   **....*****....** 5
   **....*****....** 6
   **...*******...** 7
   **..*********..** 8
   **.***********.** 9
   *****.*****.***** 0
   ****..*****..**** 1
   ***...*****...*** 2
   **.............** 3
   **.....***.....** 4
   **....*.*.*....** 5

*/

/****************************** SPRITE DATA ********************************/

char sprite_data[] = {
   17, 16,
   14,14,0,0,0,0,0,0,1,0,0,0,0,0,0,14,14,
   14,14,0,0,0,0,0,0,1,0,0,0,0,0,0,14,14,
   0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,
   12,12,0,0,0,0,0,12,12,12,0,0,0,0,0,12,12,
   12,12,0,0,0,0,0,12,12,12,0,0,0,0,0,12,12,
   12,12,0,0,0,0,12,12,12,12,12,0,0,0,0,12,12,
   12,12,0,0,0,0,12,12,12,12,12,0,0,0,0,12,12,
   12,12,0,0,0,12,12,12,12,12,12,12,0,0,0,12,12,
   12,12,0,0,12,12,12,12,12,12,12,12,12,0,0,12,12,
   12,12,0,12,12,12,12,12,12,12,12,12,12,12,0,12,12,
   12,12,12,12,12,0,12,12,12,12,12,0,12,12,12,12,12,
   12,12,12,12,0,0,12,12,12,12,12,0,0,12,12,12,12,
   12,12,12,0,0,0,12,12,12,12,12,0,0,0,12,12,12,
   12,12,0,0,0,0,0,0,0,0,0,0,0,0,0,12,12,
   12,12,0,0,0,0,0,14,14,14,0,0,0,0,0,12,12,
   12,12,0,0,0,0,14,0,14,0,14,0,0,0,0,12,12
   };

char save_background[sizeof(sprite_data)];

/**************************** THE PROGRAM **********************************/

#include <stdio.h>
#include <conio.h>
#include <time.h>
#include <dos.h>
#include <mem.h>
#include <string.h>
#include <stdlib.h>

char far *screen=MK_FP(0xA000,0);

void	SetGraphicsMode( void ) {
	asm {
		mov	ax,0x13
    int	0x10
	  }
}

void	SetTextMode( void ) {
	asm {
  	mov	ax,0x03
    int	0x10;
    }
}

void GetPoint( int X, int Y, unsigned char *C ) {
  *C = *(screen+(Y*320)+X);
}

void SetPoint( int X, int Y, unsigned char C ) {
  *(screen+(Y*320)+X)=C;
}

/* For the first time, we are now going tell the draw routine which sprite
we want to draw.  To do this, we simply pass the address of the sprite data */

void draw_sprite( char *sprite, int sx, int sy ) {
   int x, y, c, sw, sh, length;

   /* Retrieve the width and height */
   sw = sprite[0];
   sh = sprite[1];

   save_background[0] = sw;
   save_background[1] = sh;
   c = 2;

   for ( y = 0; y < sh; y++ )
     for ( x = 0; x < sw; x++ ) {
       if (sprite[c]) {
         GetPoint( sx+x, sy+y, &(save_background[c]) );
         SetPoint( sx+x, sy+y, sprite[c] );
         }
       else
         save_background[c]=0;
       c++;
       }
}

/* To erase the sprite, just draw the background.  This is similar to the
sprite drawing routine except we're not saving the background first! */

void erase_sprite( char *save, int sx, int sy ) {
   int x, y, c, sw, sh, length;

   /* Retrieve the width and height */
   sw = save[0];
   sh = save[1];
   c = 2;

   for ( y = 0; y < sh; y++ )
     for ( x = 0; x < sw; x++ ) {
       if (save[c]) SetPoint( sx+x, sy+y, save[c] );
       c++;
       }
}

void main( void ) {
  int sx=10, sy=10, mx=2, my=2;

  SetGraphicsMode();

  /* Set up a colourful background */

  _fmemset(screen,1,12800);
  _fmemset(screen+12800,2,12800);
  _fmemset(screen+25600,3,12800);
  _fmemset(screen+38400,4,12800);
  _fmemset(screen+51200,5,12800);

  /* "Bounce" the sprite around the screen until the user presses a key */

  while (!kbhit()) {
    draw_sprite(sprite_data,sx,sy);
    delay(10);
    erase_sprite(save_background,sx,sy);

    sx += mx;
    sy += my;

    if (sx < 10) {
      sx=10;
      mx=-mx;
      }

    if (sx > 300) {
      sx=300;
      mx=-mx;
      }

    if (sy < 10) {
      sy=10;
      my=-my;
      }

    if (sy > 180) {
      sy=180;
      my=-my;
      }
    }
  getch();

  SetTextMode();
}
