/*

  SPRITED1.C - More sprite drawing

  Written by Phil Inch for Game Developers Magazine (issue 4).
  Contributed to the public domain.

  This program written and compiled with Borland C++ v3.1
  Compatibility with other compilers is not guaranteed.

  Usage of this program is subject to the disclaimer printed
  in the magazine.  You assume all risks associated with the use
  of this program.


  The sprite:

   01234567890123456
   **......*......** 0
   **......*......** 1
   ........*........ 2
   **.....***.....** 3
   **.....***.....** 4
   **....*****....** 5
   **....*****....** 6
   **...*******...** 7
   **..*********..** 8
   **.***********.** 9
   *****.*****.***** 0
   ****..*****..**** 1
   ***...*****...*** 2
   **.............** 3
   **.....***.....** 4
   **....*.*.*....** 5

*/

/****************************** SPRITE DATA ********************************/

char sprite_data[] = {
   17, 16,
   14,14,0,0,0,0,0,0,1,0,0,0,0,0,0,14,14,
   14,14,0,0,0,0,0,0,1,0,0,0,0,0,0,14,14,
   0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,
   12,12,0,0,0,0,0,12,12,12,0,0,0,0,0,12,12,
   12,12,0,0,0,0,0,12,12,12,0,0,0,0,0,12,12,
   12,12,0,0,0,0,12,12,12,12,12,0,0,0,0,12,12,
   12,12,0,0,0,0,12,12,12,12,12,0,0,0,0,12,12,
   12,12,0,0,0,12,12,12,12,12,12,12,0,0,0,12,12,
   12,12,0,0,12,12,12,12,12,12,12,12,12,0,0,12,12,
   12,12,0,12,12,12,12,12,12,12,12,12,12,12,0,12,12,
   12,12,12,12,12,0,12,12,12,12,12,0,12,12,12,12,12,
   12,12,12,12,0,0,12,12,12,12,12,0,0,12,12,12,12,
   12,12,12,0,0,0,12,12,12,12,12,0,0,0,12,12,12,
   12,12,0,0,0,0,0,0,0,0,0,0,0,0,0,12,12,
   12,12,0,0,0,0,0,14,14,14,0,0,0,0,0,12,12,
   12,12,0,0,0,0,14,0,14,0,14,0,0,0,0,12,12
   };

/**************************** THE PROGRAM **********************************/

#include <stdio.h>
#include <conio.h>
#include <time.h>
#include <dos.h>
#include <mem.h>
#include <string.h>
#include <stdlib.h>

char far *screen=MK_FP(0xA000,0);

void	SetGraphicsMode( void ) {
	asm {
		mov	ax,0x13
    int	0x10
	  }
}

void	SetTextMode( void ) {
	asm {
  	mov	ax,0x03
    int	0x10;
    }
}

void SetPoint( int X, int Y, int C ) {
  *(screen+(Y*320)+X)=C;
}

/* Same routine as issue 3 */
void draw_sprite( int sx, int sy ) {
   int x, y, c, sw, sh, length;

   /* Retrieve the width and height */
   sw = sprite_data[0];
   sh = sprite_data[1];
   c = 2;

   for ( y = 0; y < sh; y++ )
       for ( x = 0; x < sw; x++ )
           SetPoint( sx+x, sy+y, (int) sprite_data[c++] );
}

void main( void ) {
  SetGraphicsMode();

  _fmemset(screen,3,64000L);  /* Make the background cyan */

  draw_sprite( 50, 60);
  draw_sprite(150, 60);
  draw_sprite(250, 60);
  draw_sprite( 50,130);
  draw_sprite(150,130);
  draw_sprite(250,130);

  getch();

  SetTextMode();
}
