
/*

	Unsigned class definition   7/16/94 by Brian Lee Price

	This is a flag class.

	Compatible with experimental strong typing option

	Released as Public Domain   July, 1994.

*/

#if sizeof(unsigned short) > sizeof(tag)
#error INVALID TYPE SIZE FOR TAG
#endif

#define CLASS Unsigned

#include "gcoope10.h"

#include <stdio.h>

object CLASS;

extern object String;
extern object Char;
extern object ShortInt;
extern object LongInt;

USEGEN(changeVal);
USEGEN(valueOf);
USEGEN(asString);
USEGEN(asHexStr);
USEGEN(asChar);
USEGEN(asShortInt);
USEGEN(asLongInt);
USEGEN(asUnsigned);

cmethod object m4New(object instance, unsigned short initVal)
{
if(((objHndl *) &instance)->fext)
    {
    unsigned short * ivptr;
    if(NULL==(ivptr=getIVptr(instance))) return 0;
    *ivptr=initVal;
    }
else
    {
    ((objHndl *) &instance)->fext=(tag)instance | ~SIGNMASK;
    (tag) instance=0;
    (unsigned short) instance=initVal;
    }
return instance;
}


imethod object m4changeVal(object instance, unsigned short newVal)
{
if(instance>=0)
    {
    unsigned short * ivptr;
    if(NULL==(ivptr=getIVptr(instance))) return FUNCFAIL;
    *ivptr=newVal;
    }
else (unsigned short) instance=newVal;
return FUNCOKAY;
}


imethod unsigned short m4valueOf(object instance)
{
if(instance>=0)
    {
    unsigned short * ivptr;
    ivptr=getIVptr(instance);
    return *ivptr;
    }
else return (unsigned short) instance;
}


imethod object m4asString(object instance)
{
char strBuf[16];
unsigned short a;

if(instance>=0) a=*((unsigned short *) getIVptr(instance));
else a=(unsigned short) instance;
sprintf(strBuf,"%ud", a);
return g(New)(String,strBuf);
}


imethod object m4asHexStr(object instance)
{
char strBuf[16];
unsigned short a;

if(instance>=0) a=*((unsigned short *) getIVptr(instance));
else a=(unsigned short) instance;
sprintf(strBuf, "%x", a);
return g(New)(String,strBuf);
}


imethod object m4asChar(object instance)
{
unsigned short a;

if(instance>=0) a=*((unsigned short *) getIVptr(instance));
else a=(unsigned short) instance;
return g(New)(Char,(char) a);
}


imethod object m4asLongInt(object instance)
{
unsigned short a;

if(instance>=0) a=*((unsigned short *) getIVptr(instance));
else a=(unsigned short) instance;
return g(New)(LongInt,(long) a);
}


imethod object m4asShortInt(object instance)
{
unsigned short a;

if(instance>=0) a=*((unsigned short *) getIVptr(instance));
else a=(unsigned short) instance;
return g(New)(ShortInt,(short) a);
}





CLASS_INSTALL
{
stat x=FUNCFAIL;

if(END==(CLASS=g(New)(Class, 0, sizeof(unsigned short), END))) goto end;
if(addGMthd(CLASS, New, (method) m4New)) goto end;
if(addGMthd(CLASS, GEN(changeVal), (method) m4changeVal)) goto end;
if(addGMthd(CLASS, GEN(valueOf), (method) m4valueOf)) goto end;
if(addGMthd(CLASS, GEN(asString), (method) m4asString)) goto end;
if(addGMthd(CLASS, GEN(asHexStr), (method) m4asHexStr)) goto end;
if(addGMthd(CLASS, GEN(asChar), (method) m4asChar)) goto end;
if(addGMthd(CLASS, GEN(asLongInt), (method) m4asLongInt)) goto end;
if(addGMthd(CLASS, GEN(asShortInt), (method) m4asShortInt)) goto end;
if(addGMthd(CLASS, GEN(asUnsigned), bounceBack)) goto end;
x=FUNCOKAY;

end:
return x;
}
