
/*

	LongInt class definition   7/13/94 by Brian Lee Price

	Compatible with experimental strong typing option.

	Released as Public Domain   July, 1994.

*/

#define CLASS LongInt

#include "gcoope10.h"

#include <stdio.h>

object CLASS;

extern object String;
extern object Char;
extern object ShortInt;
extern object Unsigned;
extern object Pointer;

USEGEN(changeVal);
USEGEN(valueOf);
USEGEN(asString);
USEGEN(asHexStr);
USEGEN(asChar);
USEGEN(asShortInt);
USEGEN(asUnsigned);
USEGEN(asPointer);
USEGEN(asLongInt);

cmethod object m4New(object instance, long initVal)
{
long * ivptr;

if(NULL==(ivptr=makeInst(&instance))) return 0;
*ivptr=initVal;

return instance;
}


imethod object m4changeVal(object instance, long newVal)
{
long * ivptr;

if(NULL==(ivptr=getIVptr(instance))) return FUNCFAIL;
*ivptr=newVal;

return FUNCOKAY;
}


imethod long m4valueOf(object instance)
{
return *((long *) getIVptr(instance));
}


imethod object m4asString(object instance)
{
char strBuf[16];
long a;

a=*((long *) getIVptr(instance));
sprintf(strBuf,"%ld", a);
return g(New)(String,strBuf);
}


imethod object m4asHexStr(object instance)
{
char strBuf[16];
long a;

a=*((long *) getIVptr(instance));
sprintf(strBuf, "%lx", (unsigned long) a);
return g(New)(String,strBuf);
}


imethod object m4asChar(object instance)
{
long a;

a=*((long *) getIVptr(instance));
return g(New)(Char,(char) a);
}


imethod object m4asShortInt(object instance)
{
long a;

a=*((long *) getIVptr(instance));
return g(New)(ShortInt,(short) a);
}


imethod object m4asUnsigned(object instance)
{
long a;

a=*((long *) getIVptr(instance));
return g(New)(Unsigned,(unsigned short) a);
}


imethod object m4asPointer(object instance)
{
long a;

a=*((long *) getIVptr(instance));
return g(New)(Pointer,(void *) a);
}




CLASS_INSTALL
{
stat x=FUNCFAIL;

if(END==(CLASS=g(New)(Class, 0, sizeof(long), END)))
    goto end;
if(addGMthd(CLASS, New, (method) m4New)) goto end;
if(addGMthd(CLASS, GEN(changeVal), (method) m4changeVal)) goto end;
if(addGMthd(CLASS, GEN(valueOf), (method) m4valueOf)) goto end;
if(addGMthd(CLASS, GEN(asString), (method) m4asString)) goto end;
if(addGMthd(CLASS, GEN(asHexStr), (method) m4asHexStr)) goto end;
if(addGMthd(CLASS, GEN(asChar), (method) m4asChar)) goto end;
if(addGMthd(CLASS, GEN(asShortInt), (method) m4asShortInt)) goto end;
if(addGMthd(CLASS, GEN(asUnsigned), (method) m4asUnsigned)) goto end;
if(addGMthd(CLASS, GEN(asPointer), (method) m4asPointer)) goto end;
if(addGMthd(CLASS, GEN(asLongInt), bounceBack)) goto end;

x=FUNCOKAY;

end:
return x;
}
