/*

	String class definition for GCOOPE 1.0

	Designed 7/21/94 by Brian L. Price

	Compatible with experimental strong typing option.

	Released as Public Domain   July, 1994.

*/


#define CLASS String

#include "gcoope10.h"
#include <string.h>

object CLASS;

extern object Array;
extern object LowStream;
extern object Dynmem;

USEGEN(reSize);
USEGEN(addressOf);
USEGEN(lengthOf);
USEGEN(changeVal);
USEGEN(sizeOf);
USEGEN(asString);

cmethod object m4New(object instance, char * text)
{
char *  ptrA;

if(NULL==makeInst(&instance)) return FUNCFAIL;
g(New)(ST(Array), (word) sizeof(char), (word) strlen(text)+1);
g(New)(ST(LowStream));
ptrA=((VDPTRRV) g)(GEN(addressOf))(instance);
strcpy(ptrA, text);
return instance;
}


imethod object m4changeVal(object instance, char * newText)
{
char * 	ptrA;
int 	length;

g(GEN(reSize))(instance, (word) length=strlen(newText));
ptrA=((VDPTRRV) g)(GEN(addressOf))(instance);
strncpy(ptrA, newText, length);
return FUNCOKAY;
}


CLASS_INSTALL
{
if( END==(CLASS=g(New)(Class, 0, 0, Array, LowStream, END))
    || addGMthd(CLASS, New, (method) m4New)
    || ADDGM(changeVal) || RENGM(sizeOf, Dynmem, lengthOf)
    || addGMthd(CLASS, GEN(asString), bounceBack))
    return FUNCFAIL;
return FUNCOKAY;
}
