/*

	Pointer object class definition for GCOOPE 1.0

	Compatible with experimental strong type checking.

	Released as Public Domain    July, 1994.

*/

#define CLASS Pointer

#include "gcoope10.h"
#include <stdio.h>

object CLASS;

extern object String;
extern object LongInt;

USEGEN(changeVal);
USEGEN(valueOf);
USEGEN(asString);
USEGEN(asLongInt);
USEGEN(asPointer);

cmethod object m4New(object instance, void * initVal)
{
void ** ivptr;

if(NULL==(ivptr=makeInst(&instance))) return 0;
*ivptr=initVal;

return instance;
}


imethod object m4changeVal(object instance, void * newVal)
{
void ** ivptr;

if(NULL==(ivptr=getIVptr(instance))) return FUNCFAIL;
*ivptr=newVal;

return FUNCOKAY;
}


imethod void * m4valueOf(object instance)
{
return *((void **) getIVptr(instance));
}


imethod object m4asString(object instance)
{
char strBuf[16];
void * a;

a=*((void **) getIVptr(instance));
sprintf(strBuf,"%p", a);
return g(New)(String,strBuf);
}

imethod object m4asLongInt(object instance)
{
void * a;

a=*((void **) getIVptr(instance));

return g(New)(LongInt,(long) a);
}



CLASS_INSTALL
{
stat x=FUNCFAIL;

if(END==(CLASS=g(New)(Class, 0, sizeof(void *), END)))
    goto end;
if(addGMthd(CLASS, New, (method) m4New)) goto end;
if(addGMthd(CLASS, GEN(changeVal), (method) m4changeVal)) goto end;
if(addGMthd(CLASS, GEN(valueOf), (method) m4valueOf)) goto end;
if(addGMthd(CLASS, GEN(asString), (method) m4asString)) goto end;
if(addGMthd(CLASS, GEN(asLongInt), (method) m4asLongInt)) goto end;
if(addGMthd(CLASS, GEN(asPointer), bounceBack)) goto end;
x=FUNCOKAY;

end:
return x;
}

