/*

	object list manager for GCOOPE Version 1.0

			by Brian Lee Price

	Released as Public Domain   July, 1994.

	This group of routines track all objects (including classes).
	This is where any object that has instance variables goes to
	access the correct memory area.
	    Be sure and examine gcstruct.h and listmgr.c prior to any
	serious reading of this file.

*/

#define __OBJECTS__

#include "gcstruct.h"


/*
FOR KERNEL USE ONLY!

usage:
   objectEntryStructurePointer=getObject(object_tag_value);

   Okay what is a tag_value?  While the type 'object' is a 32bit value,
   in many cases only 14 bits are actually required.  Given an 'object',
   use the macro OBJFLAG to turn the object var into a pointer to a
   objflag struct and use the tag member to get or set the tag value.
	Most accesses are performed via the use of the tag
   values, but for a number of reasons (no instance memory for
   char, int, and full representation, instance variable access
   speed up techniques, etc.) 'object' must be a 32 bit value.
       This routine returns the pointer to a descriptor entry in the
   object list assigned to the tag value objTag, where objTag is an
   index to an unordered list.  On error a NULL pointer is returned so,
   VALIDATE THOSE RETURN POINTER VALUES!!!
	The objectEntry structure contains the object's process ID
   number, it's last access value (for garbage collection), and
   finally a pointer to the object definition.

*/

objectEntry * getObject(tag objTag)
{
objectEntry * retVal=NULL;

if(objList.listPtr!=NULL && objTag < objList.maxElems && objTag>0)
    {
    retVal=objList.listPtr;
    retVal+=objTag;
    }
return retVal;
}



/*
FOR KERNEL USE ONLY!

usage:
   objectDefinitionPointer=getObjDef(object_tag_value);

	See above comments for getObject, the only difference here is
   that the pointer to the object definition is obtained from the
   objectEntry structure and that is the pointer returned to the caller.
*/

void * getObjDef(tag objTag)
{
objectEntry * objEntry;

if(NULL==(objEntry=getObject(objTag))) return NULL;
objEntry->lastAcc=INIT_AGE;
return objEntry->objDef;
}



/*
FOR KERNEL USE ONLY!

usage:
    newObjectTagValue=addObject(objectDefinitionPointer, processID);
	The value processID is used to enable the garbage collection
    mechanism to be multi-thread aware, it is also used by makePerm
    and in newClass to prevent the garbage collector from killing off
    a non-temporary object.
	The object definition pointer must be a valid pointer to a
    structure of type objDefinition.  The function returns the tag
    value of the new object.
	Note that on an error this function returns the value BAD_OBJ.
*/

int addObject(void * objDef, byte procID)
{
int 		x;
objectEntry * 	newObj;

if(objDef==NULL || (x=addItem(&objList, sizeof(objectEntry)))<0)
    return BAD_OBJ;
newObj=objList.listPtr;
newObj+=x;
newObj->objDef=objDef;
newObj->procID=procID;
newObj->lastAcc=INIT_AGE;
return x;
}


/*
FOR KERNEL USE ONLY!

usage:
    functionStatus=rmvObject(object_tag_value);
	This function removes an object Entry from the objList after
    freeing the object definition memory area (if not already freed).
    It returns the FUNCOKAY/FUNCFAIL value.
*/


int rmvObject(tag objTag)
{
short 		retVal=FUNCFAIL;
objectEntry * 	oldObj;

if(NULL==(oldObj=getObject(objTag))) goto end;
if(oldObj->objDef!=NULL) s_free(oldObj->objDef);
if(rmvItem(&objList, objTag)<0) goto end;
retVal=FUNCOKAY;
end:
return retVal;
}



