/*

	Dynmem class definition for GCOOPE10 ported from PCOOPE21

	  released as PUBLIC DOMAIN 4/25/94 modified 7/14/94

	  Compatible with experimental strong type checking.

      This definition uses the assistance macros from gcoope10.h.

*/

#define CLASS Dynmem

#include "gcoope10.h"

object CLASS;

extern object Pointer;
extern object Unsigned;

USEGEN(reSize);
USEGEN(sizeOf);
USEGEN(valueOf);
USEGEN(changeVal);
USEGEN(addressOf);


cmethod object m4New(object instance, unsigned short initSize)
{
void *	   memArea;

if(NULL==makeInst(&instance)) return 0;
memArea=s_malloc(initSize);
g(New)(ST(Unsigned), initSize);
g(New)(ST(Pointer),memArea);
return instance;
}


imethod object m4reSize(object instance, unsigned short newSize)
{
void * memArea;

if(g(GEN(changeVal))(ST(Unsigned), newSize)) return FUNCFAIL;
memArea=((VDPTRRV)g)(GEN(addressOf))(instance);
memArea=s_realloc(memArea, newSize);
return g(GEN(changeVal))(ST(Pointer), memArea);
}


cmethod object m4Kill(object instance)
{
void * memArea;

memArea=((VDPTRRV)g)(GEN(addressOf))(instance);
s_free(memArea);
g(Kill)(ST(Unsigned));
g(Kill)(ST(Pointer));
g(Kill)(Object, instance);
return instance;
}



CLASS_INSTALL
{
if(END==(CLASS=g(New)(Class, 0, 0, Pointer, Unsigned, END))) goto err;
if(addGMthd(CLASS, New, (method) m4New)) goto err;
if(addGMthd(CLASS, Kill, (method) m4Kill)) goto err;
if(RMVGM(changeVal)) goto err;
if(RMVGM(valueOf)) goto err;
if(ADDGM(reSize)) goto err;
if(RENGM(valueOf, Unsigned, sizeOf)) goto err;
if(RENGM(valueOf, Pointer, addressOf)) goto err;
return FUNCOKAY;

err:
return FUNCFAIL;
}



