/*

    gconio.hpp
    3-30-91
    graphics console class for Borland C++

    Copyright 1991
    John W. Small
    All rights reserved
    Use freely but acknowledge authorship and copyright.
    CIS: 73757,2233

    PSW / Power SoftWare
    P.O. Box 10072
    McLean, Virginia 22102 8072
    (703) 759-3838

*/


#ifndef GCONIO_CPP
#define GCONIO_CPP

#include <conio.h>
#include <graphics.h>

// 4 <= GC_BUF_SIZE <= 129
#define GC_BUF_SIZE    129

class GraphicsConsole  {
public:
    int ColumnLeft;		// CR to current column
    int InputWriteMode;		// cgets(), etc. write mode
    int InputRewrite;           // Upon CR rewrite COPY_PUT
    int InputDone;              // cgets(), etc. break
    int OutputWriteMode;        // cputs(), etc. write mode
    int ClearTextBk;            // clr bgrd before writing
    int TextBkPattern;          // for COPY_PUT
    int TextBkColor;            // 0 for current color
    char CursorChar[2];
    unsigned CursorOnMsec;
    unsigned CursorOffMsec;

    GraphicsConsole();

    void ProportionalBackSpace(int& lastchX,
	int& lastchY, int chX, int chY,
	char lastch, char ch,
	struct textsettingstype& TS);
    void ProportionalSpace(int chX, int chY,
	int& nextchX, int& nextchY, char ch,
	char nextch, struct textsettingstype& TS);
    void TextBox(int x, int y, char *s,
	struct textsettingstype& TS,
	int& x1, int& y1, int& x2, int& y2);

    int cprintf(const char *format,...);
    int cputs(const char *str);
    int putch(int c);
    void rubout(int ch);
    int cscanf(const char *format,...);
    char * cgets(char *str);
    int getch()  { return ::getch(); }
    int getche()  { return putch(getch()); }
    int ungetch(int ch)  { return ::ungetch(ch);  }

    ~GraphicsConsole() {}
};

#endif
