// ---------------------------------------------------------------------------
// Module:		FU_UTIL.C
//
// Description: FreeUp utility functions
//
// Last modified: 06/27/94
//
// (C) Copyright 1994 Thomas R. Grubbe, All Rights Reserved
// ---------------------------------------------------------------------------

#include <windowsx.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <dos.h>
#include <dir.h>
#include "freeup.h"
#include "fu_util.h"
#include "fu_tbar.h"

LPSTR ul2str(unsigned long num);
void LoadWaitCursor(void);
void LoadArrowCursor(void);
UINT FreeUpMsgBox(UINT Style, char *Title, char *szFormat, ...);
int LogPath(char *PathName);
void PathCh(char *str, int len, char ch1, char ch2);
void StatusRect(HDC hdc, int x, int y, int cx, int cy,
				int Width, UINT Flags);
unsigned long GetFreeDiskSpace(int Disk);
void MakeDateStr(unsigned int Date, char *Str);
void MakeTimeStr(unsigned int Time, char *Str);
void MakeAttrStr(int Attr, char *Str);
void FlushMsgLoop(void);
void CenterDialog(HWND hDlg);
void UpdateStatusBars(void);
int GetDirIndex(void);
int GetTaggedFileCount(void);
int GetTotalFilesCount(void);

LPSTR ul2str(unsigned long num)
{
	register char str[32];
	register char temp[32];
	register int i = 0, j = 0, k = 0, len;

	temp[0] = '\0';
	str[0] = '\0';

	ltoa(num, str, 10);

	if (strlen(str) < 1)	{
		return (NULL);
	}
	if (strlen(str) < 4)	{
		return (str);
	}

	len = strlen(str);
	strrev(str);

	while (j < len)	{
		if (i == 3)	{
			temp[k+1] = '\0';
			temp[k++] = ',';
			i = 0;
		}
		i++;
		temp[k+1] = '\0';
		temp[k++] = str[j++];
	}
	strrev(temp);
	return(temp);
}

void LoadWaitCursor(void)
{
	HCURSOR hCursor;

	hCursor = LoadCursor(NULL, IDC_WAIT);
	SetCursor(hCursor);
}
void LoadArrowCursor(void)
{
	HCURSOR hCursor;

	hCursor = LoadCursor(NULL, IDC_ARROW);
	SetCursor(hCursor);
}



UINT FreeUpMsgBox(UINT Style, char *Title, char *szFormat, ...)
{
	UINT Ret;
	char szBuffer[256];
	char *pArgs;

	pArgs = (char *)&szFormat + sizeof szFormat;
	vsprintf(szBuffer, szFormat, pArgs);
	Ret = MessageBox(NULL, (LPSTR)szBuffer, (LPSTR)Title, Style);

	return (Ret);
}

int LogPath(char *PathName)
{
	int DriveNum;

	if (islower(PathName[0]))
		NumDrives = setdisk(PathName[0] - 'a');
	else
		NumDrives = setdisk(PathName[0] - 'A');

	return(chdir(PathName));		// -1 on error
}

void PathCh(char *str, int len, char ch1, char ch2)
{
	register int i;

	for (i=0; i<=len; i++)	{
		if (str[i] == ch1)
			str[i] = ch2;
	}
}

void StatusRect(HDC hdc, int x, int y, int cx, int cy,
				int Width, UINT Flags)
{
	HPEN hpen, hpenOld;

    if (Flags == SR_GROUP)	{
		hpen = CreatePen(PS_SOLID, 0, RGB(128, 128, 128));
		hpenOld = SelectObject(hdc, hpen);
	}
	else if (Flags == SR_BORDER)
		Rectangle(hdc, x, y, cx, cy);
	else if (Flags == SR_RAISED)	{
		hpenOld = SelectObject(hdc, GetStockObject(WHITE_PEN));
    }

	MoveTo(hdc, x+Width, cy-Width);
	LineTo(hdc, x+Width, y+Width);
	LineTo(hdc, cx-Width, y+Width);

	SelectObject(hdc, hpenOld);

	if (hpen)
		DeleteObject(hpen);

    if (Flags == SR_GROUP)	{
		hpenOld = SelectObject(hdc, GetStockObject(WHITE_PEN));
	}
	else if (Flags == SR_RAISED)	{
		hpen = CreatePen(PS_SOLID, 0, RGB(128, 128, 128));
		hpenOld = SelectObject(hdc, hpen);
    }
	LineTo(hdc, cx-Width, cy-Width);
	LineTo(hdc, x+Width, cy-Width);

	SelectObject(hdc, hpenOld);

    if (hpen)
		DeleteObject(hpen);
}

// int Disk: 0=A, 1=B, 2=C, and so on...
unsigned long GetFreeDiskSpace(int Disk)
{
	unsigned long FreeDiskSpace, percl;
	struct dfree d;

	getdfree(Disk+1, &d);
	percl = d.df_sclus * d.df_bsec;
	FreeDiskSpace = d.df_avail * percl;

	return (FreeDiskSpace);
}

void MakeDateStr(unsigned int Date, char *Str)
{
	unsigned int Temp;
    int day, month, year;

	Temp = Date;

	day = Temp % 32;
	Temp = Temp / 32;
	month = Temp % 16;
	year = Temp / 16 + 80;

	wsprintf(Str, "%d/%02d/%02d", month, day, year);
}
void MakeTimeStr(unsigned int Time, char *Str)
{
	int Temp, Hour, Min;
    BOOL Am = FALSE;

	Temp = Time / 32;
	Min  = Temp % 64;
	Hour = Temp / 64;

	if (Hour >= 12)	{
		if (Hour > 12) Hour -= 12;
		Am = FALSE;
	}
	else	{
		if (Hour == 0) Hour = 12;
		Am = TRUE;
	}

	wsprintf(Str, "%2d:%02d%s", Hour, Min, (Am) ? "am" : "pm");
}
void MakeAttrStr(int Attr, char *Str)
{

    wsprintf(Str, "%c%c%c%c",
			(Attr & _A_RDONLY) ? 'r' : '.',
			(Attr & _A_ARCH)   ? 'a' : '.',
			(Attr & _A_SYSTEM) ? 's' : '.',
			(Attr & _A_HIDDEN) ? 'h' : '.');
}

void FlushMsgLoop(void)
{
	MSG msg;

	while (PeekMessage(&msg, NULL, 0, 0, PM_REMOVE))	{
		TranslateMessage(&msg);
		DispatchMessage(&msg);
	}
}

void CenterDialog(HWND hDlg)
{
	int cxWin,
		cyWin, 
		xDlg,           // New X coordinate for dialog box
		yDlg,           // New Y coordinate for dialog box
		cxDlg,          // Delta X for dialog box
		cyDlg,          // Delta Y for dialog box
		cxScreen,       // Delta X for screen
		cyScreen;       // Delta Y for screen
	RECT rcDlg,         // Rectangle for dialog box
		 rcPrnt;        // Rectangle for parent window
	HWND hWndParent;    // Handle the parent window

	// Determine the width and height of the screen.
	cxScreen = GetSystemMetrics(SM_CXSCREEN);
	cyScreen = GetSystemMetrics(SM_CYSCREEN);

	// Determine rectangle for parent window of dialog box.
	hWndParent = GetWindowWord(hDlg, GWW_HWNDPARENT);
	if(IsWindow(hWndParent))
	{
		// Use parent coordinates (rect) to determine where the
		// dialog needs to be on the Windows desktop
		GetWindowRect(hWndParent, &rcPrnt);
		cxWin = rcPrnt.right - rcPrnt.left;
		cyWin = rcPrnt.bottom - rcPrnt.top;
	}
	else
	{
		// We were unable to determine who the parent is,
		// therefore centering the dialog is pointless!  Place
		// it in the upper left corner of the Windows desktop.
		cxWin = 0;     // Force the centering calculation to
		cyWin = 0;     // think that the dialog is centered on
                       // the Windows desktop
	}

	// Determine rectangle for dialog box itself.
	GetWindowRect(hDlg, &rcDlg);
	cxDlg = rcDlg.right - rcDlg.left;
	cyDlg = rcDlg.bottom - rcDlg.top;

	// Determine new dialog X and Y coordinate
	xDlg = (cxWin - cxDlg) / 2;
	xDlg += rcPrnt.left;
	yDlg = (cyWin - cyDlg) / 2;
	yDlg += rcPrnt.top;

	// Center the dialog using new coordinates
	if ((xDlg < 0) || (yDlg < 0) || (xDlg+cxDlg > cxScreen) ||
            (yDlg+cyDlg > cyScreen))
	{
		// If by centering the dialog on top of its parent it
		// would not be 100% visible, then center it on the
		// Windows desktop instead.
		xDlg = (cxScreen - cxDlg) / 2;
		yDlg = (cyScreen - cyDlg) / 2;
	}

	// Move the dialog box to its new home on the desktop
	MoveWindow(hDlg, xDlg, yDlg, cxDlg, cyDlg, TRUE);
}

void UpdateStatusBars(void)
{
	DrawFreeSpace();
	DrawCurrentDir();
	DrawDirTotals();
	DrawFileTotals();
}


int GetDirIndex(void)
{
	return (SendMessage(ghwndDirBox, LB_GETCURSEL, 0, 0L));
}
int GetTaggedFileCount(void)
{
	return (SendMessage(ghwndFileBox, LB_GETSELCOUNT, 0, 0L));
}
int GetTotalFilesCount(void)
{
	return (SendMessage(ghwndFileBox, LB_GETCOUNT, 0, 0L));
}