// FU_FILE.H - Files Drawing and handing stuctures and prototypes

typedef struct tagFILESDRAWSTRUCT {
	HDC		hDC;
	HBITMAP	hFileIcons;
	HBITMAP	hIconMem;
	int		nBitmapHeight;
	int		nBitmapWidth;
	int		nTextHeight;
	BOOL	ShowIcons;
}FILESDRAWSTRUCT;

typedef FILESDRAWSTRUCT FAR* LPFILESDRAWSTRUCT;

extern int FileCount;
extern unsigned long DirSize;

extern BOOL FileDraw_DrawInit(HINSTANCE hInstance,
							  int IconID,
							  int Rows,
							  int Columns,
							  BOOL ShowIcons,
							  LPFILESDRAWSTRUCT lpFilesDrawStruct);
extern void FileDraw_OnMeasureItem(HWND hwnd,
								   MEASUREITEMSTRUCT FAR* lpMeasureItem,
								   LPFILESDRAWSTRUCT lpFilesDrawStruct);
extern void FileDraw_DrawTerm(LPFILESDRAWSTRUCT lpFilesDrawStruct);
extern void SetFileBoxTextHeight(HWND hwnd, HFONT hFont,
						  LPFILESDRAWSTRUCT lpFilesDrawStruct);
extern void FileDraw_OnDrawItem(HWND hwnd,
						 const DRAWITEMSTRUCT FAR* lpDrawItem,
						 int Row, int Col,
						 int nIndex,
						 LPFILESDRAWSTRUCT lpFilesDrawStruct);
extern void FileOnDrawItem(HWND hwnd, DRAWITEMSTRUCT FAR* lpDrawItem,
					LPFILESDRAWSTRUCT lpFilesDrawStruct);
extern BOOL FileOnCommand(HWND hwnd, UINT id, HWND hwndCtl, UINT code);
extern void FileActionItem(HWND hwnd, DWORD dwData, WORD wItemNum);
extern void FileSystemChangeColor(void);
extern int GetFiles(char *Path, char *Mask);
extern int GetFileType(char *Ext);
extern void SortFiles(void);
extern void InvertTagged(void);
