// fu_draw.h

#define XBMPOFFSET  2

typedef struct tagTreeDrawStruct {
    HDC       hdcMem;
    HBITMAP   hbmIcons;
    HBITMAP   hbmMem;
    int       nBitmapHeight;
    int       nBitmapWidth;
    int       nTextHeight;
    int       nLineHeight;
    BOOL      bLines;
    int       NumOpened;
    DWORD FAR *Opened;

} TREEDRAWSTRUCT;

typedef TREEDRAWSTRUCT FAR *  LPTREEDRAWSTRUCT ;


//
// Interface functions
//
VOID TreeDraw_DrawTerm(LPTREEDRAWSTRUCT lpTreeDrawStruct);

VOID TreeDraw_DrawSetTextHeight (HWND hwnd, HFONT hFont, LPTREEDRAWSTRUCT lpTreeDrawStruct );

BOOL TreeDraw_DrawInit(HINSTANCE hInstance,
                       int  nBitmap,
                       int  nRows,
                       int  nColumns,
                       BOOL bLines,
					   LPTREEDRAWSTRUCT lpTreeDrawStruct,
                       BOOL bInit);


VOID TreeDraw_OnDrawItem(HWND  hwnd,
                         const DRAWITEMSTRUCT FAR* lpDrawItem,
                         int   nLevel,
                         DWORD dwConnectLevel,
						 LPSTR szText,
                         int   nRow,
                         int   nColumn,
						 LPTREEDRAWSTRUCT lpTreeDrawStruct,
						 LPSTR szRJust);


VOID TreeDraw_OnMeasureItem(HWND hwnd, MEASUREITEMSTRUCT FAR* lpMeasureItem,
							LPTREEDRAWSTRUCT lpTreeDrawStruct);

BOOL TreeDraw_IsOpened(LPTREEDRAWSTRUCT lpTreeDrawStruct, DWORD dwData);

VOID TreeDraw_OpenItem(LPTREEDRAWSTRUCT lpTreeDrawStruct, DWORD dwData);

VOID TreeDraw_CloseItem(LPTREEDRAWSTRUCT lpTreeDrawStruct, DWORD dwData);

VOID TreeDraw_DrawCloseAll(LPTREEDRAWSTRUCT lpTreeDrawStruct);

VOID TreeDraw_ShowKids(LPTREEDRAWSTRUCT lpTreeDrawStruct,
                       HWND hwndList, WORD wCurrentSelection, WORD wKids);

//
// Support functions
//
static VOID  near FastRect(HDC hDC, int x, int y, int cx, int cy);
static DWORD near RGB2BGR(DWORD rgb);
