// ---------------------------------------------------------------------------
// Module:		FU_SETUP.C
//
// Description:	FreeUp's Setup/Options routine & dialog procedures
//
// Last modified: 06/27/94
//
// (C) Copyright 1994 Thomas R. Grubbe, All Rights Reserved
// ---------------------------------------------------------------------------

#include <windows.h>
#include <windowsx.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <dos.h>
#include <dir.h>
#include <ctl3d.h>
#include "freeup.h"
#include "fu_setup.h"
#include "fu_cmd.h"
#include "fu_util.h"


int SetUpFreeUp(void);
BOOL CALLBACK _export OptionsDlgProc (HWND, UINT, WPARAM, LPARAM);
BOOL CALLBACK _export DetailsDlgProc (HWND, UINT, WPARAM, LPARAM);
BOOL CALLBACK _export DirectoriesDlgProc (HWND, UINT, WPARAM, LPARAM);



int SetUpFreeUp(void)
{
	FARPROC DlgProc;
    HANDLE hLibrary;
	int nRet;
	char CurDir[128];

	InitFreeUp();
	getcwd(CurDir, 128);
	LogPath(StartUpDir);

	DlgProc = MakeProcInstance((FARPROC)OptionsDlgProc, ghInstance);
	nRet = DialogBox(ghInstance, "OptionsDlg", ghwndMain, (DLGPROC)DlgProc);
	FreeProcInstance(DlgProc);

	LogPath(CurDir);
	return nRet;
}


#pragma argsused
BOOL CALLBACK _export OptionsDlgProc (HWND hDlg, UINT msg,
											WPARAM wParam, LPARAM lParam)
{
	HFONT hFont;
    LOGFONT lFont;

	switch (msg)
	{
		case WM_INITDIALOG:
		{
			hFont = (HFONT)NULL;
			if ((hFont = (HFONT)SendMessage(hDlg, WM_GETFONT, 0, 0L)) != 0)
            {
				if (GetObject(hFont, sizeof(LOGFONT), (LPSTR)&lFont))
                {
					lFont.lfWeight = FW_NORMAL;
					if ((hFont = CreateFontIndirect((LPLOGFONT)&lFont)) != 0)	{
						SendMessage(GetDlgItem(hDlg, IDC_FILEDELPRMPT), WM_SETFONT, (WPARAM)hFont, FALSE);
						SendMessage(GetDlgItem(hDlg, IDC_DIRDELPRMPT), WM_SETFONT, (WPARAM)hFont, FALSE);
						SendMessage(GetDlgItem(hDlg, IDC_OVRWRITEPRMPT), WM_SETFONT, (WPARAM)hFont, FALSE);
						SendMessage(GetDlgItem(hDlg, IDC_SAVEWNDWPOS), WM_SETFONT, (WPARAM)hFont, FALSE);
						SendMessage(GetDlgItem(hDlg, IDC_LOWERCASES), WM_SETFONT, (WPARAM)hFont, FALSE);
						SendMessage(GetDlgItem(hDlg, IDC_SHOWTBAR), WM_SETFONT, (WPARAM)hFont, FALSE);
						SendMessage(GetDlgItem(hDlg, IDC_SHOWSBAR), WM_SETFONT, (WPARAM)hFont, FALSE);
						SendMessage(GetDlgItem(hDlg, IDC_DIRSIZEINFO), WM_SETFONT, (WPARAM)hFont, FALSE);
						SendMessage(GetDlgItem(hDlg, IDC_CUSTNAMES), WM_SETFONT, (WPARAM)hFont, FALSE);
						SendMessage(GetDlgItem(hDlg, IDC_FOLDERICONS), WM_SETFONT, (WPARAM)hFont, FALSE);
						SendMessage(GetDlgItem(hDlg, IDC_FILEICONS), WM_SETFONT, (WPARAM)hFont, FALSE);
						SendMessage(GetDlgItem(hDlg, IDC_FILENAMESONLY), WM_SETFONT, (WPARAM)hFont, FALSE);
						SendMessage(GetDlgItem(hDlg, IDC_PARTIALDETAILS), WM_SETFONT, (WPARAM)hFont, FALSE);
						SendMessage(GetDlgItem(hDlg, IDC_SHOWALLDETAILS), WM_SETFONT, (WPARAM)hFont, FALSE);
                    }
				}
			}

			if (LowerCase)
				CheckDlgButton(hDlg, IDC_LOWERCASES, IsDlgButtonChecked(hDlg, IDC_LOWERCASES) ? 0 : 1);
			if (DirSizeInfo)
				CheckDlgButton(hDlg, IDC_DIRSIZEINFO, IsDlgButtonChecked(hDlg, IDC_DIRSIZEINFO) ? 0 : 1);
			if (UseCustomPathNames)
				CheckDlgButton(hDlg, IDC_CUSTNAMES, IsDlgButtonChecked(hDlg, IDC_CUSTNAMES) ? 0 : 1);
			// ...
			return TRUE;
		}

		case WM_CTLCOLOR:
		{
			return (BOOL)Ctl3dCtlColorEx(msg, wParam, lParam);
		}

		case WM_COMMAND:
            switch (wParam)
			{
				case IDC_FILEDELPRMPT:
				case IDC_DIRDELPRMPT:
				case IDC_OVRWRITEPRMPT:
				case IDC_SAVEWNDWPOS:
				case IDC_LOWERCASES:
				case IDC_SHOWTBAR:
				case IDC_SHOWSBAR:
				case IDC_DIRSIZEINFO:
				case IDC_CUSTNAMES:
				case IDC_FOLDERICONS:
				case IDC_FILEICONS:
					CheckDlgButton(hDlg, wParam,
						IsDlgButtonChecked(hDlg, wParam) ? 0 : 1);
					return TRUE;
				case IDOK:
					LowerCase = IsDlgButtonChecked(hDlg, IDC_LOWERCASES) ? 1 : 0;
					DirSizeInfo = IsDlgButtonChecked(hDlg, IDC_DIRSIZEINFO) ? 1 : 0;
                    UseCustomPathNames = IsDlgButtonChecked(hDlg, IDC_CUSTNAMES) ? 1 : 0;
                    // ...
					DeInitFreeUp();
                    DeleteObject(hFont);
					EndDialog(hDlg, IDOK);
                    return TRUE;
				case IDCANCEL:
					SendMessage(hDlg, WM_CLOSE, wParam, 0L);
					return TRUE;
				case IDC_DETAILSBTN:
				{
					FARPROC DetailsProc = MakeProcInstance((FARPROC)DetailsDlgProc, ghInstance);
					DialogBox(ghInstance, "DetailsDlg", hDlg, (DLGPROC)DetailsProc);
					FreeProcInstance(DetailsProc);
					return TRUE;
                }
				case IDC_DIRECTORIESBTN:
                {
					FARPROC DirProc = MakeProcInstance((FARPROC)DirectoriesDlgProc, ghInstance);
					DialogBox(ghInstance, "DirectoriesDlg", hDlg, (DLGPROC)DirProc);
					FreeProcInstance(DirProc);
					return TRUE;
                }
            }
            break ;
		case WM_CLOSE:
			DeleteObject(hFont);
        	EndDialog(hDlg, IDCANCEL);
			return TRUE;
	}
	return FALSE;
}

#pragma argsused
BOOL CALLBACK _export DetailsDlgProc (HWND hDlg, UINT msg,
									  WPARAM wParam, LPARAM lParam)
{
	HFONT hFont;
    LOGFONT lFont;

	switch (msg)
	{
		case WM_INITDIALOG:
		{
			hFont = (HFONT)NULL;
			if ((hFont = (HFONT)SendMessage(hDlg, WM_GETFONT, 0, 0L)) != 0)
            {
				if (GetObject(hFont, sizeof(LOGFONT), (LPSTR)&lFont))
                {
					lFont.lfWeight = FW_NORMAL;
					if ((hFont = CreateFontIndirect((LPLOGFONT)&lFont)) != 0)	{
						SendMessage(GetDlgItem(hDlg, IDC_SIZEBTN), WM_SETFONT, (WPARAM)hFont, FALSE);
						SendMessage(GetDlgItem(hDlg, IDC_DATEBTN), WM_SETFONT, (WPARAM)hFont, FALSE);
						SendMessage(GetDlgItem(hDlg, IDC_TIMEBTN), WM_SETFONT, (WPARAM)hFont, FALSE);
						SendMessage(GetDlgItem(hDlg, IDC_ATTRBTN), WM_SETFONT, (WPARAM)hFont, FALSE);
                    }
				}
			}
			return TRUE;
		}

		case WM_CTLCOLOR:
		{
			return (BOOL)Ctl3dCtlColorEx(msg, wParam, lParam);
		}

		case WM_COMMAND:
            switch (wParam)
			{
				case IDOK:
                	DeleteObject(hFont);
					EndDialog(hDlg, IDOK);
                    return TRUE;
				case IDCANCEL:
					SendMessage(hDlg, WM_CLOSE, wParam, 0L);
					return TRUE;
            }
            break ;
		case WM_CLOSE:
        	DeleteObject(hFont);
        	EndDialog(hDlg, IDCANCEL);
			return TRUE;
	}
	return FALSE;
}
#pragma argsused
BOOL CALLBACK _export DirectoriesDlgProc (HWND hDlg, UINT msg,
										  WPARAM wParam, LPARAM lParam)
{
	HFONT hFont;
	LOGFONT lFont;

	switch (msg)
	{
		case WM_INITDIALOG:
		{
			hFont = (HFONT)NULL;
			if ((hFont = (HFONT)SendMessage(hDlg, WM_GETFONT, 0, 0L)) != 0)
            {
				if (GetObject(hFont, sizeof(LOGFONT), (LPSTR)&lFont))
                {
					lFont.lfWeight = FW_NORMAL;
					if ((hFont = CreateFontIndirect((LPLOGFONT)&lFont)) != 0)	{
						SendMessage(GetDlgItem(hDlg, IDC_STARTUPPRMPT), WM_SETFONT, (WPARAM)hFont, FALSE);
						SendMessage(GetDlgItem(hDlg, IDC_EDITORPRMPT), WM_SETFONT, (WPARAM)hFont, FALSE);
						SendMessage(GetDlgItem(hDlg, IDC_VIEWERPRMPT1), WM_SETFONT, (WPARAM)hFont, FALSE);
						SendMessage(GetDlgItem(hDlg, IDC_VIEWERPRMPT2), WM_SETFONT, (WPARAM)hFont, FALSE);
                    }
				}
			}

			SetWindowText(GetDlgItem(hDlg, IDC_STARTUPEDIT), (LPCSTR)StartUpDir);
			SetWindowText(GetDlgItem(hDlg, IDC_EDITOREDIT),  (LPCSTR)DefaultEditor);
			SetWindowText(GetDlgItem(hDlg, IDC_VIEWEREDIT),  (LPCSTR)DefaultViewer);
			return TRUE;
		}

		case WM_CTLCOLOR:
		{
			return (BOOL)Ctl3dCtlColorEx(msg, wParam, lParam);
		}

		case WM_COMMAND:
            switch (wParam)
			{
				case IDOK:
					GetWindowText(GetDlgItem(hDlg, IDC_STARTUPEDIT), StartUpDir, sizeof(StartUpDir));
					GetWindowText(GetDlgItem(hDlg, IDC_EDITOREDIT), DefaultEditor, sizeof(DefaultEditor));
					GetWindowText(GetDlgItem(hDlg, IDC_VIEWEREDIT), DefaultViewer, sizeof(DefaultViewer));
                	DeleteObject(hFont);
					EndDialog(hDlg, IDOK);
                    return TRUE;
				case IDCANCEL:
					SendMessage(hDlg, WM_CLOSE, wParam, 0L);
					return TRUE;
            }
            break ;
		case WM_CLOSE:
			DeleteObject(hFont);
        	EndDialog(hDlg, IDCANCEL);
			return TRUE;
	}
	return FALSE;
}
