// FREEUP.H

typedef struct tagTreeStruct {
	char Name[14];
	char Path[128];
    char CustomName[80];
	unsigned long DirSize;
	int Parent;
    int SubCnt;
	int Level;
	BOOL LastChild;
	BOOL IsParent;
	int ChildNum;
}TreeStruct;


typedef struct tagFileInfoStruct	{
	char FileName[14];
	char Name[9];
    char Ext[5];
	unsigned Date;
    unsigned Time;
	unsigned long Size;
	char Attrib;
	int FileType;
	BOOL Tagged;
}FileInfoStruct;


#define MAXPATHS	512		// must be a power of 2 (2, 4, 8, 16...)
#define MAXALLOC	MAXPATHS * sizeof(TreeStruct)
#define MAXFILES	1024

#define ASCENDING	 1
#define DECENDING	-1

#define IDERR		-1

extern TreeStruct _huge Tree[MAXPATHS];
extern FileInfoStruct _huge Files[MAXFILES];

extern HWND ghwndMain, ghwndDirBox, ghwndFileBox;
extern HWND ghwndSeparator, ghwndStatusBar, ghwndToolBar;
extern HINSTANCE ghInstance;
extern int Count;
extern char szAppName[];
extern int SortOrder;
extern int SortBy;
extern BOOL TreeModified;
extern LOGFONT logFont;
extern char szFontStyle[LF_FACESIZE];

extern int GetFiles(char *Path, char *Mask);
extern void AddListBoxItems(BOOL TopIdx);
extern void InitFreeUp(void);
extern void DeInitFreeUp(void);
extern void SortDir(TreeStruct _huge *TPtr, int Cnt);
extern void DrawDirTotals(void);
extern void DrawFileTotals(void);

extern RECT DirTotalsRect, FileTotalsRect;
extern RECT FreeSpaceRect, CurrentDirRect;
extern int TotalFiles;
extern int TotalTaggedFiles;
extern unsigned long TotalTaggedBytes;
extern char GlobalSearchText[80];

// FREEUP.INI profile vars
extern char StartUpDir[128];
extern char DefaultEditor[128];
extern char DefaultViewer[128];
extern int SortOrder;
extern int SortBy;
extern int Center;
extern BOOL LowerCase;
extern BOOL DirSizeInfo;
extern BOOL UseCustomPathNames;
extern int NumDrives;
extern int StatBarHeight;
extern int CurrentDrive;
extern RECT WindowRect;
extern RECT DefRect;
extern int WindowState;

#define IDC_FREEUPICON		22
#define ID_SCAN				16
#define IDC_DIRBOX			100
#define IDC_FILEBOX			200
#define IDC_FOLDERS			999
#define IDC_RESIZE			888
#define IDC_SEPARATOR		777
#define IDC_STATUSBAR		555
#define IDC_TOOLBAR			444
#define IDC_BUTTONS			665
#define IDC_DRIVES			667
#define IDC_LOWERCASE		1095
#define IDM_CNTSRCLINES		1032

#define IDB_REGISTER		500
#define IDB_REGISTERNOT		501

// Menu item definitions
// File Menu
#define IDM_VIEW			300
#define IDM_EDIT			302
#define IDM_COPY			303
#define IDM_MOVE			304
#define IDM_DELETE			305
#define IDM_RENAME			306
#define IDM_ZIPFILES		307
#define IDM_FIND			308
#define IDM_FINDNEXT		309
#define IDM_ATTRIBUTES		310
#define IDM_ASSOCIATE		311
#define IDM_EXIT			312
// Sort Menu Items
#define IDM_BYNAME			313
#define IDM_BYEXTENSION		314
#define IDM_BYSIZE			315
#define IDM_BYDATE			316
#define IDM_ASCENDING		317
#define IDM_DECENDING		318
// Tag Menu Items
#define IDM_TAGALL			319
#define IDM_UNTAGALL		320
#define IDM_INVERTTAGS		321

// Tree Menu
#define IDM_READDIRS		322
#define IDM_MKDIR			323
#define IDM_CUSTOMNAME		324
#define IDM_DRIVE_A			0
#define IDM_DRIVE_B			1
#define IDM_DRIVE_C			2
#define IDM_DRIVE_D			3
#define IDM_DRIVE_E			4
#define IDM_DRIVE_F			5
#define IDM_DRIVE_G			6
#define IDM_DRIVE_H			7
#define IDM_DRIVE_I			8
#define IDM_DRIVE_J			9
#define IDM_DRIVE_K			10
#define IDM_DRIVE_L			11
#define IDM_DRIVE_M			12
#define IDM_DRIVE_N			13
#define IDM_DRIVE_O			14
#define IDM_DRIVE_P			15
#define IDM_DRIVE_Q			16
#define IDM_DRIVE_R			17
#define IDM_DRIVE_S			18
#define IDM_DRIVE_T			19
#define IDM_DRIVE_U			20
#define IDM_DRIVE_V			21
#define IDM_DRIVE_W			22
#define IDM_DRIVE_X			23
#define IDM_DRIVE_Y			24
#define IDM_DRIVE_Z			25


#define SORTNAME			IDM_BYNAME
#define SORTEXT				IDM_BYEXTENSION
#define SORTSIZE			IDM_BYSIZE
#define SORTDATE			IDM_BYDATE

// Options menu id's
#define IDM_CHOOSEFONTS		350
#define IDM_DEFOPTS			352
#define IDM_LOADOPTS		353
#define IDM_SAVEOPTS		354

// ScanTree Dlg static ID's
#define IDC_TOTALFILES		150
#define IDC_TOTALDIRS		151
#define IDC_CURRENTDIR		152

// Help menu id's
#define IDM_ABOUT			450

