//**************************************************************************
//
// Date:      03/11/93
// Name:      Frag.c
// Author:    Michael J. Steiner, Compuserve 70403,3452
//
// Notes:     These procedures are use to evaluate the relative fragmention
//            of the far heap. This value reflects the relative degree of
//            far heap fragmentation. Based on the amount of disarray in
//            the fragment to the size of the fragment and the far heap
//            above the fragment. bestfitfarmalloc() can be used to minimize
//            memory fragmentation.
//
//            The program demonstrates these functions, By Fragmenting
//            the memory into possibly 11 parts. With the one part being
//            the heap above the fragment. And displays information about
//            the fragment. After pressing a key it then allocates 5
//            variable length blocks, Using bestfitfarmalloc(). And again
//            shows information about the fragment after this allocation
//            process. When testing this program I had 530K of free memory
//            available. If it does work properly try decreasing the number
//            of pointers allocated, Or the number of parts for the fragment.
//
//            getheapfrag() is calculated as follows:
//
//	      breakpercent = freeblocks / ( usedblocks + freeblocks )
//
//            freepercent  = largestblock / ( totalfree + largestblock )
//
//            fragmentindex = breakpercent / freepercent
//
//            ---------------------------------------------
//
//            freeblocks    - Free blocks is the amount of free blocks
//                            available for use in the fragment.
//
//            usedblocks    - Used blocks is the amount of used blocks
//                            not available for use in the fragment.
// 
//            breakpercent  - Break up percentage is the percentage of
//                            free blocks available to the total blocks
//                            in the fragment.
//
//            freepercent   - Free percetage is the percentage of the largest
//                            allocatable block to the total free blocks
//                            in the far heap.
//
//            fragmentindex - Fragmentation index is a relative indiction
//                            of the amount of far heap fragmentation.
//
//        Discrepancy Ratio - This is the ratio of memory reported by the
//                            system using getfarheapfree() to the size
//                            of the largest block allocatable minus one.
//                            This is useful to see how much of the memory
//                            was actually allocated from the fragment. As
//                            to how much was allocated from the heap above
//                            the fragment. This happens due to the fact
//                            that the heap above the fragment is seen as
//                            part of the fragment during allocation.   
//                            
//            Maximum fragmentation occurs when every other block is free.
//            And all of memory in the far heap has been filled with
//            used:free block pairs.
//
//            These routines where written with borland products in mind.
//            And may require considerable rewrite to be used with MSC,
//            Or other language producers products. This is due to the use
//            of calls to functions that are included with borland products,
//            But that are not ANSI - C standard compatable. 
//
// Compiler restrictions:
//                       Memory model must be, compact, large, or huge.
//
//**************************************************************************

#pragma warn -sus     //compiler does'nt like compound pointer convertions

#include <stdio.h>
#include <alloc.h>
#include <stdlib.h>
#include <dos.h>
#include <mem.h>
#include <conio.h>

int  walkfarheap( void );
void fragmemory( void );
void allocatememory( void );
long getfarheapfree( void );
long getusedblocks( void );
long getfreeblocks( void );
long getlargest1( void );
long getmaxfreefrag( void );
long getmaxusedfrag( void );
long getusedfrag( void );
long getfreefrag( void );
double getheapfrag( void );
void freeptrs( void );
void* bestfitfarmalloc( unsigned long );

struct{
 void huge *ptr;
 unsigned long size;
 int in_use;
} p3[ 100 ];

char isos = 0;

void main( void )
{
 long FF, LG, UB, FB, MFF, MUF, GFF, GUF;
 double DR, FI;
 long FF1, LG1, UB1, FB1, MFF1, MUF1, GFF1, GUF1;
 double DR1, FI1;
 int size;

 if( farheapcheck() < 0 ) {
   printf( "Far heap corrupted.\n" );
   return;
  }

 printf( "\n" );
 printf( "Total memory available (before): %ld\n", getfarheapfree() );

 fragmemory();

 FF = getfarheapfree();
 LG = getlargest1();
 DR = ((double)getfarheapfree() / getlargest1()) - 1;
 FI = getheapfrag();
 UB = getusedblocks();
 FB = getfreeblocks();
 MFF = getmaxfreefrag();
 MUF = getmaxusedfrag();
 GFF = getfreefrag();
 GUF = getusedfrag();

 printf( "Total memory available (after) : %ld\n", FF );
 printf( "Largest contiguous memory block: %ld\n", LG );
 printf( "Discrepancy ratio              : %lf\n", DR );
 printf( "Used memory blocks in fragment : %ld\n", UB );
 printf( "Free memory blocks in fragment : %ld\n", FB );
 printf( "Used memory bytes in fragment  : %ld\n", GUF );
 printf( "Free memory bytes in fragment  : %ld\n", GFF );
 printf( "Largest used block in fragment : %ld\n", MUF );
 printf( "Largest free block in fragment : %ld\n", MFF );
 printf( "Fragmentation index (Relative) : %lf\n", FI );
 printf( "\n" );

 walkfarheap();

 printf( "\n" );
 printf( "Press any key...\n" );
 getchar();

 allocatememory();

 FF1 = getfarheapfree();
 LG1 = getlargest1();
 DR1 = ((double)getfarheapfree() / getlargest1()) - 1;
 FI1 = getheapfrag();
 UB1 = getusedblocks();
 FB1 = getfreeblocks();
 MFF1 = getmaxfreefrag();
 MUF1 = getmaxusedfrag();
 GFF1 = getfreefrag();
 GUF1 = getusedfrag();

 printf( "Total memory available (after) : %ld, %ld\n", FF1, FF );
 printf( "Largest contiguous memory block: %ld, %ld\n", LG1, LG );
 printf( "Discrepancy ratio              : %lf, %lf\n", DR1, DR );
 printf( "Used memory blocks in fragment : %ld, %ld\n", UB1, UB );
 printf( "Free memory blocks in fragment : %ld, %ld\n", FB1, FB );
 printf( "Used memory bytes in fragment  : %ld, %ld\n", GUF1, GUF );
 printf( "Free memory bytes in fragment  : %ld, %ld\n", GFF1, GFF );
 printf( "Largest used block in fragment : %ld, %ld\n", MUF1, MUF );
 printf( "Largest free block in fragment : %ld, %ld\n", MFF1, MFF );
 printf( "Fragmentation index (Relative) : %lf, %lf\n", FI1, FI );
 printf( "\n" );

 walkfarheap();

 freeptrs();
}

//**************************************************************************
//
// Name:      double getheapfrag( void )
//
// Purpose:   This function gets a relative value of far heap fragmentation.
//
// Return:    -1L on error.
//
//**************************************************************************

double getheapfrag( void )
{
 long freeblocks,usedblocks,largestblock,totalblock;
 double breakpercent,freepercent;

 if((freeblocks=getfreeblocks())==-1) return(-1L);

 if((usedblocks=getusedblocks())==-1) return(-1L);

 breakpercent=(double)freeblocks/(usedblocks+freeblocks);

 if((largestblock=getlargest1())==-1) return(-1L);

 if((totalblock=getfarheapfree())==-1) return(-1L);

 freepercent=(double)largestblock/(totalblock+largestblock);

 return(breakpercent/freepercent);
}

//**************************************************************************
//
// Name:      long getlargest1( void )
//
// Purpose:   This function gets the largest contiguous block in bytes that
//            can be allocated from the far heap. This does not include
//            free blocks in the allocated fragment.
//
// Return:    -1L on error.
//
//**************************************************************************

long getlargest1( void )
{
 struct farheapinfo h;
 long size=farcoreleft();

 if(farheapcheck()<0) return(-1L);

 h.ptr=NULL;

 while(farheapwalk(&h)==_HEAPOK) if(!h.in_use) size=max(size,h.size);

 return(size);
}

//**************************************************************************
//
// Name:      long getfreeblocks( void )
//
// Purpose:   This function gets the number of free blocks in allocated
//            fragment.
//
// Return:    -1L on error.
//
//**************************************************************************

long getfreeblocks( void )
{
 struct farheapinfo h;
 long blocks = 0;

 if(farheapcheck()<0) return(-1L);

 h.ptr=NULL;

 while(farheapwalk(&h)==_HEAPOK) if( !h.in_use ) blocks++;

 return(blocks);
}

//**************************************************************************
//
// Name:      long getusedblocks( void )
//
// Purpose:   This function gets the number of used blocks in allocated
//            fragment.
//
// Return:    -1L on error.
//
//**************************************************************************

long getusedblocks( void )
{
 struct farheapinfo h;
 long blocks = 0;

 if(farheapcheck()<0) return(-1L);

 h.ptr=NULL;

 while(farheapwalk(&h)==_HEAPOK) if(h.in_use) blocks++;

 return(blocks);
}

//**************************************************************************
//
// Name:      long getmaxfreefrag( void )
//
// Purpose:   This function gets the size in bytes of the largest free 
//            block in the allocated fragment.
//
// Return:    -1L on error.
//
//**************************************************************************

long getmaxfreefrag( void )
{
 struct farheapinfo h;
 long size = 0;

 if(farheapcheck()<0) return(-1L);

 h.ptr=NULL;

 while(farheapwalk(&h)==_HEAPOK) if(!h.in_use)  size=max(size,h.size);

 return(size);
}

//**************************************************************************
//
// Name:      long getmaxusedfrag( void )
//
// Purpose:   This function gets the size in bytes of the largest used 
//            block in the allocated fragment.
//
// Return:    -1L on error.
//
//**************************************************************************

long getmaxusedfrag( void )
{
 struct farheapinfo h;
 long size = 0;

 if(farheapcheck()<0) return(-1L);

 h.ptr=NULL;

 while(farheapwalk(&h)==_HEAPOK) if(h.in_use) size=max(size,h.size);

 return(size);
}

//**************************************************************************
//
// Name:      long getusedfrag( void )
//
// Purpose:   This function gets the size in bytes of the used portion 
//            of the fragment.
//
// Return:    -1L on error.
//
//**************************************************************************

long getusedfrag( void )
{
 struct farheapinfo h;
 long size = 0;

 if(farheapcheck()<0) return(-1L);

 h.ptr=NULL;

 while(farheapwalk(&h)==_HEAPOK) if(h.in_use) size += h.size;

 return(size);
}

//**************************************************************************
//
// Name:      long getfreefrag( void )
//
// Purpose:   This function gets the size in bytes of the free portion 
//            of the fragment.
//
// Return:    -1L on error.
//
//**************************************************************************

long getfreefrag( void )
{
 struct farheapinfo h;
 long size = 0;

 if(farheapcheck()<0) return(-1L);

 h.ptr=NULL;

 while(farheapwalk(&h)==_HEAPOK) if(!h.in_use) size += h.size;

 return(size);
}

//**************************************************************************
//
// Name:      long getfarheapfree( void )
//
// Purpose:   This function gets the size in bytes of the free far heap. 
//            This includes free blocks in the allocated fragment. And
//            the memory above that.
//
// Return:    -1L on error.
//
//**************************************************************************

long getfarheapfree( void )
{
 long size = farcoreleft();
 struct farheapinfo h;
 int i;

 if(farheapcheck()<0) return(-1L);

 h.ptr=NULL;

 while((i=farheapwalk(&h))==_HEAPOK) if(!h.in_use) size+=h.size;

 if((i!=_HEAPEMPTY)&&(i!=_HEAPEND)) return(-1L);

 return(size);
}

//**************************************************************************
//
// Name:      int walkfarheap( void )
//
// Purpose:   This function walks the far heap. It displays information
//            gathered. In the form of: Address, block number, size, status  
//
// Return:    -1 on error.
//
//**************************************************************************

int walkfarheap( void )
{
 struct farheapinfo h;
 int i = 1;
 char *STAT[] = { "BAD VALUE   ",   //-3
		  "BAD NODE    ",   //-2
		  "HEAP CORRUPT",   //-1
		  "UNKNOWN     ",   // 0
		  "HEAP EMPTY  ",   // 1
		  "HEAP OK     ",   // 2
		  "HEAP FREE   ",   // 3
		  "HEAP USED   ",   // 4
		  "HEAP END    "  };// 5

 if(farheapcheck()<0){
   printf( "Far heap corrupted.\n" );
   return(-1);
  }

 h.ptr=NULL;

 printf( "Block      Block   Size      Block\n" );
 printf( "Address    Number  In Bytes  Status\n" );
 printf( "-----------------------------------------\n" );

 while(farheapwalk(&h)==_HEAPOK){
   printf( "%p    %-3d   %-7lu   %s\n", h.ptr, i, h.size,
				   STAT[ (farheapchecknode( h.ptr ) + 3) ] );
   i++;
  }

 return(0);
}

//**************************************************************************
//
// Name:      void fragmemory( void )
//
// Purpose:   This function is to fragment the memory. It fragments the 
//            memory in possibly 10 parts. The size of these fragments
//            are at least 10240 bytes and at most 20480 bytes.
//
// Return:    None.
//
//**************************************************************************

void fragmemory( void )
{
 int i,numptrs;
 long size;

 randomize();

 numptrs=random(10)+1;

 for(i=0;i<numptrs;i++){
   size=random(10480)+10240;

   p3[i].ptr=farmalloc(size);
   p3[i].size=size;
   p3[i].in_use=1;
  }

 for(i=0;i<numptrs;i+=(random(3)+1)){
   farfree(p3[i].ptr);
   p3[i].size=0;
   p3[i].in_use=0;
  }
}

//**************************************************************************
//
// Name:      void allocatememory( void )
//
// Purpose:   This function is to allocate 5 memory blocks. These blocks
//            will be at least 10240 bytes and at most 20480 bytes.
//
// Return:    None.
//
//**************************************************************************

void allocatememory( void )
{
 int i,numptrs;
 long size;

 randomize();

 numptrs=random(5)+1;

 for(i=0;i<numptrs;i++){
   size=random(10480)+10240;

   if((p3[i].ptr=bestfitfarmalloc(size))!=NULL)
    printf("Pointer %p, of size %ld was allocated using %s\n",
		 p3[i].ptr,size,isos?"Best fit malloc.":"First fit malloc.");
   else
    printf("The allocation porcess failed for atempt %d\n",i);

   p3[i].size=size;
   p3[i].in_use=1;
  }
 printf("\n");
}

//**************************************************************************
//
// Name:      void freeptrs( void )
//
// Purpose:   This function frees the pointers allocated in fragmemory() 
//
// Return:    None.
//
//**************************************************************************

void freeptrs( void )
{
 int i;

 for(i=0;i<100;i++){
   if(p3[i].ptr!=NULL) farfree(p3[i].ptr);
   p3[ i ].size = 0;
   p3[ i ].in_use = 0;
  }
}


//**************************************************************************
//
// Name:      void* bestfitfarmalloc( unsigned long nbytes )
//
// Purpose:   This function takes the place of farmalloc(). By using this
//            function over farmalloc() you can improve, That is reduce
//            the amount of memory fragmentation that occurs. farmalloc()
//            uses 'first fit' when searching for unused memory blocks.
//            While bffarmalloc() uses 'best fit' or tries to.
//            In some particular situations this does work better.
//            When over time allocating and deallocating dynamicaly, Memory
//            from the far heap. There is still room for improvement in
//            this function. Much of this is due to the use of the function
//            realloc(). Some times realloc() (when shinking a block to 
//            resize it) compresses the block from both top and bottom.
//            This can increase the fragmentation, By creating two small
//            blocks that are to small to be of use.
//
// Return:    A pointer to the newly allocated block.
//
//**************************************************************************


void* bestfitfarmalloc(unsigned long nbytes)
{
 struct farheapinfo h;
 register int i=0, i1;
 int i2;
 void *p1;
 unsigned long smallsize=0xffffffff,diffsize;
 unsigned char bffflag=0,bfptr=0;

 struct{
   void *ptr;
   unsigned long size;
   int in_use;
  }p2[100]; 

 if(farheapcheck()<0) return(NULL);

// Gather information about the fragments free blocks

 h.ptr=NULL;

 while(farheapwalk(&h)==_HEAPOK)
  if(!h.in_use){
    p2[i].ptr=h.ptr;
    p2[i].size=h.size;
    i++;
   }

//See if any of them will accommodate the requested block size

 for(i1=0;i1<i;i1++)
  if((p2[i1].size-8)>=nbytes){
    diffsize=p2[i1].size-nbytes;
    if(diffsize<smallsize){
      smallsize=diffsize;
      bfptr=i1;
      bffflag=1;
     }
   }

//If not allocate memory from the heap above the fragment. And return a
//pointer to it.

 if(bffflag==0) return(farmalloc(nbytes));

//Allocate the entire block above the fragment. To mask it from consideration

 if((p1=farmalloc(getlargest1()-16))==NULL) return(NULL);

//Allocate all the free blocks except the best fit from the fragment.
// To mask unwanted blocks out.

 for(i1=0;i1<i;i1++)
  if(i1!=bfptr)
   p2[i1].ptr=farmalloc(p2[i1].size-16);

//Try to allocate memory from the fragment.

 p2[bfptr].ptr=farmalloc(nbytes);

//Free all but the best fit block.

 for(i1=0;i1<i;i1++) if(i1!=bfptr) if(p2[i1].ptr!=NULL) farfree(p2[i1].ptr);

//Free the block above the fragment.

 farfree(p1);

//isos if a flag to tell which memory was used 'Fragmented' or 'Above'

 isos=1;

//If the pointer is NULL, Attempt to allocate memory from the far heap.

 if(p2[bfptr].ptr==NULL){
   p2[bfptr].ptr=farmalloc(nbytes);
   isos = 0;
  }

//And return a pointer to the block, If from fragment.

 return(p2[bfptr].ptr);
}


