/*--------------------------------------------------------------------
-                     Copyright (C) 1988-1992
-                         SimpleSoft Inc.
-
- Written by..... Kevin Dahl
- Module name.... fpwin.h
- Date created... 5/5/91
- Purpose........
-
--------------------------------------------------------------------*/

#ifndef FPCWIN
#define FPCWIN

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <conio.h>
#include <malloc.h>
#include <dos.h>
#include <time.h>
#include <conio.h>
#include <fpclib.h>

/*--------------------------------------------------------------------
-
--------------------------------------------------------------------*/

typedef          char    CHAR;     /* ch  */
typedef          short   SHORT;    /* s   */
typedef          long    LONG;     /* l   */

typedef unsigned char    UCHAR;    /* uch */
typedef unsigned short   USHORT;   /* us  */
typedef unsigned long    ULONG;    /* ul  */

typedef unsigned char    BYTE;     /* b   */

typedef unsigned char   *PSZ;
typedef unsigned char   *PCH;

typedef BYTE            *PBYTE;

typedef CHAR            *PCHAR;
typedef SHORT           *PSHORT;
typedef LONG            *PLONG;

typedef UCHAR           *PUCHAR;
typedef USHORT          *PUSHORT;
typedef ULONG           *PULONG;

typedef unsigned short   BOOL;        /* f         */
typedef BOOL            *PBOOL;

typedef unsigned short   SHANDLE;
typedef VOID FAR        *LHANDLE;
typedef VOID FAR        *MPARAM;      /* msg param */

typedef LHANDLE          HWND;        /* hwnd      */
typedef HWND            *PHWND;
typedef LHANDLE          HMQ;         /* hmq       */
typedef LHANDLE          HAB;         /* hab       */

typedef VOID FAR        *MPARAM;      /* mp        */
typedef MPARAM FAR      *PMPARAM;     /* pmp       */

typedef VOID FAR        *MRESULT;     /* mres      */
typedef MRESULT FAR     *PMRESULT;    /* pmres     */

typedef USHORT           HMODULE;     /* hmod      */
typedef HMODULE FAR     *PHMODULE;

typedef VOID FAR        *PVOID;

/*--------------------------------------------------------------------
-
--------------------------------------------------------------------*/

#define INT_TIMER               0x08
#define INT_KBD                 0x09
#define INT_BIOSKBD             0x16

#define SYSQMAXEVENTS           50
#define DEFAULT_QUEUE_SIZE      10;

/*--------------------------------------------------------------------
-
--------------------------------------------------------------------*/

#define TRUE                    (BOOL) 1
#define FALSE                   (BOOL) 0

/*--------------------------------------------------------------------
- MouGetEventMask/MouSetEventMask events
--------------------------------------------------------------------*/

#define MOUSE                   0x007f
#define MOUSE_MOTION            0x0001
#define MOUSE_BN1_DOWN          0x0002
#define MOUSE_BN1_UP            0x0004
#define MOUSE_BN2_DOWN          0x0008
#define MOUSE_BN2_UP            0x0010
#define MOUSE_BN3_DOWN          0x0020
#define MOUSE_BN3_UP            0x0040

#define MOUSE_BN_DOWN           0x002A
#define MOUSE_BN_UP             0x0054

/*--------------------------------------------------------------------
- Keyboard Shift Key masks.
--------------------------------------------------------------------*/

#define INSKEY                  0x80
#define CAPSLOCK                0x40
#define NUMLOCK                 0x20
#define SCROLLLOCK              0x10
#define ALTKEY                  0x08
#define CTRLKEY                 0x04
#define BSHFTKEY                0x03
#define LSHFTKEY                0x02
#define RSHFTKEY                0x01

/*--------------------------------------------------------------------
- Messages
--------------------------------------------------------------------*/

#define WM_NULL                 0x0000


#define WM_CLOSE                0x0029
#define WM_QUIT 		0x002a

/*--------------------------------------------------------------------
- Mouse input messages
--------------------------------------------------------------------*/

#define WM_MOUSEFIRST           0x0070
#define WM_MOUSELAST            0x0079

#define WM_BUTTONCLICKFIRST	0x0071
#define WM_BUTTONCLICKLAST	0x0079

#define WM_MOUSEMOVE		0x0070
#define WM_BUTTON1DOWN          0x0071
#define WM_BUTTON1UP            0x0072
#define WM_BUTTON1DBLCLK        0x0073
#define WM_BUTTON2DOWN          0x0074
#define WM_BUTTON2UP		0x0075
#define WM_BUTTON2DBLCLK	0x0076
#define WM_BUTTON3DOWN          0x0077
#define WM_BUTTON3UP		0x0078
#define WM_BUTTON3DBLCLK	0x0079

/*--------------------------------------------------------------------
- WM_HITTEST return codes
--------------------------------------------------------------------*/

#define HT_NORMAL		0
#define HT_TRANSPARENT		(-1)
#define HT_DISCARD		(-2)
#define HT_ERROR		(-3)

/*--------------------------------------------------------------------
- Key/Character input messages
--------------------------------------------------------------------*/

#define WM_CHAR                 0x007a
#define WM_VIOCHAR		0x007b

/*--------------------------------------------------------------------
- WM_CHAR fs field bits
--------------------------------------------------------------------*/

#define KC_CHAR 		0x0001
#define KC_VIRTUALKEY           0x0002
#define KC_SCANCODE             0x0004
#define KC_SHIFT                0x0008
#define KC_CTRL                 0x0010
#define KC_ALT                  0x0020
#define KC_KEYUP                0x0040
#define KC_PREVDOWN             0x0080
#define KC_LONEKEY              0x0100
#define KC_DEADKEY              0x0200
#define KC_COMPOSITE            0x0400
#define KC_INVALIDCOMP		0x0800

/*--------------------------------------------------------------------
- Reserve a range of messages for help manager.  This range includes
- public messages, defined below, and private ones, which need to be
- reserved here to prevent clashing with application messages
--------------------------------------------------------------------*/

#define WM_HELPBASE		0x0F00 /* Start of msgs for help manager */
#define WM_HELPTOP		0x0FFF /* End of msgs for help manager	 */

#define WM_USER 		0x1000

/*--------------------------------------------------------------------
- Virtual key values
--------------------------------------------------------------------*/

#define VK_BUTTON1		0x01
#define VK_BUTTON2		0x02
#define VK_BUTTON3		0x03
#define VK_BREAK		0x04
#define VK_BACKSPACE		0x05
#define VK_TAB			0x06
#define VK_BACKTAB		0x07
#define VK_NEWLINE		0x08
#define VK_SHIFT		0x09
#define VK_CTRL 		0x0A
#define VK_ALT			0x0B
#define VK_ALTGRAF		0x0C
#define VK_PAUSE		0x0D
#define VK_CAPSLOCK		0x0E
#define VK_ESC			0x0F
#define VK_SPACE		0x10
#define VK_PAGEUP		0x11
#define VK_PAGEDOWN		0x12
#define VK_END			0x13
#define VK_HOME 		0x14
#define VK_LEFT 		0x15
#define VK_UP			0x16
#define VK_RIGHT		0x17
#define VK_DOWN 		0x18
#define VK_PRINTSCRN		0x19
#define VK_INSERT		0x1A
#define VK_DELETE		0x1B
#define VK_SCRLLOCK		0x1C
#define VK_NUMLOCK		0x1D
#define VK_ENTER		0x1E
#define VK_SYSRQ		0x1F
#define VK_F1			0x20
#define VK_F2			0x21
#define VK_F3			0x22
#define VK_F4			0x23
#define VK_F5			0x24
#define VK_F6			0x25
#define VK_F7			0x26
#define VK_F8			0x27
#define VK_F9			0x28
#define VK_F10			0x29
#define VK_F11			0x2A
#define VK_F12			0x2B
#define VK_F13			0x2C
#define VK_F14			0x2D
#define VK_F15			0x2E
#define VK_F16			0x2F
#define VK_F17			0x30
#define VK_F18			0x31
#define VK_F19			0x32
#define VK_F20			0x33
#define VK_F21			0x34
#define VK_F22			0x35
#define VK_F23			0x36
#define VK_F24			0x37

#define VK_MENU                 VK_F10

#define VK_DBCSFIRST            0x0080
#define VK_DBCSLAST		0x00ff

#define VK_USERFIRST		0x0100
#define VK_USERLAST		0x01ff

/*--------------------------------------------------------------------
- system variable access contants.
--------------------------------------------------------------------*/

#define SV_SWAPBUTTON           0
#define SV_DBLCLKTIME		1
#define SV_CXDBLCLK		2
#define SV_CYDBLCLK		3
#define SV_CXSIZEBORDER 	4
#define SV_CYSIZEBORDER 	5
#define SV_ALARM		6

/*--------------------------------------------------------------------
- WinPeekMsg() constants
--------------------------------------------------------------------*/

#define PM_REMOVE		0x0001
#define PM_NOREMOVE		0x0000

/*--------------------------------------------------------------------
-
--------------------------------------------------------------------*/

#define HWND_DESKTOP            (HWND)1
#define HWND_OBJECT		(HWND)2
#define HWND_TOP                (HWND)3
#define HWND_BOTTOM		(HWND)4
#define HWND_THREADCAPTURE      (HWND)5

/*--------------------------------------------------------------------
- Standard Window Styles
--------------------------------------------------------------------*/

#define WS_VISIBLE		0x80000000L
#define WS_DISABLED		0x40000000L
#define WS_CLIPCHILDREN 	0x20000000L
#define WS_CLIPSIBLINGS 	0x10000000L
#define WS_PARENTCLIP		0x08000000L
#define WS_SAVEBITS		0x04000000L
#define WS_SYNCPAINT		0x02000000L
#define WS_MINIMIZED		0x01000000L
#define WS_MAXIMIZED		0x00800000L

/*--------------------------------------------------------------------
- Dialog manager styles
--------------------------------------------------------------------*/

#define WS_GROUP		0x00010000L
#define WS_TABSTOP		0x00020000L
#define WS_MULTISELECT		0x00040000L

/*--------------------------------------------------------------------
- Class styles
--------------------------------------------------------------------*/

#define CS_MOVENOTIFY		0x00000001L
#define CS_SIZEREDRAW		0x00000004L
#define CS_HITTEST		0x00000008L
#define CS_PUBLIC		0x00000010L
#define CS_FRAME		0x00000020L
#define CS_CLIPCHILDREN 	0x20000000L
#define CS_CLIPSIBLINGS 	0x10000000L
#define CS_PARENTCLIP		0x08000000L
#define CS_SAVEBITS		0x04000000L
#define CS_SYNCPAINT		0x02000000L

/*--------------------------------------------------------------------
- Standard Window Messages
--------------------------------------------------------------------*/

#define WM_CREATE               0x0001
#define WM_DESTROY		0x0002
#define WM_OTHERWINDOWDESTROYED 0x0003
#define WM_ENABLE               0x0004
#define WM_SHOW 		0x0005
#define WM_MOVE 		0x0006
#define WM_SIZE 		0x0007
#define WM_ADJUSTWINDOWPOS	0x0008
#define WM_CALCVALIDRECTS       0x0009
#define WM_SETWINDOWPARAMS      0x000a
#define WM_QUERYWINDOWPARAMS	0x000b
#define WM_HITTEST		0x000c
#define WM_ACTIVATE		0x000d
#define WM_SETFOCUS		0x000f
#define WM_SETSELECTION 	0x0010

/*--------------------------------------------------------------------
-
--------------------------------------------------------------------*/

typedef enum _WINDOW_CLASS
   {
   WC_FRAME,
   WC_BUTTON,
   WC_ENTRYFIELD,
   WC_LISTBOX,
   WC_MENU,
   WC_SCROLLBAR,
   WC_STATIC,
   WC_TITLE
   } CLASS;

/*--------------------------------------------------------------------
-
--------------------------------------------------------------------*/

#define EXPENTRY pascal far _loadds
#define APIENTRY pascal far

/*--------------------------------------------------------------------
-
--------------------------------------------------------------------*/

typedef struct _POINTL                /* ptl       */
   {
   SHORT                 x;
   SHORT                 y;
   } POINTL;

/*--------------------------------------------------------------------
- The following structure and macro are used to access the
- WM_COMMAND, WM_HELP, and WM_SYSCOMMAND message parameters:
--------------------------------------------------------------------*/

typedef struct _COMMANDMSG               /* commandmsg */
   {
   USHORT                source;         /* mp2 */
   BOOL                  fMouse;
   USHORT                cmd;            /* mp1 */
   USHORT                unused;
   } CMDMSG;

/*--------------------------------------------------------------------
- The following structure and macro are used to access the
- WM_MOUSEMOVE, and WM_BUTTON message parameters
--------------------------------------------------------------------*/

typedef struct _MOUSEMSG                   /* mousemsg */
   {
   USHORT                codeHitTest;      /* mp2  */
   USHORT                unused;
   SHORT                 x;                /* mp1  */
   SHORT                 y;
   } MSEMSG;

/*--------------------------------------------------------------------
- The following structure and macro are used to access the
- WM_CHAR message parameters.
--------------------------------------------------------------------*/

typedef struct _CHARMSG               /* charmsg */
   {
   USHORT                chr;         /* mp2  */
   USHORT                vkey;
   USHORT                fs;          /* mp1  */
   UCHAR                 cRepeat;
   UCHAR                 scancode;
   } CHRMSG;

/*--------------------------------------------------------------------
- QMSG structure
--------------------------------------------------------------------*/

typedef struct _QMSG
   {
   HWND                  hwnd;
   USHORT                msg;
   MPARAM                mp1;
   MPARAM                mp2;
   ULONG                 time;
   POINTL                ptl;
   } QMSG;

/*--------------------------------------------------------------------
- structure for message queue
--------------------------------------------------------------------*/

typedef struct _MSGQUEUE_t
   {
   QMSG                 *MsgQ;
   SHORT                 MaxEvents;
   SHORT                 NEvents;          /* number of events|msgs   */
   SHORT                 CEvent;           /* next pos to place event */
   } MSGQUEUE_t;

/*--------------------------------------------------------------------
- structure for message queues
--------------------------------------------------------------------*/

typedef struct _MSGQ_t
   {
   MSGQUEUE_t            SysQ;
   MSGQUEUE_t            AppQ;
   QMSG                  PaintMsg;
   USHORT                ShiftKeys;
   } MSGQ_t;


/*--------------------------------------------------------------------
-
--------------------------------------------------------------------*/

typedef struct _CLASSDEF_t
   {

   struct _CLASSDEF_t   *Next;
          CLASS          class;
          CLASS          base;

          BYTE          *CWindow;
          BYTE          *CSelected;
          BYTE          *CFrame;

          ULONG          Style;

          HAB            hab;
          PSZ            pszClassName;
          MRESULT        (EXPENTRY *PFNWP)(HWND, USHORT, MPARAM, MPARAM);

          USHORT         cbWindowData;
   } CLASSDEF_t;

/*--------------------------------------------------------------------
-
--------------------------------------------------------------------*/

typedef struct _WINDOW_t
   {
   struct _WINDOW_t     *Next;

          PCHAR          WinClass;
          PCHAR          WinName;

   struct _WINDOW_t     *WinOwner;
   struct _WINDOW_t     *WinParent;

   struct _WINDOW_t     *WinFirstChild;
   struct _WINDOW_t     *WinLastChild;

   struct _WINDOW_t     *WinPrevSibling;
   struct _WINDOW_t     *WinNextSibling;

          SHORT          Winx;          // horizontal position of window
          SHORT          Winy;          // vertical position of window
          SHORT          Wincx;         // width of window
          SHORT          Wincy;         // height of window

          ULONG          WinStyle;
          USHORT         WinIdent;

          SHORT          WinDataAmt;
          PVOID          WinData;

   } WINDOW_t;


/*--------------------------------------------------------------------
-
--------------------------------------------------------------------*/

typedef CMDMSG     FAR *  PCMDMSG;
typedef POINTL     FAR *  PPOINTL;
typedef MSEMSG     FAR *  PMSEMSG;
typedef CHRMSG     FAR *  PCHRMSG;
typedef QMSG       FAR *  PQMSG;
typedef MSGQUEUE_t FAR *  PMSGQUEUE_t;
typedef MSGQ_t     FAR *  PMSGQ_t;
typedef CLASSDEF_t FAR *  PCLASSDEF_t;
typedef WINDOW_t   FAR *  PWINDOW_t;

/*--------------------------------------------------------------------
- one handle anchor block is created for each thread
--------------------------------------------------------------------*/

typedef struct _GLOBAL_HAB_t
   {
   struct _GLOBAL_HAB_t *Next;
   struct _GLOBAL_HAB_t *Prev;
          PCHAR          PgmName;             /* program name              */
          PMSGQ_t        MsgQ;                /* message queues            */
          PWINDOW_t      WinFocus;            /* window that has the focus */
          PWINDOW_t      DeskTop;
          PWINDOW_t      DeskTopObj;
          PCLASSDEF_t    ClassDef;

   } GLOBAL_HAB_t;

typedef GLOBAL_HAB_t FAR *  PGLOBAL_HAB_t;

/*--------------------------------------------------------------------
- global variables for fpwin.
--------------------------------------------------------------------*/

extern PGLOBAL_HAB_t  ghabHead;
extern PGLOBAL_HAB_t  ghab;
extern PGLOBAL_HAB_t  ghabTail;
extern SHORT          gSysVal[];


/*--------------------------------------------------------------------
-
- MODULE: queues.c
-
--------------------------------------------------------------------*/

HAB  APIENTRY WinInitialize( USHORT fsOptions );
BOOL APIENTRY WinTerminate( HAB hab );

BOOL APIENTRY WinPeekMsg( HAB     syshab,
                          PQMSG   pqmsg,
                          HWND    hwndFilter,
                          USHORT  msgFilterFirst,
                          USHORT  msgFilterLast,
                          USHORT  fs );

BOOL APIENTRY WinGetMsg(  HAB     hab,
                          PQMSG   qmsg,
                          HWND    hwndFilter,
                          USHORT  msgFilterFirst,
                          USHORT  msgFilterLast );

HMQ  APIENTRY WinCreateMsgQueue( HAB hab, SHORT cmsg );
BOOL APIENTRY WinDestroyMsgQueue( HMQ hmq );
BOOL APIENTRY WinPostMsg( HWND hwnd, USHORT msg, MPARAM mp1, MPARAM mp2 );

/*--------------------------------------------------------------------
-
- MODULE: dynarray.c
-
--------------------------------------------------------------------*/

SHORT ExpandArray( PVOID *Array, SHORT ElmtSize,
                   SHORT NElmts, PSHORT LastElmt );

VOID  ShrinkArray( PVOID *Array, SHORT ElmtSize,
                   SHORT NElmts, PSHORT LastElmt );

VOID  Release( PVOID *Node );

/*--------------------------------------------------------------------
-
- MODULE: window.c
-
--------------------------------------------------------------------*/

typedef MRESULT (EXPENTRY *PFNWP)(HWND, USHORT, MPARAM, MPARAM);



#endif
