#include <fpclib.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <conio.h>

void TestBiosKbdClr( void );
void TestBiosKbdGetElmt( void );
void TestBiosKbdHit( void );
void TestBiosKbdRead( void );
void TestBiosKbdStat( void );
void TestDosKbdClr( void );
void TestDosKbdGetElmt( void );
void TestDosKbdHit( void );
void TestDosKbdRead( void );
int  GetMenuSelection( void );


void TestBiosKbdClr()
{
   char Ch = 0;
   int  i;

   printf( "BiosKbdClr - Press 'A' to quit\n" );
   while ( Ch != 'A' ) {
      for ( i = 0; i < 20000; i++ )
      ;
      BiosKbdClr();
      Ch = ReadKey();
      printf( "%c", Ch );
   }
};

void TestBiosKbdGetElmt()
{
   int Ch = 0;

   printf( "BiosKbdGetElmt - Press [ESC] to quit\n" );
   while ( Ch != 1 ) {
      Ch = BiosKbdGetElmt();
      printf( "Ch = %c ==> %u\n", (Ch < 133) ? (Ch) : (Ch-132), Ch );
   }
};

void TestBiosKbdHit()
{
   BiosKbdClr();
   while ( !BiosKbdHit() )
      printf( "Press any key to end test\n" );
};

void TestBiosKbdRead()
{
   char St[3];

   printf( "BiosKbdRead - Press 'A' to quit\n" );
   St[0] = 0;
   while ( St[0] != 'A' ) {
      BiosKbdRead( St );
      printf( "St = %s   St[0] = %c  St[1] = %c   Len = %u\n",
               St, St[0], St[1], strlen( St ) );
   }
};

void TestBiosKbdStat()
{
   char  St[9];
   int   Ch = 0,Stat,i,Remainder;

   ClrWin( 1, 1, 80, 25, 7 );
   memset( St, 0, 9 );

   printf( "BiosKbdStat - Press any key to quit\n" );
   while ( !Ch ) {
      GotoxyAbs( 1, 1 );
      Stat = BiosKbdStat();

      for ( i = 0; i < 8; St[i++] = '0' )
      ;

      for ( i = 7; i >= 0 && Stat > 0; i-- ) {
         Remainder = Stat % 2;
         St[i] = Remainder + 48;
         Stat /= 2;
      }

      printf( "BiosKbdStat = %s \n", St );
      Ch = BiosKbdGetElmt();
   }
}

void TestDosKbdClr()
{
   char Ch = 0;
   int  i  = 0;

   printf( "DosKbdClr - Press 'A' to quit\n" );
   while ( Ch != 'A' ) {
      for ( i = 0; i < 32767; i++ )
      ;
      DosKbdClr();
      Ch = ReadKey();
      printf( "%c", Ch );
   }
};

void TestDosKbdGetElmt()
{
   int Ch = 0;

   printf( "DosKbdGetElmt - Press 'A' to quit\n" );
   while ( Ch != 197 ) {
      Ch = DosKbdGetElmt();
      printf( "Ch = %c ==> %u\n", (Ch < 133) ? (Ch) : (Ch-132), Ch );
   }
}

void TestDosKbdHit()
{
   printf( "DosKbdClr - Press any key to quit\n" );
   DosKbdClr();
   while ( !DosKbdHit() )
      printf( "Press any key to end test\n" );

}

void TestDosKbdRead()
{
   char St[3];

   printf( "DosKbdRead - Press 'A' to quit\n" );
   St[0] = '\0';
   while ( St[0] != 'A' ) {
      DosKbdRead( St );
      printf( "St = %s   St[0] = %u   St[1] = %u     ", St, St[0], St[1] );
      printf( "Len = %u   \n", strlen( St ) );
   }
}

int GetMenuSelection()
{
   int Item;

   ClrWin( 1, 1, 80, 25, 7 );
   GotoxyAbs(1,1);

   printf( "\n 1. BiosKbdClr      " );
   printf( "\n 2. BiosKbdGetElmt  " );
   printf( "\n 3. BiosKbdHit      " );
   printf( "\n 4. BiosKbdRead     " );
   printf( "\n 5. BiosKbdStat     " );
   printf( "\n 6. DosKbdClr       " );
   printf( "\n 7. DosKbdGetElmt   " );
   printf( "\n 8. DosKbdHit       " );
   printf( "\n 9. DosKbdRead      " );
   printf( "\n" );
   printf( "\n 0. Quit" );
   printf( "\n" );
   printf( "\nEnter selection to test ==> " );

   do {

      Item = ReadKey() - 48;

   } while ( Item < 0 || Item > 9 );

   printf( "\n\n" );
   return( Item );
}

void main( void )
{
   int done = 0;

   VioInit();

   ClrWin( 1, 1, 80, 25, 7 );
   GotoxyAbs( 1, 1 );

   while ( !done ) {
      switch ( GetMenuSelection() ) {
          case 0 : done = 1;               break;
          case 1 : TestBiosKbdClr();       break;
          case 2 : TestBiosKbdGetElmt();   break;
          case 3 : TestBiosKbdHit();       break;
          case 4 : TestBiosKbdRead();      break;
          case 5 : TestBiosKbdStat();      break;
          case 6 : TestDosKbdClr();        break;
          case 7 : TestDosKbdGetElmt();    break;
          case 8 : TestDosKbdHit();        break;
          case 9 : TestDosKbdRead();       break;
      };
   };
}
