#include <stdlib.h>
#include <stdio.h>
#include "..\include\fpcwin.h"

/*--------------------------------------------------------------------
-
--------------------------------------------------------------------*/

void DspScn( void )
{
   ClrWin( 1, 1, 80, 25, 0x70 );

   WindowFP( 1, 1, 80, 25 );
   FrameWin( '', '', '', '', '', '', 0x70 );

   DspMsg( 31, 1, " Message Monitor " );

   DspMsg( 3,  3, "Last Key Message" );
   DspMsg( 3,  4, "   Char code......." );
   DspMsg( 3,  5, "   Scan code......." );

   DspMsg( 3,  7, "Keyboard Flags" );
   DspMsg( 3,  8, "   KC_CHAR............ FALSE" );
   DspMsg( 3,  9, "   KC_VIRTUALKEY...... FALSE" );
   DspMsg( 3, 10, "   KC_SCANCODE........ FALSE" );
   DspMsg( 3, 11, "   KC_SHIFT........... FALSE" );
   DspMsg( 3, 12, "   KC_CTRL............ FALSE" );
   DspMsg( 3, 13, "   KC_ALT............. FALSE" );
   DspMsg( 3, 14, "   KC_KEYUP........... FALSE" );
   DspMsg( 3, 15, "   KC_PREVDOWN........ FALSE" );
   DspMsg( 3, 16, "   KC_LONEKEY......... FALSE" );
   DspMsg( 3, 17, "   KC_DEADKEY......... FALSE" );
   DspMsg( 3, 18, "   KC_COMPOSITE....... FALSE" );
   DspMsg( 3, 19, "   KC_INVALIDCOMP..... FALSE" );

   DspMsg( 43, 3, "Last Mouse Message" );
   DspMsg( 43, 4, "   x............" );
   DspMsg( 43, 5, "   y............" );
   DspMsg( 43, 6, "   codeHitTest.." );

   DspMsg( 43, 8, "Last Message...." );
   DspMsg( 43, 9, "Clock Ticks....." );
}

/*--------------------------------------------------------------------
-
--------------------------------------------------------------------*/

void DisplayMsg( QMSG qmsg )
{
   int              i;
   unsigned long    j;
   char             st[20];
   CHRMSG           kbd;
   MSEMSG           mou;


   if ( qmsg.msg == WM_CHAR ) {
      memcpy( &kbd.fs,  &qmsg.mp1, 4 );
      memcpy( &kbd.chr, &qmsg.mp2, 4 );

      sprintf( st, "%03d", kbd.chr );
      DspMsg( 23, 4, st );

      sprintf( st, "%02x", kbd.scancode );
      DspMsg( 23, 5, st );

      for ( j = 1, i = 8; i <= 19; i++, j <<= 1 ) {
         if ( kbd.fs & j )
            DspMsg( 26, i, "TRUE " );
         else
            DspMsg( 26, i, "FALSE" );
      }
   }
   else if ( qmsg.msg >= WM_MOUSEFIRST && qmsg.msg <= WM_MOUSELAST ) {

      memcpy( &mou.codeHitTest, &qmsg.mp2, 4 );
      memcpy( &mou.x,           &qmsg.mp1, 4 );

      sprintf( st, "%3d",mou.x );
      DspMsg( 60, 4, st );

      sprintf( st, "%3d",mou.y );
      DspMsg( 60, 5, st );

      sprintf( st, "%03d", mou.codeHitTest );
      DspMsg( 60, 6, st );

   }


   switch ( qmsg.msg ) {
      case WM_CHAR          : strcpy( st, "WM_CHAR         " ); break;
      case WM_MOUSEMOVE     : strcpy( st, "WM_MOUSEMOVE    " ); break;
      case WM_BUTTON1DOWN   : strcpy( st, "WM_BUTTON1DOWN  " ); break;
      case WM_BUTTON1UP     : strcpy( st, "WM_BUTTON1UP    " ); break;
      case WM_BUTTON1DBLCLK : strcpy( st, "WM_BUTTON1DBLCLK" ); break;
      case WM_BUTTON2DOWN   : strcpy( st, "WM_BUTTON2DOWN  " ); break;
      case WM_BUTTON2UP     : strcpy( st, "WM_BUTTON2UP    " ); break;
      case WM_BUTTON2DBLCLK : strcpy( st, "WM_BUTTON2DBLCLK" ); break;
      case WM_BUTTON3DOWN   : strcpy( st, "WM_BUTTON3DOWN  " ); break;
      case WM_BUTTON3UP     : strcpy( st, "WM_BUTTON3UP    " ); break;
      case WM_BUTTON3DBLCLK : strcpy( st, "WM_BUTTON3DBLCLK" ); break;
      default               : strcpy( st, "UNKNOWN         " ); break;
   }
   DspMsg( 60, 8, st );

   sprintf( st, "%09lx", qmsg.time );
   DspMsg( 60, 9, st );
}

/*--------------------------------------------------------------------
-
--------------------------------------------------------------------*/

void main()
{
   HAB	    hab;
   HMQ      hmq;
   QMSG     qmsg;
   CHRMSG   kbd;


   hab = WinInitialize( 0 );
   hmq = WinCreateMsgQueue( hab, 50 );

   DspScn();

   while ( WinGetMsg( hab, &qmsg, 0, 0, 0 ) ) {

      DisplayMsg( qmsg );

      if ( qmsg.msg == WM_CHAR ) {
         memcpy( &kbd.fs,  &qmsg.mp1, 4 );
         memcpy( &kbd.chr, &qmsg.mp2, 4 );

         if ( kbd.scancode == 1 && kbd.chr == 27 )
            break;
      }

   }
   ClrWin( 1, 1, 80, 25, 7 );
   GotoxyAbs( 1, 1 );

   WinDestroyMsgQueue( hmq );
   WinTerminate( hab );
   exit( 0 );
}
