#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <memory.h>
#include <fpclib.h>

/*---------------------------------------------------------------
-
- EXAMPLExxx where xxx is the number of the example to compile
-
- #define EXAMPLExxx  1
-
---------------------------------------------------------------*/

#define EXAMPLE010  1

/*----------------------------------------------------------
-
----------------------------------------------------------*/
#if defined(EXAMPLE001)

void main( void )
{
   VioInit();
}

/*----------------------------------------------------------
-
----------------------------------------------------------*/
#if defined(EXAMPLE002)

void main( void )
{
   int i;

   VioInit();
   ClrWin( 1, 1, 80, 25, 7 );
   for ( i = 0; i < 16; i++ ) {
      DspMsg( 1, i+1, "                                      " );
      BorderColor( i );
      ColorMsg( 1, i+2, i+1, "Press any key to see next border color" );
      GotoxyAbs( 1, i+2 );
      GetKey();
   }
   BorderColor( 0 );
   ClrWin( 1, 1, 80, 25, 7 );
   GotoxyAbs( 1, 1 );
}

/*----------------------------------------------------------
-
----------------------------------------------------------*/
#elif defined(EXAMPLE003)

char TCSet[32] = {  0,101,  0,0,0,0, 0,24,
                   57,213,192,0,0,0,95, 0,
                    8,  0,  0,0,0,0, 0, 0,
                    0,  0,  0,0,0,0, 0, 0
                 };

char VCSet[32] = {   0,  0,  0,  0,255,255,255,255,
                   255,255,255,255,255,255,255,255,
                   255,255,255,255,255,255,255,255,
                   255,255,255,255,255,255,255,255
                 };

char *prompt = "Enter name:";

void main( void )
{
   char  st[256];
   int   x1       = 1;
   int   y1       = 1;
   int   stpt     = ( x1 + 20 ) - (strlen( prompt ) / 2);
   int   CharOfs  = 1;
   int   TE       = 0;
   int   WinColor = 0x17;

   VioInit();

   memset( st, 0, 256 );
   ClrWin( 1, 1, 80, 25, 7 );


   ClrWin( x1, y1, x1+40, y1+5, WinColor);
   WindowFP( x1, y1, x1+40, y1+5 );
   FrameWin( '', '', '', '', '', '', WinColor );

   WindowFP( x1+1, y1+2, x1+39, y1+4 );
   FrameWin( '', '', '', '', '', '', WinColor );

   ColorMsg( stpt, y1+1, WinColor, prompt );

   EditSt( y1+3,          // Row
           x1+2,          // Start Column
           x1+38,         // Stop Column
           40,            // Length
           1,             // Character Case Mode
           7,             // Fill Character
           0,             // Auto Skip Mode
           7000,          // Error Tone
           2000,          // Error Duration
           VCSet,         // Valid Character Set
           TCSet,         // Terminating Character Set
           &CharOfs,      // Cursor Position in string being edited
           &TE,           // Terminating Element Value
           st );          // String being edited

   GotoxyAbs( x1, y1+6 );
   WriteSt( "Prompt entered: ***" );
   WriteSt( st );
   WriteStln( "***" );
}

/*----------------------------------------------------------
-
----------------------------------------------------------*/
#elif defined(EXAMPLE004)

void main( void )
{
   int   x1       = 1;
   int   y1       = 1;
   int   WinColor = 0x17;

   VioInit();

   ClrWin( 1, 1, 80, 25, 7 );
   GotoxyAbs( 1, 1 );

   ClrWin( x1, y1, x1+40, y1+10, WinColor);
   WindowFP( x1, y1, x1+40, y1+10 );
   FrameWin( '', '', '', '', '', '', WinColor );

   FillRowChar( x1+40, y1+1, 1, 0x18 );
   FillColChar( x1+40, y1+2, 7, ''  );

   FillColAttr( x1+40, y1+2, 7, 0x18 );
   FillRowChar( x1+40, y1+9, 1, 0x19 );
}


/*----------------------------------------------------------
-
----------------------------------------------------------*/
#elif defined(EXAMPLE005)

void main( void )
{
   int   x1       = 1;
   int   y1       = 1;
   int   WinColor = 0x17;

   VioInit();

   ClrWin( 1, 1, 80, 25, 7 );
   GotoxyAbs( 1, 1 );

   ClrWin( x1, y1, x1+40, y1+10, WinColor);
   WindowFP( x1, y1, x1+40, y1+10 );
   FrameWin( '', '', '', '', '', '', WinColor );

   FillRowChar( x1+40, y1+1, 1, 0x18 );
   FillColCell( x1+40, y1+2, 7, 0xb118 );  // (177 - char) (0x18 - attrib)
   FillRowChar( x1+40, y1+9, 1, 0x19 );
}

/*----------------------------------------------------------
-
----------------------------------------------------------*/
#elif defined(EXAMPLE006)

void main( void )
{
   int   i;
   int   x1       = 1;
   int   y1       = 1;
   int   WinColor = 0x17;

   VioInit();

   ClrWin( 1, 1, 80, 25, 7 );
   GotoxyAbs( 1, 1 );

   ClrWin( x1, y1, x1+40, y1+10, WinColor);
   WindowFP( x1, y1, x1+40, y1+10 );
   FrameWin( '', '', '', '', '', '', WinColor );

   for ( i = y1+1; i <= y1+9; i++ )
      DspMsg( x1+1, i, "This is an example message" );

   DspMsg( x1+2, y1+10, "Press any key to continue" );
   GetKey();
   FillFrameChar( x1+1, y1+1, x1+39, y1+9, '' );

   DspMsg( x1+2, y1+10, "Press enter to continue  " );
   GetKey();
   FillFrameAttr( x1+1, y1+1, x1+39, y1+9, RvsAttr( WinColor ) );

   DspMsg( x1+2, y1+10, "Press enter to quit      " );
   GetKey();
}

/*----------------------------------------------------------
-
----------------------------------------------------------*/
#elif defined(EXAMPLE007)

void main( void )
{
   int   i;
   int   x1       = 1;
   int   y1       = 1;
   int   WinColor = 0x17;

   VioInit();

   ClrWin( 1, 1, 80, 25, 7 );
   GotoxyAbs( 1, 1 );

   ClrWin( x1, y1, x1+40, y1+10, WinColor);
   WindowFP( x1, y1, x1+40, y1+10 );
   FrameWin( '', '', '', '', '', '', WinColor );

   for ( i = y1+1; i <= y1+9; i++ )
      DspMsg( x1+1, i, "This is an example message" );

   DspMsg( x1+2, y1+10, "Press any key to continue" );
   GetKey();
   FillFrameCell( x1+1, y1+1, x1+39, y1+9, 0xb100 + RvsAttr( WinColor ) );

   DspMsg( x1+2, y1+10, "Press enter to quit      " );
   GetKey();
}

/*----------------------------------------------------------
-
----------------------------------------------------------*/
#elif defined(EXAMPLE008)

void main( void )
{
   int   x1       = 20;
   int   y1       = 5;
   int   WinColor = 0x17;

   VioInit();

   ClrWin( 1, 1, 80, 25, 7 );
   GotoxyAbs( 1, 1 );

   FillRowChar( 1, 1, 2000, ''  );
   FillRowAttr( 1, 1, 2000, 0x17 );

   ClrWin( x1, y1, x1+40, y1+10, WinColor);
   WindowFP( x1, y1, x1+40, y1+10 );
   FrameWin( '', '', '', '', '', '', WinColor );

   FillColAttr( x1+41, y1+1,  10, 0x00 );
   FillRowAttr( x1+1,  y1+11, 41, 0x00 );

   DspMsg( x1+1, y1+1, "Press any key to continue..." );
   GetKey();

   ClrWin( 1, 1, 80, 25, 7 );
   GotoxyAbs( 1, 1 );
}

/*----------------------------------------------------------
-
----------------------------------------------------------*/
#elif defined(EXAMPLE009)

void main( void )
{
   int   x1       = 20;
   int   y1       = 5;
   int   WinColor = 0x17;

   VioInit();

   ClrWin( 1, 1, 80, 25, 7 );
   GotoxyAbs( 1, 1 );

   FillRowCell( 1, 1, 2000, 0xb100 + WinColor );

   ClrWin( x1, y1, x1+40, y1+10, WinColor);
   WindowFP( x1, y1, x1+40, y1+10 );
   FrameWin( '', '', '', '', '', '', WinColor );

   FillColAttr( x1+41, y1+1,  10, 0x00 );
   FillRowAttr( x1+1,  y1+11, 41, 0x00 );

   DspMsg( x1+1, y1+1, "Press any key to continue..." );
   GetKey();

   ClrWin( 1, 1, 80, 25, 7 );
   GotoxyAbs( 1, 1 );
}

/*----------------------------------------------------------
-
----------------------------------------------------------*/
#elif defined(EXAMPLE010)

void main( void )
{
   char  st[20];
   INT2  cursor;


   VioInit();

   ClrWin( 1, 1, 80, 25, 7 );
   GotoxyAbs( 1, 1 );

   cursor = GetCursorSize();

   sprintf( st, "Starting Scan Line: %d", ( cursor >> 8 ) );
   WriteStln( st );

   sprintf( st, "Ending Scan Line  : %d", ( cursor & 0x00FF ) );
   WriteStln( st );

   WriteStln( "Press any key to continue..." );
   GetKey();

   ClrWin( 1, 1, 80, 25, 7 );
   GotoxyAbs( 1, 1 );
}


#endif
