#include <fpclib.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <conio.h>

#define NUMBER_WINDOWS 6

void OpeningScreen( void );
void DisplayWindows( void );
void GetAltCtrlShft( void );
void DetectToggleKeys( void );
void DisplayVideoInformation( void );
void UseEditSt( void );
void DisplayRvsAttrScreen( void );
void CheckMouse( void );
void IntStr( int Num, int NDigits, char *St );

char ColorTbl[2][256] = {
                               0,  1,  2,  3,  4,  5,  6,  7,  8,  9,
                              10, 11, 12, 13, 14, 15, 16, 17, 18, 19,
                              20, 21, 22, 23, 24, 25, 26, 27, 28, 29,
                              30, 31, 32, 33, 34, 35, 36, 37, 38, 39,
                              40, 41, 42, 43, 44, 45, 46, 47, 48, 49,
                              50, 51, 52, 53, 54, 55, 56, 57, 58, 59,
                              60, 61, 62, 63, 64, 65, 66, 67, 68, 69,
                              70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
                              80, 81, 82, 83, 84, 85, 86, 87, 88, 89,
                              90, 91, 92, 93, 94, 95, 96, 97, 98, 99,
                             100,101,102,103,104,105,106,107,108,109,
                             110,111,112,113,114,115,116,117,118,119,
                             120,121,122,123,124,125,126,127,128,129,
                             130,131,132,133,134,135,136,137,138,139,
                             140,141,142,143,144,145,146,147,148,149,
                             150,151,152,153,154,155,156,157,158,159,
                             160,161,162,163,164,165,166,167,168,169,
                             170,171,172,173,174,175,176,177,178,179,
                             180,181,182,183,184,185,186,187,188,189,
                             190,191,192,193,194,195,196,197,198,199,
                             200,201,202,203,204,205,206,207,208,209,
                             210,211,212,213,214,215,216,217,218,219,
                             220,221,222,223,224,225,226,227,228,229,
                             230,231,232,233,234,235,236,237,238,239,
                             240,241,242,243,244,245,246,247,248,249,
                             250,251,252,253,254,255,

                               0,  1,  2,  3,  4,  5,  6,  7,  8,  9,
                              10, 11, 12, 13, 14, 15, 16, 17, 18, 19,
                              20, 21, 22, 23, 24, 25, 26, 27, 28, 29,
                              30, 31, 32, 33, 34, 35, 36, 37, 38, 39,
                              40, 41, 42, 43, 44, 45, 46, 47, 48, 49,
                              50, 51, 52, 53, 54, 55, 56, 57, 58, 59,
                              60, 61, 62, 63, 64, 65, 66, 67, 68, 69,
                              70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
                              80, 81, 82, 83, 84, 85, 86, 87, 88, 89,
                              90, 91, 92, 93, 94, 95, 96, 97, 98, 99,
                             100,101,102,103,104,105,106,107,108,109,
                             110,111,112,113,114,115,116,117,118,119,
                             120,121,122,123,124,125,126,127,128,129,
                             130,131,132,133,134,135,136,137,138,139,
                             140,141,142,143,144,145,146,147,148,149,
                             150,151,152,153,154,155,156,157,158,159,
                             160,161,162,163,164,165,166,167,168,169,
                             170,171,172,173,174,175,176,177,178,179,
                             180,181,182,183,184,185,186,187,188,189,
                             190,191,192,193,194,195,196,197,198,199,
                             200,201,202,203,204,205,206,207,208,209,
                             210,211,212,213,214,215,216,217,218,219,
                             220,221,222,223,224,225,226,227,228,229,
                             230,231,232,233,234,235,236,237,238,239,
                             240,241,242,243,244,245,246,247,248,249,
                             250,251,252,253,254,255
                        };

char WinTbl[NUMBER_WINDOWS][5] = {
                                    1,  1, 40, 10,  16,
                                    4,  4, 43, 13,  36,
                                    7,  7, 46, 16,  56,
                                   10, 10, 49, 19,  76,
                                   13, 13, 52, 21,  96,
                                   16, 16, 55, 23, 116
                                 };

char Digits[17] = "0123456789ABCDEF";

char TCSet[32] = {   0,   7,   0,   0,   0,   0,   0,   0,
                     0,   0,   0,   0,   0,   0,   0,   0,
                     0,   0,   0,   0,   0,   0,   0,   0,
                     0,   0,   0,   0,   0,   0,   0,   0
                 };
char VCSet[32] = {   0,   0,   0,   0, 255, 255, 255, 255,
                   255, 255, 255, 255, 255, 255, 255, 255,
                   255, 255, 255, 255, 255, 255, 255, 255,
                   255, 255, 255, 255, 255, 255, 255, 255
                 };


char  Buffer[4000],CTbl[256];
int   i,x,y;
char  FnKeyBuf[4][320];

/*----------------------------------------------------------------*/
/*                                                                */
/*----------------------------------------------------------------*/

void OpeningScreen( void )
{
   int i;

   ClrWin( 1, 1, 80, 25, CTbl[7] );
   WindowFP( 1, 1, 80, 25 );
   FrameWin( '', '', '', '', '', '', CTbl[2] );

   ColorMsg( 20,  4, CTbl[1], "            FlashPac C Library           " );
   ColorMsg( 20,  6, CTbl[2], "               Version 3.10              " );
   ColorMsg( 20,  8, CTbl[3], "               Demo Program              " );
   ColorMsg( 20, 15, CTbl[4], "              SimpleSoft Inc.            " );
   ColorMsg( 20, 16, CTbl[4], "              1209 Poplar St             " );
   ColorMsg( 20, 17, CTbl[4], "          La Crescent, MN 55947          " );
   ColorMsg( 20, 18, CTbl[4], "                                         " );
   ColorMsg( 19, 22, CTbl[4], "(c) Copyright 1986-89 - All Rights Reserved");
   ColorMsg( 20, 24, CTbl[5], "       Press any key to continue...      " );

   while ( !DosKbdHit() ) {
      FillRowAttr( 20,  4, 41, CTbl[9]  );
      FillRowAttr( 20,  6, 41, CTbl[10] );
      FillRowAttr( 20,  8, 41, CTbl[11] );
      FillRowAttr( 20, 15, 41, CTbl[12] );
      FillRowAttr( 20, 16, 41, CTbl[12] );
      FillRowAttr( 20, 17, 41, CTbl[12] );
      FillRowAttr( 20, 18, 41, CTbl[12] );
      FillRowAttr( 19, 22, 43, CTbl[13] );

      for ( i = 0; i < 10000; i++ )
      ;

      FillRowAttr( 20,  4, 41, CTbl[1] );
      FillRowAttr( 20,  6, 41, CTbl[2] );
      FillRowAttr( 20,  8, 41, CTbl[3] );
      FillRowAttr( 20, 15, 41, CTbl[4] );
      FillRowAttr( 20, 16, 41, CTbl[4] );
      FillRowAttr( 20, 17, 41, CTbl[4] );
      FillRowAttr( 20, 18, 41, CTbl[4] );
      FillRowAttr( 19, 22, 43, CTbl[5] );

      for ( i = 0; i < 10000; i++ )
      ;
   }
}

/*----------------------------------------------------------------*/
/*                                                                */
/*----------------------------------------------------------------*/

void DisplayWindows( void )
{
   char  St[80];
   int   i,j;

   ClrWin( 1, 1, 80, 25, CTbl[7] );

   for ( i = 0; i < NUMBER_WINDOWS; i++ ) {
      WindowFP( WinTbl[i][0], WinTbl[i][1], WinTbl[i][2], WinTbl[i][3] );
      ClrWin( WinTbl[i][0], WinTbl[i][1], WinTbl[i][2], WinTbl[i][3], WinTbl[i][4] );
      FrameWin( '', '', '', '', '', '', CTbl[ WinTbl[i][4] ] );

      strcpy( St, "Window - " );
      itoa( i, &St[9], 10 );
      DspMsg( WinTbl[i][0]+2, WinTbl[i][1]+1, St );
      for ( j = 0; j < 15000; j++ )
      ;
   }

   ColorMsg( 20, 25, CTbl[96], "       Press any key to continue...      " );
   DosKbdClr();
   GetKey();
}

/*----------------------------------------------------------------*/
/*                                                                */
/*----------------------------------------------------------------*/

void GetAltCtrlShft( void )
{
   ClrWin( 1, 1, 80, 25, CTbl[7] );

   ColorMsg( 10, 15, CTbl[4], " I will use GetScrn to read the normal lines " );
   ColorMsg( 10, 16, CTbl[5], "        Press any key to continue...         " );
   ColorMsg(  1,  1, CTbl[6], "F1-Normal        F2-Normal        F3-Normal        F4-Normal        F5 -Normal" );
   ColorMsg(  1,  2, CTbl[6], "F6-Normal        F7-Normal        F8-Normal        F9-Normal        F10-Normal" );
   GetScrn(   1,  1, 160,     FnKeyBuf[0] );
   DosKbdClr();
   GetKey();

   ColorMsg( 10, 15, CTbl[4], "I will use GetScrn to read the Shft lines    " );
   ColorMsg( 10, 16, CTbl[5], "        Press any key to continue...         " );
   ColorMsg(  1,  1, CTbl[6], "F1-Shft          F2-Shft          F3-Shft          F4-Shft          F5 -Shft  " );
   ColorMsg(  1,  2, CTbl[6], "F6-Shft          F7-Shft          F8-Shft          F9-Shft          F10-Shft  " );
   GetScrn(   1,  1, 160,     FnKeyBuf[1] );
   DosKbdClr();
   GetKey();

   ColorMsg( 10, 15, CTbl[4], "I will use GetScrn to read the Ctrl lines    " );
   ColorMsg( 10, 16, CTbl[5], "        Press any key to continue...         " );
   ColorMsg(  1,  1, CTbl[6], "F1-Ctrl          F2-Ctrl          F3-Ctrl          F4-Ctrl          F5 -Ctrl  " );
   ColorMsg(  1,  2, CTbl[6], "F6-Ctrl          F7-Ctrl          F8-Ctrl          F9-Ctrl          F10-Ctrl  " );
   GetScrn(   1,  1, 160,     FnKeyBuf[2] );
   DosKbdClr();
   GetKey();

   ColorMsg( 10, 15, CTbl[4], "I will use GetScrn to read the Alt lines     " );
   ColorMsg( 10, 16, CTbl[5], "        Press any key to continue...         " );
   ColorMsg(  1,  1, CTbl[6], "F1-Atl           F2-Alt           F3-Alt           F4-Alt           F5 -Alt   " );
   ColorMsg(  1,  2, CTbl[6], "F6-Alt           F7-Alt           F8-Alt           F9-Alt           F10-Alt   " );
   GetScrn(   1,  1, 160,     FnKeyBuf[3] );
   DosKbdClr();
   GetKey();
}

/*----------------------------------------------------------------*/
/*                                                                */
/*----------------------------------------------------------------*/

void DetectToggleKeys( void )
{
   int  i,Index;

   ClrWin( 1, 1, 80, 25, CTbl[7] );
   WindowFP( 8, 1, 55, 12);
   FrameWin( '', '', '', '', '', '', CTbl[15] );

   ColorMsg( 10, 3, CTbl[23], "             BiosKbdStat                     " );
   ColorMsg( 10, 5, CTbl[10], " Pressing the Alt, Shft or Ctrl Toggle Keys  " );

   FillRowAttr( 24, 5, 3, CTbl[64] );
   FillRowAttr( 29, 5, 4, CTbl[65] );
   FillRowAttr( 37, 5, 4, CTbl[66] );

   ColorMsg( 10,  6, CTbl[10], " will display the function key lines at the  " );
   ColorMsg( 10,  7, CTbl[10], " bottom of the screen.  The lines that are   " );
   ColorMsg( 10,  8, CTbl[10], " being used were just saved using GetScrn    " );
   ColorMsg( 10,  9, CTbl[10], " in the preceeding step.                     " );
   ColorMsg( 10, 11, CTbl[48], "        Press <ENTER> to continue...         " );

   for ( i = 0; i != 13;   ) {
      while ( !DosKbdHit() ) {
         i = BiosKbdStat();
         Index = 0;
         if ( i & 3 )      Index = 1;
         else if ( i & 4 ) Index = 2;
         else if ( i & 8 ) Index = 3;

         PutScrn( 1, 24, 160, FnKeyBuf[Index] );
      }
      i = GetKey();
   }
}

/*-------------------------------------------------------------*/
/* returns a string of length n                                */
/*-------------------------------------------------------------*/

void IntStr( Num, NDigits, St )
int   Num,NDigits;
char  St[];
{
   int i;

   for ( i = NDigits-1; i >= 0; i-- ) {
      St[i] = (char) (Num % 10 + 48);
      Num /= 10;
   }
}

/*----------------------------------------------------------------*/
/*                                                                */
/*----------------------------------------------------------------*/

void DisplayVideoInformation( void )
{
   char  St[256];

   ClrWin( 1, 1, 80, 25, CTbl[7] );
   WindowFP( 24, 9, 57, 17 );
   ClrWin( 24, 9, 57, 17, CTbl[48] );
   FrameWin( '', '', '', '', '', '', 48 );

   ColorMsg( 26, 9, CTbl[48], " GetVideoInfo " );

   strcpy( St, " Current mode         = " );
   itoa( GetVideoMode(), &St[24], 10 );
   ColorMsg( 25, 10, CTbl[48], St );

   strcpy( St, " Active mode          = " );
   itoa( GetVideoPage(), &St[24], 10 );
   ColorMsg( 25, 11, CTbl[48], St );

   strcpy( St, " Number cols          = " );
   itoa( GetVideoCols(), &St[24], 10 );
   ColorMsg( 25, 12, CTbl[48], St );

   strcpy( St, " Base Segment Address = " );
   itoa( VioBaseSeg, &St[24], 16 );
   ColorMsg( 25, 13, CTbl[48], St );

   ColorMsg( 25, 16, CTbl[48], " Press any key to continue..." );
   GetKey();
}

/*----------------------------------------------------------------*/
/*                                                                */
/*----------------------------------------------------------------*/

void UseEditSt( void )
{
   CHAR  St[256];
   INT2  ChOfs = 1,
   	 TE    = 0;

   ClrWin( 1, 1, 80, 25, CTbl[7] );
   WindowFP( 8, 8, 50, 14 );
   FrameWin( '', '', '', '', '', '', CTbl[48] );

   ColorMsg( 10, 10, CTbl[7],  "Enter your name:" );
   ColorMsg(  9, 12, CTbl[48], "          Press <ENTER> to Quit          " );

   memset( St, '\0', 256 );

   EditSt( 10, 28, 48, 50, 1, 7, 0, 7000, 2000,
           (VOID *) VCSet, (VOID *)TCSet, &ChOfs, &TE, (VOID *) St );

   ClrWin( 1, 1, 80, 25, CTbl[7] );
   WindowFP( 5, 8, 75, 14 );
   FrameWin( '', '', '', '', '', '', CTbl[48] );

   GotoxyAbs( 7, 10 );
   printf( "Length of Input string returned = %u characters", strlen( St ) );
   GotoxyAbs( 7, 12 );
   printf( "Input string = *%s*", St );
   ColorMsg( 20, 20, CTbl[6], "    Press any key to continue...    " );
   GetKey();
}

/*----------------------------------------------------------------*/
/*                                                                */
/*----------------------------------------------------------------*/

void DisplayRvsAttrScreen( void )
{
   char  St[256];
   int   i,j,HiCur,LoCur,k = 0;


   HiCur = ( VioCursor >> 8 );
   LoCur = ( VioCursor & 0xff );

   SetCursorSize( 32, 32 );
   ClrWin( 1, 1, 80, 25, CTbl[7] );

   WindowFP( 5, 2, 40, 19 );
   FrameWin( '', '', '', '', '', '', CTbl[7] );
   ColorMsg( 7, 2, CTbl[7], " Text with normal attributes " );

   WindowFP( 45, 2, 80, 19 );
   FrameWin( '', '', '', '', '', '', CTbl[7] );
   ColorMsg( 47,  2, CTbl[7], " Text with reverse attributes " );
   ColorMsg( 30, 23, CTbl[6], "    Press <ESC> to skip...    " );

   for ( j = 0; j <= 16; j++ ) {
      ClrWin(  6, 3, 39, 18, CTbl[7] );
      ClrWin( 46, 3, 79, 18, CTbl[7] );
      for ( i = 0; i < 16; i++ ) {

         TextAttr = (BYTE) k;
         strcpy( St, "        TextAttr =                " );
         IntStr( TextAttr, 3, &St[19] );
         ColorMsg( 6, i+3, TextAttr, St );

         TextAttr = (BYTE) RvsAttr( TextAttr );
         strcpy( St, "        TextAttr =                " );
         IntStr( TextAttr, 3, &St[19] );
         ColorMsg( 46, i+3, TextAttr, St );
         k++;
      }
      for ( i = 0; i < 15000; i++ )
      ;


      if ( BiosKbdHit() )
         if ( GetKey() == 1 )
            j = 16;
   }
   TextAttr = 6;
   SetCursorSize( LoCur, HiCur );
}

/*----------------------------------------------------------------*/
/*                                                                */
/*----------------------------------------------------------------*/

void CheckMouse( void )
{
   INT2 NBut;

   ClrWin( 1, 1, 80, 25, CTbl[7] );

   WindowFP( 8, 10, 48, 15 );
   FrameWin( '', '', '', '', '', '', CTbl[7] );

   if ( !MResetMouse( &NBut ) )
      ColorMsg( 10, 12, CTbl[6], "Mouse NOT installed on your computer" );
   else {
      ColorMsg( 10, 12, CTbl[6], "You have a mouse in your computer" );
      ColorMsg( 10, 13, CTbl[7], "Squeak Squeak Squeak"              );
   }

   GetKey();
}

/*-------------------- Main Line ------------------------*/

void main( void )
{
   int i,x,y;

   VioInit();

   GetScrn( 1, 1, 2000, Buffer );
   x = WhereXAbs();
   y = WhereYAbs();
   i = 0;
   if ( VioMode == 7 )
      i = 1;
   memcpy( CTbl, ColorTbl[i], sizeof( CTbl ) );

   OpeningScreen();
   DisplayWindows();
   GetAltCtrlShft();
   DetectToggleKeys();
   DisplayVideoInformation();
   UseEditSt();
   DisplayRvsAttrScreen();
   CheckMouse();
   PutScrn( 1, 1, 2000, Buffer );
   GotoxyAbs( x, y );
}

