BOUNDING BOX DATA COMPRESSION
by Glenn Searfoss

/* FONT1 STRUCTURE DEFINITIONS */

struct font1head {  /* standard character font header */
   unsigned char fnttype;     /* font structure type: */
     /* non-compressed type = 0x16 or compressed type = 0x14 */
   char fntname[13];   /* font name: always followed with a '.set'
extension */
   unsigned char fntcheck; /* check digit: verifies a Data
Transforms font: */
        /* non-compressed font = 0xba, compressed font = 0xdc */
   unsigned char fntbase; 
                  /* baseline count (in pixels) from top to bottom,
top = 0 */
   unsigned char fnttotal; /* total characters in font:*/
        /* limited to the lower 94 ASCII characters: 0x21 - 0x7E
*/
   unsigned char fntstart;    /* starting character */
   unsigned char fntstatus; /* proportional or non-proportional:
0=non-prop.*/
   unsigned char fnthsize;     /* horizontal cell size in pixels
*/
   unsigned char fntvsize;     /* vertical cell size in pixels */
   unsigned char fntbytes;     /* number of horizontal bytes in
current cell */
   unsigned char fntspaceh;    /* space bar horizontal size in
pixels */
   unsigned char fntchargap;   /* pixels between characters default
*/
   unsigned char fntlfgap;     /* pixels between linefeeds default
*/
   int fntlength;          /* total length of file */
   unsigned char fntpitch;     /* italics pitch (0 = none) */
          /* bits 0 - 6 ... number of scanlines to skip */
          /* bit  7 ... 0 = decrement xpos, 1 = increment xpos */
   unsigned char fntinvert;   /* 0 = dont invert, 1 = invert */
   unsigned char fnthbold;    /* number of overlapping bits
horizontal */
   unsigned char fntvbold;    /* number of overlapping bits
vertical */
   unsigned char fnthmag;     /* integral horizontal bit
magnification */
   unsigned char fntvmag;     /* integral vertical bit
magnification */
   unsigned char fnthfract;   /* fractional horizontal bit
magnification */
   unsigned char fntvfract;   /* fractional vertical bit
magnification */
   unsigned char fntdirection;     
                       /* Print direction 0=left to
right,1..3=counterclock */
   unsigned char fntrot90;    /* rotation 0=up, 1..3=counterclock
1...3 */
   unsigned char fnthflip;    /* horizontal flip 0 = no, 1 = yes
*/
   unsigned char fntvflip;    /* vertical flip 0 = no, 1 = yes */
   unsigned char fntcolor;    /* color of font */
              /* bits 0 - 3 ... foreground color */
              /* bit 0 ... strike black ribbon */
           /* bit 1 ... strike blue ribbon */
              /* bit 2 ... strike red ribbon */
              /* bit 3 ... strike yellow ribbon */
              /* bits 4 - 7 ... background color */
              /* bit 4 ... strike black ribbon */
              /* bit 5 ... strike blue ribbon */
              /* bit 6 ... strike red ribbon */
              /* bit 7 ... strike yellow ribbon */
   unsigned char fntsubtype;  /* subcategory type of this font */
              /* 0 = normal font subtype */
              /* 1 = equation roman font subtype */
              /* 2 = equation symbol font subtype */
   unsigned char fntunused[18];    /* unused bytes */
};

struct font1 { /* standard character font (type = 0x16) */
   struct font1head fhd; /* font header */
   char *fntcellptr[FONT1TOTAL + 1]; 
                     /* offsets from beginning of file to character
bitmaps */
   char fntcellwidth[FONT1TOTAL + 1];   /* cell widths if
proportional */
};



