/**-------------------------------------------------------**/
/**  MAPS.C       Copyright (C) 1991, Steve Jackson       **/
/**			(requires TCVIDEO.C)		  **/
/**-------------------------------------------------------**/

#include <ctype.h>              /* for isascii macro in getchoice() */
#include "maps.h"
#include "tcvideo.h"

void blankpad();		/* used internally only */

#define BLANK 32                /* ASCII blank */
#define NULL 0

int 	MapQuiet = 0;		/*  Global switch user can change */
int 	MapDataChanged = 0;	/*  Global for information after mapin() */

/*  Global variables for map colors, can be changed in user program */
int MapColorNorm = 7;	/*  WHITE on BLACK */
int MapColorData = 15;  /*  BRIGHT WHITE on BLACK */
int MapColorEdit = 112; /*  BLACK on WHITE */

/*
 *    Mapout	- display a screen of data
 */
void  Mapout(mf, mm)
	struct Mapfields  *mf;
	struct Mapmsgs    *mm;
{
	/*--------- for each data field, pad field with blanks------- */
	/*-------------- and put in screen buffer --------------------*/
	while ( !mf->mapfields_end) {
		blankpad( mf->fld, mf->fleng);
		Vidtext(mf->frow,
			mf->fcol,
			MapColorData,
			mf->fld);
		mf++;
	}
	/*------ for each msg field, put it in the screen buffer ------*/
	if ( mm )
	while ( !mm->mapmsgs_end ) {
		Vidtext(mm->mrow,
			mm->mcol,
			MapColorNorm,
			mm->msg);
		mm++;
	}

	/*--------- flush the screen buffer to vidio display ------------*/
	/*** Not implemented at this time - may add this later ****/
	/*** Vidbufgo(); ***/
}

/*
 *    blankpad	  pad a field with blanks for length n, then add null
 */
void  blankpad( field, leng)
	char  field[];
	int   leng;
{
	register k;

	k = 0;
	leng--;			/* adjust so we do not blank NULL */
	while (field[k] != 0)
		k++;

	for ( ; k<leng; k++)
		field[k] = BLANK;
	field[k] = 0;		/* end of string delimiter in C */
	return;
}

/*
 *    Mapin 	- collect a screen of data
 *		  return the fields in the map field structure
 *		  and return the terminating keystroke
 */
int   Mapin(mf)
	struct Mapfields *mf;
{
	int  keystroke;
	int  i;

	MapDataChanged = 0;
	i = 0;
	while ( !mf->mapfields_end ) {	 /* For Each Field in the MAP */
		Cursput(mf->frow,	/* cursor on current field */
			mf->fcol );
		Vidtext(mf->frow,	/* display current field */
			mf->fcol,
			MapColorEdit,	/* highlighted */
			mf->fld);

		/*  edit the current field */
		keystroke = Videditfield( mf->fld,
				       mf->fleng,
				       MapColorEdit);
		if (Videditchanged)
			MapDataChanged = 1;

		/*  redisplay the field normal after edit */
		Vidtext(mf->frow,
			mf->fcol,
			MapColorData,
			mf->fld);

		/* check the keystroke, go to next or prior field */
		/* or quit if it is an unknown keystroke */
		switch ( keystroke ) {
			case  K_ENTER:
			case  K_RTAB:
			case  K_DOWN:
				mf++;
				i++;
				break;
			case  K_ESC:
				return (keystroke);
			case  K_LTAB:
			case  K_UP:
				if (i) {
					mf--;
					i--;
				}
				break;
			default:
				return (keystroke);
		}
    } /* end of while */
    return (keystroke);
}

