
/*	fnqual.c  source code for fnqual() */


/******************************************************************************

    NAME	fnqual - gives a fully qualified file name given
		an unqualified file name

    USAGE	#include "fnqual.h"
		int fnqual(char *qual, char *unqual);

    PROTOTYPE	fnqual.h

    DESCRIPTION	Fnqual gives a pointer to fully qualified file name
		given a pointer to an unqualified file name.
		Fnqual returns _doserrno.

		The function call looks like this:
		success = fnqual(qual, unqual)
		where: 	int success
			char *qual (pointer to the qualified file name)
			char *unqual (pointer to the unqualified file name)

		See the test program included in this file for
		an example usage.

    RETURNS	_doserrno

    NOTE	Fnqual uses an undocumented (or reserved) call (0x60) to
		do the work.  This call works for DOS 3.x and higher.

    PORTABILITY	MS-DOS specific, Turbo-C specific

    AUTHOR	Jim Drash
		Software Development and Consulting
		2256 Beechmont Avenue
		Cincinnati, OH, 45230
		Compuserve ID: 76607,70

******************************************************************************/

#include <dos.h>
#define DOS_FUNCTION 0x21
#define DOS_QUAL_FILE_NAME 0x60

int fnqual(qual, unqual)
char *qual;
char *unqual;
{
    unsigned int save_ds, save_si, save_es, save_di;

    save_ds = _DS;
    save_si = _SI;
    save_es = _ES;
    save_di = _DI;

    _DS = FP_SEG(unqual);
    _SI = FP_OFF(unqual);

    _ES = FP_SEG(qual);
    _DI = FP_OFF(qual);

    _AH = DOS_QUAL_FILE_NAME;

    geninterrupt(DOS_FUNCTION);

    _DS = save_ds;
    _SI = save_si;
    _ES = save_es;
    _DI = save_di;

    return(_doserrno);
}


/* #define TEST 1 */

#ifdef TEST

#include <stdio.h>

main(int argc, char *argv[])
{
    int i;
    char qual[80];

    for (i = 0; i < argc; i++)
	{
	if (fnqual(qual, argv[i]) == 0)
		printf("argv[%d]: %s, qualified: %s\n", i, argv[i], qual);
	else
		perror(argv[i]);
	}

}
#endif
