// FMTTEST.CPP

#include <windows.h>
#include <owl.h>
#include <edit.h>
#include "fmtinput.h"

class TMyWindow : public TDialog {
   public:
      TMyWindow(LPSTR);
   };

class TMyApp :public TApplication {
   public:
      TMyApp(LPSTR AName, HINSTANCE hInstance, HINSTANCE hPrevInstance,
           LPSTR lpCmdLine, int nCmdShow);
      virtual void InitMainWindow();
      TStatic* DateLabel;
      DateInput* aDateInput;
      TStatic* Time12Label;
      TimeInput* aTime12Input;
      TStatic* Time24Label;
      TimeInput* aTime24Input;
      TStatic* PictLabel;
      PictInput* aPictInput;
      TStatic* PhoneLabel;
      PhoneInput* aPhoneInput;
      TStatic* SFltLabel;
      SFltInput* aSFltInput;
      TStatic* UFltLabel;
      UFltInput* aUFltInput;
      TStatic* SIntLabel;
      SIntInput* aSIntInput;
      TStatic* UIntLabel;
      UIntInput* aUIntInput;
};

int PASCAL WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance,
  LPSTR lpCmdLine, int nCmdShow)
{
  TMyApp myApp ("Format Input Test", hInstance, hPrevInstance,
    lpCmdLine, nCmdShow);
  myApp.Run();
  return myApp.Status;
}

TMyWindow::TMyWindow(LPSTR aDlg)
            : TDialog(NULL,aDlg)
   {
   }

void TMyApp::InitMainWindow()
   {
   MainWindow = new TDialog(NULL, 101);
   DateLabel = new TStatic(MainWindow,101,"DateInput",50,25,75,25,10);
   aDateInput = new DateInput(MainWindow,100,150,25,75,25,9);
   Time12Label = new TStatic(MainWindow,111,"12Hr Time",50,75,75,25,10);
   aTime12Input = new TimeInput(MainWindow,110,150,75,75,25,9);
   Time24Label = new TStatic(MainWindow,121,"24Hr Time",50,125,75,25,10);
   aTime24Input = new TimeInput(MainWindow,120,150,125,75,25,6,TRUE);
   PictLabel = new TStatic(MainWindow,131,"Picture",50,175,75,25,10);
   aPictInput = new PictInput(MainWindow,130,150,175,100,25,
                       "(   )   -    ","(###)999-9999",15);
   PhoneLabel = new TStatic(MainWindow,141,"Phone #",50,225,75,25,10);
   aPhoneInput = new PhoneInput(MainWindow,140,150,225,100,25);
   SFltLabel = new TStatic(MainWindow,151,"Signed Flt",50,275,75,25,10);
   aSFltInput = new SFltInput(MainWindow,150,"0.0",150,275,100,25,20);
   UFltLabel = new TStatic(MainWindow,161,"Unsign Flt",50,325,75,25,10);
   aUFltInput = new UFltInput(MainWindow,160,"0.0",150,325,100,25,20);
   SIntLabel = new TStatic(MainWindow,171,"Signed Int",50,375,75,25,10);
   aSIntInput = new SIntInput(MainWindow,170,"0",150,375,100,25,20);
   UIntLabel = new TStatic(MainWindow,181,"Unsign Int",50,425,75,25,10);
   aUIntInput = new UIntInput(MainWindow,180,"0",150,425,100,25,20);
   }

TMyApp::TMyApp(LPSTR AName, HINSTANCE hInstance, HINSTANCE hPrevInstance,
           LPSTR lpCmdLine, int nCmdShow)
      : TApplication(AName, hInstance, hPrevInstance, lpCmdLine, nCmdShow)
   {
   }

