// FMTINPUT.CPP
//
// Formated Input classes Function definitions.

#include <windows.h>
#include <owl.h>
#include <edit.h>
#include <string.h>
#include <alloc.h>
#include "fmtinput.h"

static BOOL GotInvalid;

static void InvalidKey()
   {
   GotInvalid=TRUE;
   MessageBeep(0);
   }

// ****************************************************************
BaseInput::BaseInput(PTWindowsObject aParent, int aId, LPSTR aTitle,
                   int X, int Y, int W, int H, WORD aLen, BOOL aMulti,
                   PTModule aModule)
              :TEdit(aParent, aId, aTitle, X, Y, W, H, aLen, aMulti, aModule)
   {
   }

BaseInput::BaseInput(PTWindowsObject aParent, int ResourceId, WORD aLen,
                   PTModule aModule)
              :TEdit(aParent, ResourceId, aLen, aModule)
   {
   }

void BaseInput::SetupWindow()
   {
   TEdit::SetupWindow();
   char temp[MAXINPUTLEN];
   GetLine(temp,MAXINPUTLEN,0);
   initial=_fstrdup(temp);
   }

#pragma argsused
void BaseInput::CMEditCut(TMessage& message)
   {
   int s,e;
   char buffer[MAXINPUTLEN];
   GetSelection(s,e);
   lstrcpy(buffer,&initial[s]);
   buffer[e-s]=0;
   DefWndProc(message);
   Insert(buffer);
   SetSelection(s,s);
   }

void BaseInput::CMEditDelete(TMessage& message)
   {
   int s,e;
   char buffer[MAXINPUTLEN];
   GetSelection(s,e);
   lstrcpy(buffer,&initial[s]);
   buffer[e-s]=0;
   DefWndProc(message);
   Insert(buffer);
   SetSelection(s,s);
   }

#pragma argsused
void BaseInput::CMEditClear(TMessage& message)
   {
   SetSelection(0,MAXINPUTLEN);
   Insert(initial);
   SetSelection(0,0);
   }

#pragma argsused
void BaseInput::CMEditPaste(TMessage& message)
   {
   GotInvalid = FALSE;
   if (IsClipboardFormatAvailable(CF_TEXT))
      {
      OpenClipboard(HWindow);
      HANDLE hmem = GetClipboardData(CF_TEXT);
      LPSTR pmem = (LPSTR) GlobalLock(hmem);
      if (pmem)
         {
         while (GotInvalid==FALSE && *pmem && *pmem!='\r')
            {
            SendMessage(HWindow,WM_CHAR,*pmem,0);
            pmem++;
            }
         GlobalUnlock(hmem);
         CloseClipboard();
         } 
      }
   }

void BaseInput::WMKEYDOWN(TMessage& message)
   {
   int s,e;
   char buffer[MAXINPUTLEN];
   char keybuf[256];
   switch (message.WParam)
      {
      case VK_INSERT:
         GetKeyboardState(keybuf);
         if (keybuf[VK_SHIFT]&0x80)
            {
            CMEditPaste(message);
            return;
            }
         break;
      case VK_DELETE:
         GetKeyboardState(keybuf);
         if (keybuf[VK_SHIFT]&0x80)
            {
            CMEditCut(message);
            return;
            }
         if (keybuf[VK_CONTROL]&0x80)
            {
            CMEditClear(message);
            return;
            }
         GetSelection(s,e);
         lstrcpy(buffer,&initial[s]);
         buffer[e-s]=0;
         Insert(buffer);
         SetSelection(s,s);
         return;
      }
   DefWndProc(message);
   }

void BaseInput::WMKEYUP(TMessage& message)
   {
   char keybuf[256];
   switch (message.WParam)
      {
      case VK_DELETE:
         GetKeyboardState(keybuf);
         if(keybuf[VK_SHIFT]&0x80 || keybuf[VK_CONTROL]&0x80)
            break;
         return;
      }
   DefWndProc(message);
   }


// ****************************************************************
SFltInput::SFltInput(PTWindowsObject aParent, int aId, LPSTR aTitle,
                   int X, int Y, int W, int H, WORD aLen, 
                   PTModule aModule)
              :TEdit(aParent, aId, aTitle, X, Y, W, H, aLen, FALSE, aModule)
   {
   }

SFltInput::SFltInput(PTWindowsObject aParent, int ResourceId, WORD aLen,
                   PTModule aModule)
              :TEdit(aParent, ResourceId, aLen, aModule)
   {
   }

void SFltInput::SetupWindow()
   {
   TEdit::SetupWindow();
   char temp[MAXINPUTLEN];
   GetLine(temp,MAXINPUTLEN,0);
   initial=_fstrdup(temp);
   }

void SFltInput::WMCHAR(TMessage& message)
   {
   int start,end,day,mon;
   char val[MAXINPUTLEN];
   GetSubText(val,0,MAXINPUTLEN);
   GetSelection(start,end);
   if (message.WParam=='-')
      {
      if (start==0 && *val!='-')
         {
         DefWndProc(message);
         return;
         }
      else if (start==0 && *val=='-')
         {
         if (end == 0)
            SetSelection(0,1);
         *val = '-';
         *(val+1)=0;
         Insert(val);
         SetSelection(1,1);
         return;
         }
      else
         {
         InvalidKey();
         return;
         }
      }
   else if (message.WParam=='.')
      {
      char * decimal;
      decimal = strchr(val,'.');
      if (decimal && decimal < &val[start])
         {
         InvalidKey();
         return;
         }
      if (decimal == val)
         {
         SetSelection(start+1,start+1);
         return;
         }
      SetSelection(start,MAXINPUTLEN);
      char tmp[3];
      *tmp = '0';
      *(tmp+1) = '.';
      *(tmp+2) = 0;
      if (start==0 || (start==1 && *val=='-'))  // At beginning so insert a '0'
         Insert(tmp);
      else
         Insert(tmp+1);
      return;
      }
   else if ((message.WParam <='9' && message.WParam >= '0') || message.WParam < ' ')
      {
      DefWndProc(message);
      }
   else
      InvalidKey();
   }


#pragma argsused
void SFltInput::CMEditPaste(TMessage& message)
   {
   GotInvalid = FALSE;
   if (IsClipboardFormatAvailable(CF_TEXT))
      {
      OpenClipboard(HWindow);
      HANDLE hmem = GetClipboardData(CF_TEXT);
      LPSTR pmem = (LPSTR) GlobalLock(hmem);
      if (pmem)
         {
         while (GotInvalid==FALSE && *pmem && *pmem!='\r')
            {
            SendMessage(HWindow,WM_CHAR,*pmem,0);
            pmem++;
            }
         GlobalUnlock(hmem);
         CloseClipboard();
         } 
      }
   }

void SFltInput::WMKEYDOWN(TMessage& message)
   {
   int s,e;
   char buffer[MAXINPUTLEN];
   char keybuf[256];
   switch (message.WParam)
      {
      case VK_INSERT:
         GetKeyboardState(keybuf);
         if (keybuf[VK_SHIFT]&0x80)
            {
            CMEditPaste(message);
            return;
            }
         break;
      }
   DefWndProc(message);
   }

void SFltInput::WMKEYUP(TMessage& message)
   {
   char keybuf[256];
   switch (message.WParam)
      {
      case VK_INSERT:
         GetKeyboardState(keybuf);
         if (keybuf[VK_SHIFT]&0x80)
            return;
      }
   DefWndProc(message);
   }

// ****************************************************************
UFltInput::UFltInput(PTWindowsObject aParent, int aId, LPSTR aTitle,
                   int X, int Y, int W, int H, WORD aLen, 
                   PTModule aModule)
              :TEdit(aParent, aId, aTitle, X, Y, W, H, aLen, FALSE, aModule)
   {
   }

UFltInput::UFltInput(PTWindowsObject aParent, int ResourceId, WORD aLen,
                   PTModule aModule)
              :TEdit(aParent, ResourceId, aLen, aModule)
   {
   }

void UFltInput::SetupWindow()
   {
   TEdit::SetupWindow();
   char temp[MAXINPUTLEN];
   GetLine(temp,MAXINPUTLEN,0);
   initial=_fstrdup(temp);
   }

void UFltInput::WMCHAR(TMessage& message)
   {
   int start,end,day,mon;
   char val[MAXINPUTLEN];
   GetSubText(val,0,MAXINPUTLEN);
   GetSelection(start,end);
   if (message.WParam=='.')
      {
      char * decimal;
      decimal = strchr(val,'.');
      if (decimal && decimal < &val[start])
         {
         InvalidKey();
         return;
         }
      if (decimal == val)
         {
         SetSelection(start+1,start+1);
         return;
         }
      SetSelection(start,MAXINPUTLEN);
      char tmp[3];
      *tmp = '0';
      *(tmp+1) = '.';
      *(tmp+2) = 0;
      if (start==0 || (start==1 && *val=='-'))  // At beginning so insert a '0'
         Insert(tmp);
      else
         Insert(tmp+1);
      return;
      }
   else if ((message.WParam <='9' && message.WParam >= '0') || message.WParam < ' ')
      {
      DefWndProc(message);
      }
   else
      InvalidKey();
   }


#pragma argsused
void UFltInput::CMEditPaste(TMessage& message)
   {
   GotInvalid = FALSE;
   if (IsClipboardFormatAvailable(CF_TEXT))
      {
      OpenClipboard(HWindow);
      HANDLE hmem = GetClipboardData(CF_TEXT);
      LPSTR pmem = (LPSTR) GlobalLock(hmem);
      if (pmem)
         {
         while (GotInvalid==FALSE && *pmem && *pmem!='\r')
            {
            SendMessage(HWindow,WM_CHAR,*pmem,0);
            pmem++;
            }
         GlobalUnlock(hmem);
         CloseClipboard();
         } 
      }
   }

void UFltInput::WMKEYDOWN(TMessage& message)
   {
   int s,e;
   char buffer[MAXINPUTLEN];
   char keybuf[256];
   switch (message.WParam)
      {
      case VK_INSERT:
         GetKeyboardState(keybuf);
         if (keybuf[VK_SHIFT]&0x80)
            {
            CMEditPaste(message);
            return;
            }
         break;
      }
   DefWndProc(message);
   }

void UFltInput::WMKEYUP(TMessage& message)
   {
   char keybuf[256];
   switch (message.WParam)
      {
      case VK_INSERT:
         GetKeyboardState(keybuf);
         if (keybuf[VK_SHIFT]&0x80)
            return;
      }
   DefWndProc(message);
   }



// ****************************************************************
SIntInput::SIntInput(PTWindowsObject aParent, int aId, LPSTR aTitle,
                   int X, int Y, int W, int H, WORD aLen,
                   PTModule aModule)
              :TEdit(aParent, aId, aTitle, X, Y, W, H, aLen, FALSE, aModule)
   {
   }

SIntInput::SIntInput(PTWindowsObject aParent, int ResourceId, WORD aLen,
                   PTModule aModule)
              :TEdit(aParent, ResourceId, aLen, aModule)
   {
   }

void SIntInput::SetupWindow()
   {
   TEdit::SetupWindow();
   char temp[MAXINPUTLEN];
   GetLine(temp,MAXINPUTLEN,0);
   initial=_fstrdup(temp);
   }

void SIntInput::WMCHAR(TMessage& message)
   {
   int start,end,day,mon;
   char val[MAXINPUTLEN];
   GetSubText(val,0,MAXINPUTLEN);
   GetSelection(start,end);
   if (message.WParam=='-')
      {
      if (start==0 && *val!='-')
         {
         DefWndProc(message);
         return;
         }
      else if (start==0 && *val=='-')
         {
         if (end == 0)
            SetSelection(0,1);
         *val = '-';
         *(val+1)=0;
         Insert(val);
         SetSelection(1,1);
         return;
         }
      else
         {
         InvalidKey();
         return;
         }
      }
   else if ((message.WParam <='9' && message.WParam >= '0') || message.WParam < ' ')
      {
      DefWndProc(message);
      }
   else
      InvalidKey();
   }


#pragma argsused
void SIntInput::CMEditPaste(TMessage& message)
   {
   GotInvalid = FALSE;
   if (IsClipboardFormatAvailable(CF_TEXT))
      {
      OpenClipboard(HWindow);
      HANDLE hmem = GetClipboardData(CF_TEXT);
      LPSTR pmem = (LPSTR) GlobalLock(hmem);
      if (pmem)
         {
         while (GotInvalid==FALSE && *pmem && *pmem!='\r')
            {
            SendMessage(HWindow,WM_CHAR,*pmem,0);
            pmem++;
            }
         GlobalUnlock(hmem);
         CloseClipboard();
         } 
      }
   }

void SIntInput::WMKEYDOWN(TMessage& message)
   {
   int s,e;
   char buffer[MAXINPUTLEN];
   char keybuf[256];
   switch (message.WParam)
      {
      case VK_INSERT:
         GetKeyboardState(keybuf);
         if (keybuf[VK_SHIFT]&0x80)
            {
            CMEditPaste(message);
            return;
            }
         break;
      }
   DefWndProc(message);
   }

void SIntInput::WMKEYUP(TMessage& message)
   {
   char keybuf[256];
   switch (message.WParam)
      {
      case VK_INSERT:
         GetKeyboardState(keybuf);
         if (keybuf[VK_SHIFT]&0x80)
            return;
      }
   DefWndProc(message);
   }

// ****************************************************************
UIntInput::UIntInput(PTWindowsObject aParent, int aId, LPSTR aTitle,
                   int X, int Y, int W, int H, WORD aLen,
                   PTModule aModule)
              :TEdit(aParent, aId, aTitle, X, Y, W, H, aLen, FALSE, aModule)
   {
   }

UIntInput::UIntInput(PTWindowsObject aParent, int ResourceId, WORD aLen,
                   PTModule aModule)
              :TEdit(aParent, ResourceId, aLen, aModule)
   {
   }

void UIntInput::SetupWindow()
   {
   TEdit::SetupWindow();
   char temp[MAXINPUTLEN];
   GetLine(temp,MAXINPUTLEN,0);
   initial=_fstrdup(temp);
   }

void UIntInput::WMCHAR(TMessage& message)
   {
   if ((message.WParam <='9' && message.WParam >= '0') || message.WParam < ' ')
      {
      DefWndProc(message);
      }
   else
      InvalidKey();
   }


#pragma argsused
void UIntInput::CMEditPaste(TMessage& message)
   {
   GotInvalid = FALSE;
   if (IsClipboardFormatAvailable(CF_TEXT))
      {
      OpenClipboard(HWindow);
      HANDLE hmem = GetClipboardData(CF_TEXT);
      LPSTR pmem = (LPSTR) GlobalLock(hmem);
      if (pmem)
         {
         while (GotInvalid==FALSE && *pmem && *pmem!='\r')
            {
            SendMessage(HWindow,WM_CHAR,*pmem,0);
            pmem++;
            }
         GlobalUnlock(hmem);
         CloseClipboard();
         } 
      }
   }

void UIntInput::WMKEYDOWN(TMessage& message)
   {
   int s,e;
   char buffer[MAXINPUTLEN];
   char keybuf[256];
   switch (message.WParam)
      {
      case VK_INSERT:
         GetKeyboardState(keybuf);
         if (keybuf[VK_SHIFT]&0x80)
            {
            CMEditPaste(message);
            return;
            }
         break;
      }
   DefWndProc(message);
   }

void UIntInput::WMKEYUP(TMessage& message)
   {
   char keybuf[256];
   switch (message.WParam)
      {
      case VK_INSERT:
         GetKeyboardState(keybuf);
         if (keybuf[VK_SHIFT]&0x80)
            return;
      }
   DefWndProc(message);
   }



// ****************************************************************
DateInput::DateInput(PTWindowsObject aParent, int aId,
                   int X, int Y, int W, int H, WORD aLen,
                   PTModule aModule)
          : BaseInput(aParent,aId,NULL
                  ,X,Y,W,H,
                  (aLen==9||aLen==11)?aLen:11,FALSE,aModule)
   {
   if (aLen==9)
      SetCaption("01/01/80");
   else
      SetCaption("01/01/1980");
   }

DateInput::DateInput(PTWindowsObject aParent, int ResourceId, WORD aLen,
                   PTModule aModule)
          : BaseInput(aParent,ResourceId,
                  (aLen==9||aLen==11)?aLen:11,aModule)
   {
   if (aLen==9)
      SetCaption("01/01/80");
   else
      SetCaption("01/01/1980");
   }
                  //  J  F  M  A  M  J  J  A  S  O  N  D
static int MonLen[]={31,29,31,30,31,30,31,31,30,31,30,31};

void DateInput::WMCHAR(TMessage& message)
   {
   int start,end,day,mon;
   char val[3];
   GetSelection(start,end);
   if (message.WParam=='/')
      {
      if (start==0 || start==2)
         SetSelection(3,3);
      else if (start==1)
         {
         GetSubText(val,0,1);
         val[1]=val[0];
         val[0]='0';
         val[2]=0;
         SetSelection(0,2);
         Insert(val);
         SetSelection(3,3);
         }
      else if (start==3 || start==5)
         SetSelection(6,6);
      else if (start==4)
         {
         GetSubText(val,3,4);
         val[1]=val[0];
         val[0]='0';
         val[2]=0;
         SetSelection(3,5);
         Insert(val);
         SetSelection(6,6);
         }
      else
         InvalidKey();
      goto leave;
      }
   else if (message.WParam <='9' && message.WParam >= '0')
      {
      if (start==2)
         start=3;
      else if (start==5)
         start=6;
      SetSelection(start,start+1);
      switch (start)
         {
         case 0: if (message.WParam=='0')
                    {
                    DefWndProc(message);
                    ResetDay();
                    goto leave;
                    }
                 else if (message.WParam=='1')
                    {
                    GetSubText(val,1,2);
                    if (*val>'2')
                       {
                       val[0]='1';
                       val[1]='0';
                       val[2]=0;
                       SetSelection(0,2);
                       Insert(val);
                       SetSelection(1,1);
                       }
                    else
                       DefWndProc(message);
                    ResetDay();
                    goto leave;
                    }
                 else
                    {
                    val[0]='0';
                    val[1]=message.WParam;
                    val[2]=0;
                    SetSelection(0,2);
                    Insert(val);
                    SetSelection(2,2);
                    ResetDay();
                    goto leave;
                    }
         case 1: GetSubText(val,0,1);
                 if ((*val=='1' && message.WParam>'2') ||
                                       (*val=='0' && message.WParam=='0'))                    {
                    InvalidKey();
                    goto leave;
                    } 
                 DefWndProc(message);
                 ResetDay();
                 goto leave;
         case 3: GetSubText(val,0,2);
                 mon = (val[0]-'0')*10+val[1]-'0';
                 if (message.WParam=='0' || message.WParam=='1'
                   || message.WParam=='2' )
                    {
                    DefWndProc(message);
                    goto leave;
                    }
                 else if(message.WParam=='3'&&mon!=2)
                    {
                    val[0]='3';
                    val[1]='0';
                    val[2]=0;
                    SetSelection(3,5);
                    Insert(val);
                    SetSelection(4,4);
                    goto leave;
                    }
                 else
                    {
                    val[0]='0';
                    val[1]=message.WParam;
                    val[2]=0;
                    SetSelection(3,5);
                    Insert(val);
                    SetSelection(5,5);
                    goto leave;
                    }
         case 4: GetSubText(val,0,2);
                 mon = (val[0]-'0')*10+val[1]-'0';
                 GetSubText(val,3,4);
                 int day = (val[0]-'0')*10+message.WParam-'0';
                 if (day>MonLen[mon-1] || day==0)
                    {
                    InvalidKey();
                    goto leave;
                    } 
                 DefWndProc(message);
                 goto leave;
         default: DefWndProc(message);
                 goto leave;
         }
      }
   else if (message.WParam == '\b')
      {
      if (start!=0)
         SetSelection(start-1,start-1);
         goto leave;
      }
   else if (message.WParam < ' ')
      {
      DefWndProc(message);
      }
   else
      InvalidKey();
leave:
   GetSelection(start,end);
   SetSelection(start,start);
   }

void DateInput::ResetDay()
   {
   char val[3];

   GetSubText(val,0,2);
   int mon = (val[0]-'0')*10+val[1]-'0';
   GetSubText(val,3,5);
   int day = (val[0]-'0')*10+val[1]-'0';
   if (day>MonLen[mon-1])
      {
      int s,e;
      GetSelection(s, e);
      SetSelection(3,4);
      Insert("01");
      SetSelection(s,e);
      }
   }

// ****************************************************************
TimeInput::TimeInput(PTWindowsObject aParent, int aId,
                   int X, int Y, int W, int H, WORD aLen,
                   BOOL aType, PTModule aModule)
          : BaseInput(aParent,aId,NULL,X,Y,W,H,
                  (aLen==6||aLen==9)?aLen:6,FALSE,aModule)
   {
   Hour24 = aType;
   if (aLen==9)
      SetCaption("00:00:00");
   else
      SetCaption("00:00");
   }

TimeInput::TimeInput(PTWindowsObject aParent, int ResourceId, WORD aLen,
                   BOOL aType,PTModule aModule)
          : BaseInput(aParent,ResourceId,
                  (aLen==6||aLen==9)?aLen:6,aModule)
   {
   Hour24 = aType;
   if (aLen==9)
      SetCaption("00:00:00");
   else
      SetCaption("00:00");
   }

void TimeInput::WMCHAR(TMessage& message)
   {
   int start,end,day,mon;
   char val[3];
   GetSelection(start,end);
   if (message.WParam==':')
      {
      if (start==0 || start==2)
         SetSelection(3,3);
      else if (start==1)
         {
         GetSubText(val,0,1);
         val[1]=val[0];
         val[0]='0';
         val[2]=0;
         SetSelection(0,2);
         Insert(val);
         SetSelection(3,3);
         }
      else if (start<6)
         SetSelection(6,6);
      else
         InvalidKey();
      goto leave;
      }
   else if (message.WParam <='9' && message.WParam >= '0')
      {
      if (start==2)
         start=3;
      else if (start==5)
         start=6;
      SetSelection(start,start+1);
      switch (start)
         {
         case 0: if ((Hour24 && (message.WParam=='0'||message.WParam=='1'))
                         || (!Hour24 && message.WParam=='0'))
                    {
                    DefWndProc(message);
                    goto leave;
                    }
                 else if (message.WParam=='1')   // HOUR24 must be FALSE
                    {
                    GetSubText(val,1,2);
                    if (*val>'2')
                       {
                       val[0]='1';
                       val[1]='0';
                       SetSelection(0,2);
                       Insert(val);
                       SetSelection(1,2);
                       }
                    else
                       DefWndProc(message);
                    goto leave;
                    }
                 else if (message.WParam=='2' && Hour24)
                    {
                    GetSubText(val,1,2);
                    if (*val>'4')
                       {
                       val[0]='2';
                       val[1]='0';
                       SetSelection(0,2);
                       Insert(val);
                       SetSelection(1,2);
                       }
                    else
                       DefWndProc(message);
                    goto leave;
                    }
                 else
                    {
                    val[0]='0';
                    val[1]=message.WParam;
                    val[2]=0;
                    SetSelection(0,2);
                    Insert(val);
                    SetSelection(2,2);
                    goto leave;
                    }
         case 1: GetSubText(val,0,1);
                 if (!Hour24 && *val=='1' && message.WParam>'2')
                    {
                    InvalidKey();
                    goto leave;
                    } 
                 else if (Hour24 && *val=='2' && message.WParam>'4')
                    {
                    InvalidKey();
                    goto leave;
                    } 
                 DefWndProc(message);
                 goto leave;
         case 6:
         case 3: if (message.WParam>='0'&&message.WParam<='5')
                    {
                    DefWndProc(message);
                    goto leave;
                    }
                 else
                    {
                    val[0]='0';
                    val[1]=message.WParam;
                    val[2]=0;
                    SetSelection(start,start+2);
                    Insert(val);
                    SetSelection(start+3,start+3);
                    goto leave;
                    }
         default: DefWndProc(message);
                 goto leave;
         }
      }
   else if (message.WParam == '\b')
      {
      if (start!=0)
         SetSelection(start-1,start-1);
         goto leave;
      }
   else if (message.WParam < ' ')
      {
      DefWndProc(message);
      }
   else
      InvalidKey();
leave:
   GetSelection(start,end);
   SetSelection(start,start);
   }

// ****************************************************************
PictInput::PictInput(PTWindowsObject aParent, int aId,
                   int X, int Y, int W, int H,
                   LPSTR aText, LPSTR aPict, WORD aLen,
                   PTModule aModule)
          : BaseInput(aParent,aId,aText,X,Y,W,H,
                  aLen,FALSE,aModule)
   {
   Templet = _fstrdup(_fstrupr(aPict));
   }

PictInput::PictInput(PTWindowsObject aParent, int ResourceId,
                   LPSTR aPict, WORD aLen,
                   PTModule aModule)
          : BaseInput(aParent,ResourceId,
                  aLen,aModule)
   {
   Templet = _fstrdup(_fstrupr(aPict));
   }

PictInput::~PictInput()
   {
   farfree(Templet);
   }

void PictInput::WMCHAR(TMessage& message)
   {
   int start,end,day,mon;
   int c;
   TMessage backup;
   GetSelection(start,end);
   if ((c=message.WParam)>=' ')
      {
      if (!strchr("X#A9N",Templet[start]))
         {
         if (c==Templet[start])
            {
            SetSelection(start+1,start+1);
            goto leave;
            }
         else
            while(!strchr("X#A9N",Templet[start])&& start<_fstrlen(Templet))
               start++;
         }
      SetSelection(start,start+1);
      switch (Templet[start])
         {
         case 'X': DefWndProc(message);
                   goto leave;
         case 'A': if ((c>='A'&&c<='Z') || (c>='a'&&c<='z'))
                      {
                      DefWndProc(message);
                      goto leave;
                      }
                   else
                      break;
         case '#': if ((c>='0'&&c<='9') || (c==' '))
                      {
                      DefWndProc(message);
                      goto leave;
                      }
                   else
                      break;

         case '9': if (c>='0'&&c<='9')
                      {
                      DefWndProc(message);
                      goto leave;
                      }
                   else
                      break;

         case 'N': if ((c>='A'&&c<='Z') || (c>='a'&&c<='z') || (c>='0'&&c<='9'))
                      {
                      DefWndProc(message);
                      goto leave;
                      }
                   else
                      break;
         }
      char FAR *current=&Templet[start];
      char FAR *loc;
#pragma warn -pia
      if (!strchr("X#A9N",c)     // Special characters can not be fixed chars
         && (loc=_fstrchr(current,c)))
#pragma warn +pia
         {
         SetSelection(loc-Templet+1, loc-Templet+1);
         }
      else
         {
         InvalidKey();
         }
      }
   else if (message.WParam == '\b')
      {
      if (start!=0)
         SetSelection(start-1,start-1);
         goto leave;
      }
   else
      {
      DefWndProc(message);
      }
leave:
   GetSelection(start,end);
   SetSelection(start,start);
   }

// ****************************************************************
PhoneInput::PhoneInput(PTWindowsObject aParent, int aId,
                   int X, int Y, int W, int H, PTModule aModule)
          : PictInput(aParent,aId,X,Y,W,H,"(   )   -    ","(###)999-9999",
                   15,aModule)
   {
   }

PhoneInput::PhoneInput(PTWindowsObject aParent, int ResourceId, PTModule aModule)
          : PictInput(aParent,ResourceId,
                   "(###)999-9999",15,aModule)
   {
   }

