// FMTINPUT.H
//
// Class declarations for formated input types. Does key by key input
// validation
//

#define MAXINPUTLEN 128

class BaseInput : public TEdit {
   public:
      BaseInput(PTWindowsObject aParent, int aId, LPSTR aTitle,
                   int X, int Y, int W, int H, WORD aLen, BOOL multi,
                   PTModule aModule = NULL);
      BaseInput(PTWindowsObject aParent, int ResourceId, WORD aLen,
                   PTModule aModule = NULL);
   protected:
      virtual void SetupWindow();
   private:
      LPSTR initial;
      virtual void WMKEYUP(TMessage& message)=[WM_FIRST+WM_KEYUP];
      virtual void WMKEYDOWN(TMessage& message)=[WM_FIRST+WM_KEYDOWN];
      virtual void CMEditDelete(TMessage& message)=[CM_FIRST+CM_EDITDELETE];
      virtual void CMEditCut(TMessage& message)=[CM_FIRST+CM_EDITCUT];
      virtual void CMEditClear(TMessage& message)=[CM_FIRST+CM_EDITCLEAR];
      virtual void CMEditPaste(TMessage& message)=[CM_FIRST+CM_EDITPASTE];
   };

// SFLTINPUT - Allows data entry of positive and negitive floating point
//   numbers 
class SFltInput : public TEdit {
   public:
      SFltInput(PTWindowsObject aParent, int aId, LPSTR aTitle,
                   int X, int Y, int W, int H, WORD aLen,
                   PTModule aModule = NULL);
      SFltInput(PTWindowsObject aParent, int ResourceId, WORD aLen,
                   PTModule aModule = NULL);
   protected:
      virtual void SetupWindow();
   private:
      LPSTR initial;
      virtual void WMKEYUP(TMessage& message)=[WM_FIRST+WM_KEYUP];
      virtual void WMKEYDOWN(TMessage& message)=[WM_FIRST+WM_KEYDOWN];
      virtual void WMCHAR(TMessage& message)=[WM_FIRST+WM_CHAR];
      virtual void CMEditPaste(TMessage& message)=[CM_FIRST+CM_EDITPASTE];
   };

// UFLTINPUT - Allows data entry of positive floating point numbers 
class UFltInput : public TEdit {
   public:
      UFltInput(PTWindowsObject aParent, int aId, LPSTR aTitle,
                   int X, int Y, int W, int H, WORD aLen,
                   PTModule aModule = NULL);
      UFltInput(PTWindowsObject aParent, int ResourceId, WORD aLen,
                   PTModule aModule = NULL);
   protected:
      virtual void SetupWindow();
   private:
      LPSTR initial;
      virtual void WMKEYUP(TMessage& message)=[WM_FIRST+WM_KEYUP];
      virtual void WMKEYDOWN(TMessage& message)=[WM_FIRST+WM_KEYDOWN];
      virtual void WMCHAR(TMessage& message)=[WM_FIRST+WM_CHAR];
      virtual void CMEditPaste(TMessage& message)=[CM_FIRST+CM_EDITPASTE];
   };

// SINTINPUT - Allows data entry of positive and negitive integers
class SIntInput : public TEdit {
   public:
      SIntInput(PTWindowsObject aParent, int aId, LPSTR aTitle,
                   int X, int Y, int W, int H, WORD aLen,
                   PTModule aModule = NULL);
      SIntInput(PTWindowsObject aParent, int ResourceId, WORD aLen,
                   PTModule aModule = NULL);
   protected:
      virtual void SetupWindow();
   private:
      LPSTR initial;
      virtual void WMKEYUP(TMessage& message)=[WM_FIRST+WM_KEYUP];
      virtual void WMKEYDOWN(TMessage& message)=[WM_FIRST+WM_KEYDOWN];
      virtual void WMCHAR(TMessage& message)=[WM_FIRST+WM_CHAR];
      virtual void CMEditPaste(TMessage& message)=[CM_FIRST+CM_EDITPASTE];
   };

// UNITINPUT - Allows data entry of postive integers
class UIntInput : public TEdit {
   public:
      UIntInput(PTWindowsObject aParent, int aId, LPSTR aTitle,
                   int X, int Y, int W, int H, WORD aLen,
                   PTModule aModule = NULL);
      UIntInput(PTWindowsObject aParent, int ResourceId, WORD aLen,
                   PTModule aModule = NULL);
   protected:
      virtual void SetupWindow();
   private:
      LPSTR initial;
      virtual void WMKEYUP(TMessage& message)=[WM_FIRST+WM_KEYUP];
      virtual void WMKEYDOWN(TMessage& message)=[WM_FIRST+WM_KEYDOWN];
      virtual void WMCHAR(TMessage& message)=[WM_FIRST+WM_CHAR];
      virtual void CMEditPaste(TMessage& message)=[CM_FIRST+CM_EDITPASTE];
   };

// DATEINPUT - Allows data entry in the form of "mm/dd/yyyy".  By setting
//   length to 8 two digit year will be used.

class DateInput : public BaseInput {
   public:
      DateInput(PTWindowsObject aParent, int aId, int X, int Y,
                   int W, int H, WORD aLen,
                   PTModule aModule = NULL);
      DateInput(PTWindowsObject aParent, int ResourceId, WORD aLen,
                   PTModule aModule = NULL);
   private:
      void ResetDay();
      virtual void WMCHAR(TMessage& message)=[WM_FIRST+WM_CHAR];
};


// TimeInput - Allows data entry in the form of "hh:mm:ss"  By setting
//   length to 6 no seconds will be input.

class TimeInput : public BaseInput {
   public:
      TimeInput(PTWindowsObject aParent, int aId, int X, int Y,
                   int W, int H, WORD aLen,
                   BOOL aType=FALSE, PTModule aModule = NULL);
      TimeInput(PTWindowsObject aParent, int ResourceId, WORD aLen,
                   BOOL aType=FALSE, PTModule aModule = NULL);
   private:
      BOOL Hour24;
      virtual void WMCHAR(TMessage& message)=[WM_FIRST+WM_CHAR];
};

// PICTINPUT - Allows data entry in the formatting by matching a "picture".
//   Templet characters with special meaning.
//   # - blanks or numeric entry allowed
//   A - Alpha characters only
//   9 - numeric entry
//   X - any characters allowed.
//   N - Alpha or numeric
//   Any other chararter will be automatically entered.

class PictInput : public BaseInput {
   public:
      PictInput(PTWindowsObject aParent, int aId, int X, int Y,
                   int W, int H, LPSTR aText, LPSTR aPICT, WORD aLen,
                   PTModule aModule = NULL);
      PictInput(PTWindowsObject aParent, int ResourceId, LPSTR aPICT, WORD aLen,
                   PTModule aModule = NULL);
      ~PictInput();
   private:
      LPSTR Templet;
      virtual void WMCHAR(TMessage& message)=[WM_FIRST+WM_CHAR];
};

// PHONEINPUT Picture input field predefined with a phone format
class PhoneInput : public PictInput {
   public:
      PhoneInput(PTWindowsObject aParent, int aId, int X, int Y,
                   int W, int H, PTModule aModule = NULL);
      PhoneInput(PTWindowsObject aParent, int ResourceId,
                   PTModule aModule = NULL);
};
