;copystru.asm - contains i86_even_copy.

	dosseg
	.model	large
	.code


;i86_even_copy(source, dest, count)
;Copy count bytes from source to dest.	Count must be even as copy is 
;done 16 bits at a time.  Zero counts will trash memory.
    PUBLIC _i86_even_copy
;copy 
_i86_even_copy PROC far
	push	bp
	mov	bp,sp
	push di
	push ds
	push es
	push si
	push cx

	mov	ax,[bp+6+2]	;s seg
	mov ds,ax
	mov	si,[bp+4+2]	;s offset
	mov ax,[bp+10+2]  ;d seg
	mov es,ax
	mov di,[bp+8+2]  ;d offset
	mov cx,[bp+12+2]  ;count
	shr cx,1

	cld
	rep movsw

	pop cx
	pop si
	pop es
	pop ds
	pop di
	pop	bp
	ret	
_i86_even_copy ENDP

END
